unsigned	mask[] = {
	0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, 32767, 65535
};
char	*var="_rrcput";

	struct {
		int speed, ek;
		int flags;
	}tty;
struct	nl {
	char nm[8];
	int  type;
	int  value;
} nl[2];

int	intr();
int	tek;
unsigned	tab[256];
unsigned	ntab[256];

main(argc, argv)
char **argv;
{
	int mem;
	register i;
	register char *s, *t;
	unsigned *ptab, *otab;
	unsigned total;
	int verbose;

	verbose = (argc > 1);
	s = &nl[0];
	gtty(1, &tty);
	tek = tty.ek;
	signal(2, intr);
	t = var;
	while(*s++ = *t++);
	nlist("/unix", nl);
	if(nl[0].type < 0){
		printf("No namelist entry\n");
		exit(1);
	}
	if((mem = open("/dev/mem", 0)) == -1){
		printf("No mem.\n");
		exit(2);
	}

	seek(mem, nl[0].value, 0);
	read(mem, tab, 512);
	otab = tab;
	ptab = ntab;
	while(1){
		sleep(1);
		seek(mem, nl[0].value, 0);
		read(mem, ptab, 512);
		for(total=0, i=0; i < 256; i++){
			total += abs(ptab[i]-otab[i]);
		}
		total = (unsigned)((long)(abs(ptab[0]-otab[0]))*16L/(long)(total));
		if(total > 16){
			printf("total = %u\n", total);
			total=16;
		}
		tty.ek = mask[total];
		stty(1, &tty);
		if(verbose)pbin(tty.ek);
		if(ptab == tab){
			ptab = ntab;
			otab = tab;
		} else	{
			ptab = tab;
			otab = ntab;
		}
	}
}

intr()
{
	tty.ek = tek;
	stty(1, &tty);
	exit(1);
}


abs(i)
{
	if(i<0)return(-i);else return(i);
}

pbin(x)
unsigned x;
{
	register unsigned i;

	for(i=0100000; i >= 1; i >>= 1){
		printf("%c", x & i ? '1' : '0');
	}
	printf("\n");
}
