/* @(#)inode.h	1.1 */
/*
 * The I node is the focus of all
 * file activity in unix. There is a unique
 * inode allocated for each active file,
 * each current directory, each mounted-on
 * file, text file, and the root. An inode is 'named'
 * by its dev/inumber pair. (iget/iget.c)
 * Data, from mode on, is read in
 * from permanent inode on volume.
 */

/*
 * In param.h,
 * Define BLK16 for 16 bit blocks only (IBLK)
 */

#define	NADDR	13
#ifdef	BLK16
#define	NSADDR	(NADDR*sizeof(ushort)/sizeof(short))
#else
#define	NSADDR	(NADDR*sizeof(daddr_t)/sizeof(short))
#endif

struct	inode
{
	char	i_flag;
	cnt_t	i_count;	/* reference count */
	dev_t	i_dev;		/* device where inode resides */
	ino_t	i_number;	/* i number, 1-to-1 with device address */
	ushort	i_mode;
	short	i_nlink;	/* directory entries */
	ushort	i_uid;		/* owner */
	ushort	i_gid;		/* group of owner */
	off_t	i_size;		/* size of file */
	struct {
		union {
#ifdef	BLK16
			ushort *i_a;	/* if normal file/directory */
#else
			daddr_t	*i_a;	/* if normal file/directory */
#endif
			short	*i_f;	/* if fifo's */
			dev_t	i_r;	/* if special */
		} i_p;
		daddr_t	i_l;		/* last logical block read (for read-ahead) */
	}i_blks;
};


extern struct inode inode[];	/* The inode table itself */
#ifdef	BLK16
extern ushort iblk[][NADDR];	/* Inode block cache */
#else
extern daddr_t iblk[][NADDR];	/* Inode block cache */
#endif

/* flags */
#define	ILOCK	01		/* inode is locked */
#define	IUPD	02		/* file has been modified */
#define	IACC	04		/* inode access time to be updated */
#define	IMOUNT	010		/* inode is mounted on */
#define	IWANT	020		/* some process waiting on lock */
#define	ITEXT	040		/* inode is pure text prototype */
#define	ICHG	0100		/* inode has been changed */
#define	IADDR	0200		/* i_a points to iblk addrs */

/* modes */
#define	IFMT	0170000		/* type of file */
#define		IFREE	0000000	/* Free */
#define		IFDIR	0040000	/* directory */
#define		IFCHR	0020000	/* character special */
#define		IFBLK	0060000	/* block special */
#define		IFREG	0100000	/* regular */
#define		IFMPC	0030000	/* multiplexed char special */
#define		IFMPB	0070000	/* multiplexed block special */
#define		IFIFO	0010000	/* fifo special */
#define	ISUID	04000		/* set user id on execution */
#define	ISGID	02000		/* set group id on execution */
#define	ISVTX	01000		/* save swapped text even after use */
#define	IREAD	0400		/* read, write, execute permissions */
#define	IWRITE	0200
#define	IEXEC	0100

#define	i_addr	i_blks.i_p.i_a
#define	i_lastr	i_blks.i_l
#define	i_rdev	i_blks.i_p.i_r

#define	i_faddr	i_blks.i_p.i_a
#ifdef	BLK16
#define	NFADDR	8	/* would run out of iblk space! */
#else
#define	NFADDR	10
#endif
#define	PIPSIZ	NFADDR*BSIZE
#define	i_frptr	i_blks.i_p.i_f[NSADDR-5]
#define	i_fwptr	i_blks.i_p.i_f[NSADDR-4]
#define	i_frcnt	i_blks.i_p.i_f[NSADDR-3]
#define	i_fwcnt	i_blks.i_p.i_f[NSADDR-2]
#define	i_fflag	i_blks.i_p.i_f[NSADDR-1]
#define	IFIR	01
#define	IFIW	02
