/* $Header: /src/bin/make/m/defs.h,v 4.7 84/04/24 21:04:01 crl Exp $ */

/*
 * $Log:	/src/bin/make/m/defs.h,v $
 * Revision 4.7  84/04/24  21:04:01  crl
 * Added declaration for progname.
 * 
 * Revision 4.6  83/12/11  23:40:27  crl
 * Added define for BSD4_2
 * Increase some buffer sizes for 4.2 BSD.
 * Modified to use new directory routines and changed to pass through
 * 	lint better.
 * 
 * Revision 4.5  83/10/31  01:09:04  crl
 * Removed isrcs from nameblock and added RCSnamep.
 * 
 * Revision 4.4  83/10/22  19:22:30  crl
 * Added field isrcs to nameblock.
 * Removed CO_CMD since this is now done via a rule.
 * 
 * Revision 4.3  83/07/23  14:35:59  crl
 * Added rmchain declaration and removed TIMETYPE typedef--use the
 * 	time_t typedef in sys/types.h
 * 
 * Revision 4.2  83/07/22  14:13:40  crl
 * Made to work transparently with RCS.
 * 
 * Revision 4.1  83/03/01  00:44:32  crl
 * Vanilla 4.1 version
 */

/*
 * Configuration section
 */
#define vfork fork			/* if no vfork() */
/* #define METERFILE "/usr/adm/meter" 	/* define to enable metering */
#define SHELLCOM "/bin/sh"		/* default shell */
/* #define SHELLENV			/* use env. var. SHELL instead */
/* #define ASCARCH			/* use 4.1 bsd ASCII archives files */
#define PROMPT	"$ "			/* printed before cmds executed */
#define RCS	"RCS"			/* name of RCS dir, or no RCS features
					 * if undefined */
#define RCS_SUF	",v"			/* suffix of RCS files */
/* #define BSD4_2			/* if running 4.2 BSD */

/*
 * Include files - we do this here since it makes a difference on the
 * 	values above 
 * Check the name of the include file usually called ndir.h -- 
 *	it is the include file for the ndir library that emulates
 *	4.2 BSD's new directories
 */
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>

#ifdef BSD4_2
# include <sys/dir.h>
#else
# include <ndir.h>			/* some call this dir.h */
#endif

/*
 * define FSTATIC to be static on systems with C compilers
 * supporting file-static; otherwise define it to be null
 */
#define FSTATIC static

#define NO	0
#define YES	1

#define unequal strcmp

#define HASHSIZE 1021			/* size of nameblock hash table */
#define NLEFTS	512			/* max # of targets on a line */
#define INMAX	2500			/* max chars in a makefile line */
#define MAXDIR	10			/* max open directories */

#ifdef BSD4_2			/* give 4.2 more for larger filenames */
# define OUTMAX		5000		/* max chars in a shell cmd */
# define QBUFMAX	5000		/* max chars in a $? */
# define MAXPATH	2048		/* max # of chars in a pathname */
#else
# define OUTMAX		3500
# define QBUFMAX	2500
# define MAXPATH	128
#endif

#define ALLDEPS  1			/* single ':' dependents */
#define SOMEDEPS 2			/* double ':' case */

#define META	01			/* char is a shell meta-char */
#define TERMINAL 02			/* terminates a token */

#define ALLOC(x) (struct x *) ckalloc(sizeof(struct x))

/*
 * RCS-specific declarations
 */
#ifdef RCS
extern int	coflag;			/* auto-checkout flag */
extern int	rmflag;			/* auto-remove flag */
extern struct shblock *co_cmd;		/* auto-checkout shell command */
extern char	*RCSdir;		/* name of RCS dir */
extern char	*RCSsuf; 		/* suffix of RCS files */
extern int	dotRCS;			/* true if ./RCS exists */
#endif

extern char	funny[128];		/* marks each char TERMINAL/META */
extern char	*prompt;		/* prompt string */
extern char	*progname;		/* tail of argv[0] */
extern int	dbgflag;		/* -d flag */
extern int	ignerr;			/* -i flag */
extern int	inarglist;		/* set noreset flag in vars if true */
extern int	keepgoing;		/* -k flag */
extern int	ndocoms;		/* # of calls to docom() */
extern int	noexflag;		/* -n flag */
extern int	nopdir;			/* # of open directories */
extern int	noruleflag;		/* -r flag */
extern int	okdel;			/* ok to delete $@ */
extern int	prtrflag;		/* -p flag */
extern int	questflag;		/* -q flag */
extern int	sigivalue;		/* true if SIGINT ignored */
extern int	sigqvalue;		/*  "   "  SIGQUIT   "    */
extern int	sighvalue;		/*  "   "  SIGHUP    "    */
extern int	sigtvalue;		/*  "   "  SIGTERM   "    */
extern int	silflag;		/* -s flag */
extern int	touchflag;		/* -t flag */
extern int	waitpid;		/* pid of child */

struct nameblock {
	struct nameblock *nxtnameblock;
	char *namep;
	struct lineblock *linep;
	unsigned done:3;
	unsigned septype:3;
#ifdef RCS
	char *RCSnamep;			/* name of RCS file, if needed */
#endif
	time_t modtime;
};
extern struct nameblock *mainname;
extern struct nameblock *firstname;

struct lineblock {
	struct lineblock *nxtlineblock;
	struct depblock *depp;
	struct shblock *shp;
};
extern struct lineblock *sufflist;

struct depblock {
	struct depblock *nxtdepblock;
	struct nameblock *depname;
};

struct shblock {
	struct shblock *nxtshblock;
	char *shbp;
};

struct varblock {
	struct varblock *nxtvarblock;
	char *varname;
	char *varval;
	unsigned noreset:1;
	unsigned used:1;
};
extern struct varblock *firstvar;

struct pattern {
	struct pattern *nxtpattern;
	char *patval;
};
extern struct pattern *firstpat;

struct opendir {
	struct opendir *nxtopendir;
	DIR * dirfc;
	char *dirn;
};
extern struct opendir *firstod;


struct chain {
	struct chain *nextp;
	char *datap;
};
#ifdef RCS
extern struct chain *rmchain;
#endif

FILE	*fopen();
time_t	exists();
time_t	lookarch();
time_t	time();
char	*concat();
char	*copys();
char	*ctime();
char	*calloc();
char	*mkqlist();
char	*rindex();
char	*subst();
int	*ckalloc();
long	atol();
struct chain	*appendq();
struct depblock	*srchdir();
struct nameblock *makename();
struct nameblock *srchname();
struct varblock *varptr();

#ifdef RCS
time_t	getrcs();
char	*ncat();
#endif
