

/*
 *	Polytechnic UNIX accounting Package - Program: mk360money.c
 *
 *	Author:	John Buck
 *	Polytechnic Institute NY, September 1981
 *
 *	Program Description:
 *		Will make the file that contains the up to date 360 allocation
 *		of the given uid/gid pair.
 *
 */





struct	a360	{
	char accn[10];
	char edat[10];
	float amnt;
}a360[500];


main(c,v)
char **v;
{
	char rbuf[514] , line[32];
	register char *s , *t;
	int fd, r;
	register struct a360 *pa;

	if(c != 2)exit(2);

	if((fd = open(*++v, 0)) == -1){
		printf("mk360money: no %s\n");
		exit(1);
	}

	pa = &a360[0];
	t = line;
	while(r = read(fd,rbuf,512)){
		s = rbuf;
		s[r] = 0;
		while(*s){
			if((*t++ = *s++) != '\n')continue;
			*(t-1) = 0;
			t = line;
			if(copy(pa, line))pa++;
		}
	}
	pa->accn[0] = 0;
	close(fd);
	if((fd = creat("/accting/acctmoney", 0600)) != -1){
		write(fd, &a360, 12000);
		close(fd);
	}
}

copy(pa, l)
register struct a360 *pa;
register char *l;
{
	float nval();
	register struct a360 *ip;

	for(ip = &a360[0]; ip < pa; ip++)
		if(eql(ip->accn, l))return(0);
	copyn(pa->accn, l);
	copyn(pa->edat, l+9);
	pa->amnt = nval(l+18);
	return(1);
}

copyn(s,t)
register char *s, *t;
{
	register i;
	for(i = 0; i < 8; i++)*s++ = *t++;
	*s = 0;
}

float nval(pp)
register char *pp;
{
	float ans, sign;
	char st;
	ans = 0.0;
	st = *pp++;
	pp++;
	while(*pp == ' ' || *pp == '	')pp++;
	sign = 1.0;
	if(*pp == '-'){
		pp++;
		sign = -1.0;
	}
	while(*pp){
		if(*pp >= '0' && *pp <= '9')
			ans = ans * 10.0 + (float)(*pp - '0');
		pp++;
	}
	ans =/ 100.0;
	return(ans*sign);
}

eql(s,t)
register char *s, *t;
{
	register i;
	for(i = 0; i < 8; i++)if(*s++ != *t++)return(0);
	return(1);
}

