

/*
 *	Polytechnic UNIX accounting Package - Program: updt.c
 *
 *	Author:	John Buck
 *	Polytechnic Institute NY, September 1981
 *
 *	Program Description:
 *		Program will take the status byte in the return data
 *		from the 360, and place it in the appropriate field
 *		in the appropriate /etc/passwd entry for the uid/gid pair.
 *
 */

#include	"actrecs.h"

struct	tab {
	short	tuid;
	short	tgid;
	char	tstatus;
	char	tpad;
} tab[1000];

char	ibuf[10752];
short	nacct = 0;

main()
{
	readin();
	update();
	exit(0);
}

readin()
{
	int fd, r;
	register n;
	register struct ibment *ip, *lp;

	if((fd = open(IBMFILE, 0)) == -1){
		write(2, "Open error on IBMFILE\n", 20);
		return;
	}
	n = 0;
	while((r = read(fd, ibuf, 10752))%IREAD == 0 && r){
		for(lp = &ibuf[r], ip=ibuf; ip < lp; ip++){
			if(ip->send == 'X')continue;
			tab[n].tuid = num(ip->uid);
			tab[n].tgid = num(ip->gid);
			tab[n++].tstatus = ip->status;
		}
	}
	close(fd);
	nacct = n;
}



update(){
	register r;
	register char *s , *t;
	char c;

	static char buf[514] , line[128];
	int fd , i;

	if((fd = open("/etc/passwd",0)) == -1)exit(20);
	t = line;

	while((r = read(fd,buf,512)) > 0){
		s = buf;
		s[r] = 0;
		while(*s){
			if((*t++ = *s++) != '\n')continue;
			*t = 0;
			t = line;
			while(*t != ':' && *t)t++;
			if(*t++ == 0)exit(15);
			while(*t != ':' && *t)t++;
			if(*t++ == 0)exit(14);
			if((r = num(t)) < 0)exit(12);
			while(*t != ':' && *t)t++;
			if(*t++ == 0)exit(11);
			if((i = num(t)) < 0)exit(10);
			while(*t != ':' && *t)t++;
			if(*t++ == 0)exit(9);
			c = getstat(i,r);
			if(c != '-' && *t != 'V' && *t != 'R')*t = c;
			printf("%s",line);
			t = line;
		}
	}
	close(fd);
	return(0);
}



getstat(g,u)
register g,u;
{
	register i;
	for(i = 0; i < nacct; i++){
		if((tab[i].tuid == -1 || tab[i].tuid == u) &&
		   (tab[i].tgid == -1 || tab[i].tgid == g))
			return(tab[i].tstatus);
	}
	return('-');
}

num(s)
register char *s;
{
	register i;
	i = 0;
	if(*s < '0' || *s > '9')return(-1);
	while(*s >= '0' && *s <= '9')i = i * 10 + *s++ - '0';
	return(i);
}

