
#include	"tron.h"

/*
 * getnew() - generates list of things that changed since
 *	last time tron was run.  It gets this info from the 're:' fields
 *	in SYSLOG.  It remembers where it left of last time by a pointer
 *	kept in LASTSYSLOG.
 */

getnew()
{
	FILE *fp;
	struct stat statb;
	short fd;
	long so, no;
	register char *s, *t, *l;
	static char buf[256];

	if((fd = open(LASTSYSLOG, 0)) == -1)
		so = 0;
	else	{
		if(read(fd, &so, 4) != 4)
			so = 0;
		close(fd);
	}

	if(stat(SYSLOG, &statb) == -1)
		no = 0;
	else	no = statb.st_size;
	if(no < so)
		so = 0;
	if((fd = creat(LASTSYSLOG, 0600)) != -1){
		write(fd, &no, 4);
		close(fd);
	}
	if(no == 0 || no == so)
		return(0);

	if((fp = fopen(SYSLOG, "r")) == 0)
		return(0);
	if(fseek(fp, so, 0) == -1){
		fclose(fp);
		return(0);
	}

	nth = 0;
	while(s = fgets(buf, 255, fp)){
		if(((*s++) | 040) != 'r' ||
		   ((*s++) | 040) != 'e' ||
		   ((*s++) | 040) != ':')
			continue;
		if(nth == 0){
			t = newthings[0];
			l = &newthings[0][THINGLEN];
			nth = 1;
		}
		while(*s){
			if(!isalpha(*s)){
				s++;
				if(t < l)
					*t = 0;
				if(t != newthings[nth-1] && nothere(newthings[nth-1])){
					if(nth >= NTHING){
						fprintf(stdout, "tron: Table of changed things is full.\n");
						fclose(fp);
						return(0);
					}
					t = newthings[nth];
					l = &newthings[nth++][THINGLEN];
				}
				else	t = newthings[nth-1];
				continue;
			}
			if(t < l)
				*t++ = *s;
			s++;
		}
		if(t < l)
			*t = 0;
	}
	fclose(fp);
	return(0);
}

nothere(s)
register char *s;
{
	register short i;

	for(i = nth-2; i >= 0; i--)
		if(strncmp(s, newthings[i], THINGLEN) == 0)
			return(0);
	return(1);
}

