/******************************************************************************
 *
 * 	METAL/Z-Msg library functions
 *
 *	FILE: MELIB.C
 *
 *
 *	Z-Msg, Metal and Metal Message System are Trademarked and
 *		   Copyright (c) 1984,1985  Tim Gary
 *			    All rights reserved.
 *
 *
 *	Common utility finctions used in METAL/Z-MSG
 *
 ******************************************************************************
 *
 * 1.31a  10/13/85 Release version.  Includes the following changes:
 *		   link_prog(name), go_os(f), and hangup() routines.
 *		   New method of reading the clock (use asm insert routines)
 *		   Real tabs for typed text (8 char stops).
 *		   ^E echo surpress.  ^O abort in typing files.
 *		   Run com file on exit from bbs (bye or cpm).
 *		   General code cleanup.
 *		   NAME CHANGE!
 * 1.30xx 7/07/85  QX10 routine fixed...
 * 1.30xx 7/01/85  Echo toggle with ^E implemented..
 * 1.30xx 6/23/85  Sysop ^P thing for list output added, new qx10 clock stuff.
 * 1.30xx 6/19/85  Findbye put back..
 * 1.30xx 6/12/85  Modified new date routine to check if ;y was entered earlier
 * 1.30xx 6/09/85  Enf of line bell every other char after linelen-8
 * 1.30xx 5/02/85  Modified Date question to only accept y/n answers.
 * 1.30xx 3/07/85  LinkBye added for use in cpm 8/16 systems for hanging up.
 * 1.30xx 3/04/85  LF's converted to spaces in getl..
 * 1.30xx 2/26/85  ZCPR3 Support added, and old RESETDRIVE stuff deleted.
 * 1.20b 01/13/85  MM58167A Kenmore Computer Tech. clock board support added.
 * 1.20b 01/11/85  Time compare added.
 * 1.20b 01/07/85  Set getl to ignore linefeeds...
 * 1.20b 01/05/85  Fix type to strip bit 8 (for WS files), getchar also strips.
 * 1.20b 01/05/84  New clock routines added.. CCS and QX10.
 * 1.20a 11/04/84  Counters routines made less dependant upon right info.
 * 1.10e 11/02/84  Added to pcounters routine, now wil write to specified file
 *		  if arg!=0.  Put writestat routine here, for easy access.
 * 1.10e 10/30/84  Parsing routine fixed to zap trailing blanks in ask func.
 *		  Future note: CAN'T change in getline!!!!!!!!
 *
 * 1.10c 10/0x/84  Hayes clock date order changed to reasonable mm/dd/yy form.
 *
 * 1.10b <none>
 * 1.10a  8/31/84  Overlay stuff started.
 *
 * 1.01a  6/27/84  Multi user stuff inserted.
 * 1.01a  6/10/84  Setup for Aztec C 1.06.  CCS clock stuff added.
 *
 * 1.0c   5/17/84 Added Hayes clock support.
 *
 * 1.0b   4/20/84 (continued) Added usindex() (index ignoring case), distext()
 * 1.0b   4/14/84 (continued) Findbye routine setup..
 * 1.0b	  4/13/84  Added Upper/lower case routines.  Added Novice user help.
 *		Putchar returns char typed at [More] prompt for checking.
 *		Removed several MENTER only functions (putcaller, writestat..)
 *		External height variable used for screen height now.
 *
 * 1.0a	  1/25/84  Added terminal height code.  Now pauses with [more] prompt
 *
 * 1.0	  1/17/84  Version 3.0a new format of files.
 *
 *****************************************************************************/

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"

static char line=1;	/* current line (relative to last input)	*/
static int col_pos=0;	/* position on line 				*/

/********************************
 * Return index into type table *
 ********************************/

get_type(t_char)
 char t_char;
{
register int i;

for (i=0; O.user_type[i].type!='\0'; i++) 
	if (O.user_type[i].type==t_char) break;

if (O.user_type[i].type=='\0') --i;	/* return last real type */
return i;
}


/********************************
 * type a file, stop on a break *
 ********************************/

type(filename)
 char *filename;
{
FILE *fil;
register int cfast;
int tc;

if ((fil=open(filename,F_RD | F_UNLOCK))==NULL) return ERROR;  /* open text file for read */

novhelp();	/* help novice if he is one */

read(fil,1);	/* getc doesn't do this initially, sigh */
while ( (cfast=getc(fil))!=ERROR && cfast!=EOF )
		{
		cfast&=0x7f;	/* strip high bit so doc mode ws files work */
		if (cfast!='\r')
		   if ( bcputchar(cfast)==ERROR || (globalchar&0x1f)==0x0f)
			{
			globalchar='\0';
			break;
			}
		}

close(fil);

return NULL;
}


/*******************************************************
 * display text from pointer to array of char pointers *
 *   (eg   static char *it_hlp[] = { "1","2","3",0 }; )*
 *******************************************************/

dis_text(sp)
 register char **sp;
{
while (*sp && (send(*sp++)!=ERROR));
}


/* A one liner to help novices out on the system */

novhelp()
{
if (user.parm.expert==POFF)
	send("\n   *** Control-K to abort, Control-S to pause. ***\n");
}


/* Regular old putchar, but checks for break (^K, etc..) chars. 
   Returns ERROR if one hit, else it returns the char		*/

bcputchar(ch)
 int ch;
{
register int a;

if (!breakkey())
	{
	if ( ( (a=toupper(putchar(ch))) & 0x1f)==0xb ) a=ERROR;
	}
  else a=ERROR;

return a;
}


send(s)		/* send string while checking for break */
register char *s;
{
while (*s) if (bcputchar(*s++)==ERROR) return ERROR;;
return 0;	/* else ok */
}

/****************************************
 * Print string to printer (LST:)	*
 ****************************************/

print(str)
 register char *str;
{
while (*str) bdos(5,*str++);
}


/********************************
 * check for ^k ^x, ^s, etc..	*
 ********************************/

breakkey()		/* check for break */
{
register int key;

if (key=bdos(6,0xff))
	{
	int tc;
	tc=key&0x1f;
	if ( tc==0x0b || tc==0x18)
		{
		putchar('\n');
		return ERROR;
		}
	if (tc==0x13)	/* pause if ^S */
		getd();
	globalchar=key;		/* save the char for later reference */
	}
return 0;	/* none pressed */
}


/******************************************************************************
 * ask: get string after prompting user.
 *
 *	question= prompt string (will NOT be printed if ';' used
 *		to get mult. commands/options..
 *	str	= place to put string
 *	maxchars= max # of chars to be accepted from terminal
 *	options	= following BITs that may be combined:
 *		UPLOW	: accept upper/lower case input
 *		UP	: upper case conversion is made
 *		NOECHO	: turn off display of chars as they are entered
 *		NUMBER	: a 'position' number is output instead of chars typed
 *		MSGLINE	: ONLY FOR getl(*).. for it to accept MAXMSGLINE chars
 *
 *****************************************************************************/

ask(question,str,maxchars,options)
 char *question,*str;
 int maxchars;
 register char options;
{
static char sepchars[3]={ ';', '\0', '\0' };	/* string of seperator chars */
       char *cp;
       char *sepcp=0;

sepchars[1]=sepstr;	/* make string of 1 or 2 seperator chars */

if ((strloc==0) || (glbstr[strloc]=='\0'))
	{
	send(question);				/* ask the question */
	getl(glbstr,options);			/* get the line */
	strloc=0;				/* make sure of this */
	}

/* see if seperator in string */

for (cp=&glbstr[strloc]; *cp && !(sepcp=index(sepchars,*cp)); cp++);

if (sepcp)
	{	/* change sepcp into ptr to actual text line */
	sepcp=index(&glbstr[strloc],*sepcp);
	*sepcp='\0';	/* terminate at seperator character */
	}

if (strlen(&glbstr[strloc])>=maxchars)
	glbstr[strloc+maxchars]='\0';

if (options & UP) upcase(&glbstr[strloc]);	/* all upper case if spec'd */

strcpy(str,&glbstr[strloc]);		/* copy it to where it's wanted */

if (sepcp) strloc=(sepcp-glbstr)+1;	/* updates strloc if ';' */
	else strloc=0;			/* else start over */

}	/* ask */


/* read a line of input from console */

getl(s,options)
 char *s,options;
{
register int c;
register int llen;
char *temp;
register int count;

if (!echo_flag) options|=NOECHO;	/* force no echo if this set */

if (options&MSGLINE) llen=O.MAXMSGLINE;
	else llen=MAXLINE;
temp=s; count=0;

if ((user.parm.bell)==PON) putchar(7);	/* ring bell */
while ((c=getd()) != '\r' )
	{
	if (c=='\n') c=' ';	/* convert a linefeed to a space.. */
	if (c=='\b' || c==0x7f)
		{		/* backspace or DEL */
		if (!count) continue;
		--count;
		--s;
		if (!(options & NOECHO) || (options & NUMBER)) send("\b \b");
		continue;
		}
	if (c>31)		/* tab goes in directly */
		{
		if (count<llen)
			{
			*s++=c;
			++count;
			}
			else c=0;	/* don't echo */
		if (count>=llen-8 && (count&1))	/* bell every other char */
			putchar(7);
		}
	if (c==9)
		{
		if (count+16<llen)
			{
			if ( !(col_pos % 8) ) c=8;
			  else c=(8-col_pos)&7;
			while (c--) { ++count; *s++=' '; }   /* fill spaces */
			c=9;
			}
		  else c=' ';
		}
	if ((c==24) || (c==21))
		{		/* ^X or ^U cancels line */
		send("#\n");
		count=0; s=temp;	/* clear buffer (effectively) */
		}
	else if (!(options & NOECHO))
		{
		if (c==9 || c>=' ') putchar(c);
		}
	     else if ((options & NUMBER) != 0) putchar('*'); /* (count % 10)+'0'); */

	} /* while */
*s='\0';	/* end of string */
putchar('\n');
return temp;
}


/**************
 * New putchar that counts columns
 *************/

putchar(ch)
 register int ch;
{
register int i,c;

c=NULL;	/* returned character for MORE prompt */

if (ch < ' ')
	{
	switch (ch) {
	   case	'\t':
		     for (i = 0;  i <= (col_pos+8)-((col_pos+8) & 0xf8);  i++)
		     putchar(' ');
		     return c;		/* quicky return */
	   case	'\n':
		     col_pos=0;
		     line++;
		     outc('\r');
		     break;
	   case	'\r':
		     col_pos=0;
		     break;
	   case	'\b':
		     --col_pos;
		     break;
		}  /* switch */
	}  /* control char check */
  else col_pos++;

  outc(ch);	/* output character.. */

if (line>=height && height!=0)
	{
	new_page();	/* MUST BE HERE OR RECURSIVE PUTCHAR WILL CROKE */
	if (user.parm.expert==POFF)
		{
		printf("[Press RETURN to continue]");
		c=getd();		/* get char which clears lines */
	/*	putchar('\n');	*/
		printf("\r                          \n");
		}
	  else	{
		printf("[more]");
		c=getd();
	/*	putchar('\r');	*/
		printf("\r      \n");
		}
	}

return c;
} /* new putchar */


outc(ch)
 register int ch;
{
bdos(6,ch);
if (print_flag==ON) bdos(5,ch);		/* if printer flag on, write to it */
}


/* new getchar to clear line variable, etc..	*/

getchar()
{
register int cfast;

cfast=getd();
if (echo_flag) putchar(cfast);

return cfast;
}

getd()
{
register int cfast;
new_page();		/* reset line counter */
cfast=c_wait();

if (user.status==SYSOP)
    if (cfast==0x10)	/* ^P */
	{
	if (print_flag) print_flag=OFF;
		else print_flag=ON;
	return c_wait();
	}

if (cfast==5)		/* ^E */
	{
	if (echo_flag) echo_flag=OFF;
		else echo_flag=ON;
	return c_wait();
	}
return cfast;
}

c_wait()
{
register int cfast;
while(!(cfast = (bdos(6,0xff) & 0x7f) ) );
return cfast;
}


new_page()
{
line=1;
}


/* New readclock routine... */

/* this one requires the config program to select a clock routine
   out of several supplied files..  the user may create their own
   clock code, etc..							*/

readclock()
{
int (*clock_fn)()=0x0212;	/* location of actual routine */
usr **u_p=0x0207;		/* pointer to pointer of user structure */
char *rtcbuf=0x0209;		/* buffer returning hr,mi,se,yr1,yr2,mo,da */

*u_p=&user;			/* pass pointer to user variable */
if (*(rtcbuf-5)) (*clock_fn)();	/* call it if installed */
 else O.RTC=NOCLOCK;		/* otherwise set this for later */

/* convert from bcd to ascii */
sprintf(time,"%02x:%02x:%02x",(int)rtcbuf[0],(int)rtcbuf[1],(int)rtcbuf[2]);
sprintf(date,"%02x/%02x/%02x",(int)rtcbuf[5],(int)rtcbuf[6],(int)rtcbuf[4]);

}


getdate()
{
if (O.RTC!=NOCLOCK) readclock();
return date;
}


/******************************************************************
 * compare times, return minutes difference.  Works for 47:59 hours.
 * passed: current time, compare time, current date, compare date
 ******************************************************************/

timecomp(t1,t2,d1,d2)
 char *t1,*t2,*d1,*d2;
{
register int mins1,mins2,mins;

mins1=atoi(t1+3); mins1+=(atoi(t1)*60);
mins2=atoi(t2+3); mins2+=(atoi(t2)*60);
if (strcmp(d1,d2)) mins1+=1440;	/* dates have changed. Add a day */

return mins1-mins2;
}	


/*************************************
 * output string to port specified.
 *   expected is:  1) status port
 *   2) data out mask  3) data port
 *   4) the string to be sent
 * note: nulls may not be sent via
 * this routine!!  \0 terminates string
 *************************************/

outpstr(stat,stmask,data,string)
 register unsigned stat,data;
 char stmask,*string;
{
while (*string) {
	while (!( in((char)stat) & stmask));
	out((char)data,*string++);
	}
}


/************************************************************************
 * String functions...							*/


/* convert string to all upper case */

upcase(str)
register char *str;
{
for (;*str; str++) *str=toupper(*str);
}


/* check for a space or control char in a string
   returns TRUE if space or control, else returns FALSE */

isspc(str)
register char *str;
{
while(*str) if (*str++<=' ') return TRUE; /* return TRUE if space/cntrl */
return FALSE;	/* else FALSE returned */
}


/* capitalize a string (all words in the string */

capstr(str)
 char *str;
{
register char *tp;

*str=toupper(*str);	/* first char is easy */

for ( tp=str; tp<str+strlen(str); ++tp )
	{
	if (*tp==' ') if (*(tp+1)!='\0') *(tp+1)=toupper(*(tp+1));
			else break;
	}
}


/* case independent string compare function */

ustrcmp(s1,s2)
 register char *s1,*s2;
{
for ( ; toupper(*s1)==toupper(*s2); s1++, s2++)
	if (*s1=='\0') return (toupper(*s1)-toupper(*s2));
			/* if at end of first string, test for=length/return */

return (toupper(*s1)-toupper(*s2));
}

/* case independent string compare function */

ustrncmp(s1,s2,n)
 register char *s1,*s2;
 register int n;
{
for ( ; (toupper(*s1)==toupper(*s2)) && (n>0); s1++, s2++, n--)
	if (*s1=='\0') return (toupper(*s1)-toupper(*s2));
			/* if at end of first string, test for=length/return */

return (n ? (toupper(*s1)-toupper(*s2)) : 0);
}


/*****************************
 * Same as index(s,c), but with two strings
 *****************************/

sindex(s1,s2)
 register char *s1,*s2;
{
 register char *sp;

for (sp=s2; strlen(s1)<=strlen(sp); sp++)
	if (!strncmp(s1,sp,strlen(s1))) return sp;

return 0;	/* no match */
}


/*****************************
 * Same as sindex(s1,s2), but IGNORE CASE in comparison
 *****************************/

usindex(s1,s2)
 char *s1,*s2;
{
 register char *sp;

for (sp=s2; strlen(s1)<=strlen(sp); sp++)
	if (!ustrncmp(s1,sp,strlen(s1))) return sp;

return 0;	/* no match */
}


/* get the counters from counters file */

gcntrs(f)
char *f;
{
char tdate[DATELEN+1];

#ifndef MULTI_USER
int id_num;		/* make dummy local copy if single user */
#endif

/* in case of failure.... */

callnum=id_num=0;	/* for defaults in case nothing found */

if ((counters=open(f ? f : COUNTERS,F_RD | F_LOCK))!=0)
	{
	read(counters,0);
	sscanf(bufloc(counters),"%d %d %d %s %d %d",&msgcount,
		&callnum,&nextmsg,(O.RTC ? tdate : date),&id_num,&privmsgs);

#ifdef TURBODOS

	if (strncmp(in_loc,ID_STR,3))
		{
		sprintf(bufloc(counters),"%d %u %u %s %d %d",msgcount,callnum,
			nextmsg,date,++id_num,privmsgs);
		write(counters,0);
		strcpy(id_loc,ID_STR);
		*(id_loc+3)=(char)id_num;
		}

#endif	/* TurboDos */

	close(counters);
	}
}


/* put the counters file on disk */

pcounters(f)
 char *f;
{
#ifndef MULTI_USER
int id_num=0;
#endif

counters=open(f ? f : COUNTERS,F_RW | F_LOCK);
 sprintf(bufloc(counters),"%d %u %u %s %d %d",msgcount,callnum,
	nextmsg,date,id_num,privmsgs);
 write(counters,0);
close(counters);
}


/* output string to the 25th status line.. */

writestat(str)
 register char *str;
{
if (O.STATUSLINE)		/* 25th line status display on???? */
   {
   if (O.OSMASK)
	{
	outpstr(O.OSTAT,O.OSMASK,O.ODATA,O.TO25);  /* get to 25th line	*/
	outpstr(O.OSTAT,O.OSMASK,O.ODATA,str);	   /* output string	*/
	outpstr(O.OSTAT,O.OSMASK,O.ODATA,O.FROM25);  /* get back	*/
	}
   else	{	/* otherwise O.ODATA is address of output routine BIOS DEP! */
	outsbios(O.TO25);
	outsbios(str);
	outsbios(O.FROM25);
	}
   }
}

outsbios(s)
 register char *s;
{
while (*s) outcbios(*s++);
}

char glob_ch;	/* so I can find the char easily */
char *glob_ad;

outcbios(c)
 register char c;
{
glob_ch=c;
glob_ad=O.ODATA;

#asm
	lda	glob_ch_
	mov	c,a
sillyk:	lxi	d,sillyk+8	; terrible kluge, do not change following
	push	d		; instructions without changing this too!!!
	lhld	glob_ad_
	pchl
	nop

#endasm

}


go_os(i)
int i;	/* if 0, no cpminfo shown, else shown for novice users */
{
  if (i && user.parm.expert!=PON) type(CPMINFO);
  *tout=O.user_types[user.type].timeout;
  *maxuser=O.user_types[user.type].maxuser;
  *maxdrive=O.user_types[user.type].maxdrive+1;
  if (O.ZCPR) if (O.user_types[user.type].zcprflag)
		{
		if (O.ZCPR!=3) *O.SECURELOC=255;
		 else *(z3env->wheel)=255;
		}

#ifndef MULTI_USER
  *(char *)0=0xc3;	/* avoids caller logout for BYE */
#endif

  sprintf(buffer,"\nYou have access thru user %d.\n\n",(int)O.user_types[user.type].maxuser);
  send(buffer);
  if (strcmp(OS,OSCOM)) link_prog(OS);
  exit(0);
}


/* Hangup the phone (exit system..) if value passed!=0 print signoff msg */

hangup(flag)
 int flag;
{
char *zero=0;

if (flag)
     printf("\n%s (TM)\nCopyright (c) 1984,1985 Tim Gary\
\nAll rights reserved.\
\nPortions (c) FOG, 1985\n\n",O.BBSNAME);

if (strcmp(BYE,BYECOM)) link_prog(BYE);		/* run prog if name changed */

if (bye!=nothing) *zero=0xcd;
exit(0);

}


/*  link_prog...   This routine loads and runs a com file..
 */

link_prog(name)
char *name;
{
setmem(0x5c,0x24,0);
setusr(fcbinit(name,0x5c));

#asm
;
;	This is taken from mentr.asm routine..
;
; The routine moves itself into the buffer at 80h, and procedes to load the
; program that is called for...	Kludgey, but effective..
;
	ext	ostack		; place where old stack is kept
;
	lxi	h,ostack
	sphl
	pop	h
	lxi	h,0
	push	h		; make sure top of stack is zero

	mvi	c,0fh		; open code..
	lxi	d,005ch		; fcb
	call	0005		; bdos
	cpi	0ffh		; error?
	jz	0		; yes boot...
;
	lxi	d,loader
	lxi	h,0080h		; dma..
	mvi	c,07fh
movloop:
	ldax	d
	mov	m,a
	inx	d
	inx	h
	dcr	c
	jnz	movloop
	jmp	080h		; jump to loader...
;
loader:
	lxi	d,100h		; tpa
load1:
	push	d
	mvi	c,1ah		; set dma..
	call	0005		; bdos
	lxi	d,005ch		; fcb
	mvi	c,14h		; read seq.
	call	0005		; bdos
	pop	d
	ora	a		; error?
	jnz	80h+(done-loader)	; if read error, finish up..
; bump the dma counts by 80h
	lxi	h,0080h
	dad	d
;	
	shld	0a000h		; for testing..
;
	xchg
	jmp	80h+(load1-loader)	; jr loader
;
; the file has presumably been read.. so run it..
;
done:	mvi	c,1ah		; set dma
	lxi	d,0080h		; reset default dma address..
	call	0005		; bdos
;
	mvi	c,10h		; close
	lxi	d,05ch
	call	0005
;
	jmp	100h		; tpa.. (program just loaded)
;
lend:	db	0
;
#endasm

}


/******************************************************************
 * initialize the bye variable to point to location if BYE active */

findbye()
{
register char *p;

bye=(*(char *)2)*256+*(char *)1-2;
bye=(*(char *)(bye+1))*256+*(char *)bye+6;

/* bye keeps mucking everyone up by changing the locations of strings */
for (p=bye; p<=bye+35; p++)
	if (!ustrncmp("bye",p,3)) break;

if (p>=bye+25) bye=nothing;

/* now for the values that we use the bye variable for.. */
maxuser=bye;
maxdrive=bye+1;
tout=bye+2;
nulls=bye+3;
}


/* EOF melib.c */


