/******************************************************************************
 *
 *	Enter program for METAL/Z-MSG System
 *
 *	FILE: MENTER.C
 *
 *		     Copyright (c) 1984, 1985 Tim Gary
 *			    All Rights reserved.
 *
 *
 *	This file gets the users' name/password/etc..
 *
 ******************************************************************************
 *
 * 1.31a  10/13/85 Release version.  Changes:
 *		   z3_init()/custom init support added.  Help changed..
 * 1.31xx 8/06/85  Start on TurnKey bbs version..
 * 1.30xx 6/23/85  wustat routine moved here..
 * 1.30xx 6/19/85  Askdate routine moved here.. g_restore stuff done in main.
 * 1.30xx 6/19/85  Putuser routine not used anymore..  user saved directly..
 * 1.30xx 6/12/85  <BBSNAME> + <password> can be typed on one OS command line
 *		  for a quicker sysop toggle..
 * 1.30xx 6/09/85  New bye save stuff deleted, change for new save stuff.. 
 * 1.30xx 6/01/85  rsvstk reserves more space.... 512 more..
 * 1.30xx 5/30/85  rsvstk called to make sure 'msg' array don't get clobbered.
 * 1.30xx 5/25/85  msg pointer gets setup here for Z3..  (top of memory)
 * 1.30xx 5/19/85  Read clock before getting user stuff if RTC != NOCLOCK.
 * 1.30xx 5/12/85  Things should be working better..
 * 1.30xx 5/11/85  Uh..  hopefully works with bye..
 * 1.30xx 5/09/85  Protect mode works fine!!!
 * 1.30xx 5/08/85  Fix bug in saving cmdline..
 * 1.30xx 5/05/85  Path stuff changed, protection stuff added.
 * 1.30xx 5/03/85  Path stuff added for aliases.
 * 1.30xx 5/02/85  Z3BUG turned off, Z3MSG_OFFSET added, last_date/time
 *		  put in g_save..
 * 1.30xx 5/01/85  Message buffer pointers fixed/Saved buffers locs corrected.
 * 1.30xx 4/28/85  Debug (Z3) stuff added..
 * 1.30xx 4/26/85  Restoration of command buffer added for Z3.
 * 1.30xx 3/13/85  Return from OS bug fixed..
 * 1.30xx 3/07/85  BYE link stuff added, and also BBSNAME define.
 * 1.30xx 2/21/85  Start Z3 additions.
 * 1.20b 01/18/85  Last time called bug fixed..
 * 1.20b 01/11/85  User.time/date saved in different order.
 * 1.20b 01/05/85  Fast status change if 'METAL +' issued..  Password length
 *		  bug fixed.  Log twit calls IF default user type is TWIT.
 * 1.20a 11/11/84  Release version.
 * 1.20a 11/07/84  Lastmsg fixes.
 * 1.20a 11/04/84  Wrapping up changes from past few weeks, added new info
 *		  to lastcalr file.
 * 1.10e 11/03/84  Fixed for new pcounters/gcntrs.  Moved writestat to hmlib.
 * 1.10e 10/30/84  Version # changed.
 * 1.10d 10/21/84  First time setup bug created in 1.10a/b (in meinfreq) fixed.
 * 1.10c 10/17/84  Status line support for non i/o mapped terminals.
 * 1.10b 10/01/84  Version change needed to keep track.  Spelling error
 *		  corrected.
 * 1.10a  9/27/84  User # and ID info displayed, help added at name prompt.
 * 1.10a  9/09/84  Fixed last message read bug (for overlays).
 * 1.10a  8/31/84  Overlay version started, this WHOLE file is now and overlay.
 *
 * 1.01a  7/02/84  Multiuser lastcalr file items installed (whew).
 * 1.01a  6/10/84  Fixed for Aztec C 1.06.  Will not function under earlier
 *		  versions of the compiler due to new/changed functions.
 *
 * 1.0b   4/13/84  Modified to allow Upper and Lower case names.
 *
 * 1.0a	  3/16/84  First release version.. fixed jump to cpm bug.
 *
 * 1.0	  2/08/84  Random seek to user # (if entered) implemented.
 * 		  Format for users/messages/summary changed.
 *
 *	 12/13/83  Pre-release Version 3.0 Mconfig operation mods.
 *
 *****************************************************************************/

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"


static int dead_rec_no=0;	/* for new user, write over old '0' user */
static int dead_user_no=0;	/* dead user #, above is record in file */

static char tpass[PASSLEN+1];

/****************
 * Main routine *
 ****************/

ovmain(argc, argv)
 register int argc;
 register char *argv[];
{
unsigned tlastread;
char **m_buff;

if (argc>=2 && (!strcmp(argv[1],"+") || !strcmp(argv[1],"!")) )
	/* check for quick sysop status */
	{
	if (argc==3) strcpy(buffer,argv[2]);
	  else ask("Prove it!",buffer,PASSLEN+1,UP+NOECHO);
	if (!strcmp(buffer,O.SOPASS))
		{
		user.status=SYSOP;
		user.type=get_type(SYSOP);
		send("[Sysop Toggle ON]\n");
#ifdef Z3
		if (O.ZCPR==3) z3_init();	/* load sys segs, etc.. */
#endif
		findbye();
		go_os(NO);
		}
	  else {
		send("[Sorry...]");
		exit(0);		/* (any os) don't change a thing */
		}
	}

  argc=1;		/* so that MEINFREQ is used to read scan messages.. */

  init();
  gcntrs(0);		/* get counters */

  if (O.RTC!=NOCLOCK) readclock();	/* get time here if RTC being used */

  getuser();		/* gets user name and other vital info */

  /* NOTE::: The users file has been opened in getuser, and all we do now
   * is get the time/date, and write the users info into the files..
   *  remember, they are already open and putuser() closes them..	*/
  putchar('\n');

  if (O.RTC==NOCLOCK) askdate();	/* get date now if no clock */

  send("\n[Updating logs]\n");

  if (O.ASKNULLS) user.parm.nulls=*nulls+'0';  /* setup user nulls */

  if (!user.parm.calls)
	{
	strcpy(user.date,date);
	strcpy(user.time,time);
	}

  strcpy(last_date,user.date);
  strcpy(last_time,user.time);	/* putlastcaller writes these */

  strcpy(user.date,date);		/* setup current login date/time */
  strcpy(user.time,time);

  putlastcaller();

  tlastread=user.lastread;		/* save real current lastmsg count */
  user.lastread=(nextmsg ? nextmsg-1 : 0);	/* new user.lastread msg */
  user.parm.calls++;
  if (user.parm.width<20 || user.parm.width>132) user.parm.width=O.INITLENGTH;
  movmem(&user,bufloc(users),128);   /* write to open users file, and close */
  write(users,0);
  close(users);
  user.lastread=tlastread;	/* restore real lastread msg (overlay req.) */

  ++callnum;		/* add to # of callers variable */

  putcaller();		/* write caller to callers file or printer (PRTLOG?) */
  pcounters(0);		/* write counter info	*/

  /* logoff a TWIT now (timeout=0, then can't get on the system */

#ifndef MULTI_USER
  if (O.user_types[user.type].timeout==0)
	hangup(NO);
#endif

#ifdef Z3
  if (O.ZCPR==3) z3_init();
#endif

  cust_init();		/* this currently in main..  calls user init stuff */

  type(BULLETIN);

  if (user.parm.jmpcpm==PON)
	go_os(YES);	/* setup parms and goto Op Sys */

/* NOTE: with overlays, all we do is return, and that'll put us back main */
return argc;	/* tells whether or not to be quiet or not */

}	/* main */


/* get date from keyboard (for those without a clock) */

askdate()
{
int temp;

strcpy(time,"00:00:00");

if (!strloc || tolower(glbstr[strloc])!='y')
   {
   printf("\nIs %s today's date [y/n]? ",*date=='\0' ? "00/00/00" : date);

   do temp=tolower(getd());
	while (temp!='y' && temp!='n');

   if (temp=='y') 
	send("[yes]\n");
     else {	/* no need for this really */
	send("[no]\n");
	do  ask("What's todays date (mm/dd/yy)? ",date,DATELEN,UP);
	  while (strlen(date)!=DATELEN-1);
	}
   }
   else if (strloc) ask("",buffer,1,UPLOW);	/* kill 'y' */

return date;

} /* askdate */


/******************************
 * Initialize the whole works *
 ******************************/

init()
{
#ifndef MULTI_USER
*(char *)0=0xcd;	/* disable ^C for warm boot, uses BYE program method */

#endif

findbye();	/* setup bye, and related, variables */
*maxuser=1;	/* setup maxuser */
*tout=3;	/* setup 3 minute timeout */
if (!O.ASKNULLS)	/* if bye asked for nulls, don't reset... */
  *nulls=0;		/* no nulls */

/* printf("\n\nEnter %s\n%s\n",O.VERSION,O.WHERE); */

printf("\n%s\n",O.WHERE);

if (msg==0)	/* message allocated by settop in main */
	{
	send("\nAllocation ERROR: Memory full.\n");
	if (user.status==SYSOP)
		{
		send("\n** Use the Configuration program \
\nand decrease total # of msgs **\n");
		go_os(NO);
		}
  	else send("\n** Sorry, but the BBS is in need of repair. **\
\n ** Please try it later! **");
	hangup(YES);	
	}

type(WELCOME);
/* type(BULLETIN); */		/* display any recent changes, BULLETIN is a file */

if (O.ZCPR)
 if (O.ZCPR!=3) *O.SECURELOC=0;	/* if using ZCPR in secure mode, then make */
  else *(z3env->wheel)=0;

} /* init */


/* This is shown should the person type in a name  of one char (like '?') */
/* when prompted for their name or Metal Id. */

login_help()
{
static char *lo_help[] = {
	"\nIf this is your first time on this system,\n",
	"please enter your full name.\n",
	"\nIf you have called this system before, either\n",
	"enter your full name, or your system access\n",
	"code (SYSTEM ID code).  The access code should\n",
	"have been given to you when you first registered\n",
	"to use the system.  The format of a SYSTEM ID is:\n",
	"   <user#><password>\n",
	"So, if you are user # 453, and password is PURPLE\n",
	"you could enter  453PURPLE  in place of your name\n",
	"to speed up the login process.\n\n",

/*	"\nUse the '#' command on the BBS to find out what your\n",
	"user # is if you've forgotten it.\n\n",	*/
	0
	};
dis_text(lo_help);
}


/* Getuser gets the users name, and password, or if new user gets info
 * 	to be used in later logons.  A check is made for sysop, and special
 *	parameters are then set-up.
 */

char temp1[64];

getuser()
{
register int cfast;		/* fast c variable	*/
register int tries,usernum;
int dir;		/* search direction */
char first[FNAMELEN+1],last[LNAMELEN+1];	/* temp name	*/
char temp[MAXLINE+1];


tries=0;	/* number of unsuccessful tries (wrong password tries) */

do {		/* main input name/etc loop */

usernum=-1;	/* no user number yet, if ever */
*tpass='\0';	/* no temp password yet */


/* PRIVATE SYSTEM ONLY STUFF */

if (O.PRIVATE)
 {
do {
   ask("SYSTEM ID CODE (not personal ID): ",temp,PASSLEN,UP);
   if (!strcmp(O.PRIVPASS,temp)) break;
   } while (++tries<O.MAXTRIES);

   if (tries>=O.MAXTRIES)
	{
	type(SYSINFO);	/* info about this private system before quiting */
	exit();
	}
   else tries=0;	/* reset to 0 for name test */
 } /* private */


/* Here we actually get the name of the person.. can give both first and
   last names on a line, or seperately, or a user id..	*/

getfirst:
    do {
	*last='\0';	/* terminate last name initially */
	/* get first name or user # and password, TRUE says convert to upper */
	sepstr=' ';	/* seperator char is space for first/last name sep */
	ask("\nWhat's your first name (or SYSTEM ID)?\n--> ",first,FNAMELEN,UPLOW);
	sepstr='\0';
	capstr(first);	/* capitalize first name */
	if (!isdigit(*first) && strlen(first)<2)
		login_help();	/* print login help msg */
 	} while(!isdigit(*first) && strlen(first)<2);

   if (ustrcmp(first,"SYSOP")==0) *last='\0';
	else if ( ( !isdigit(*first)) && (*last=='\0') )
		{
		ask("\nWhat's your LAST name? --> ",last,LNAMELEN,UPLOW);
		if (*last=='\0') goto getfirst;
			/* if return pressed, start over */
		}
    capstr(last);

/* check for sysop */

   if ( ((ustrcmp(first,"SYSOP")==0) && (*last=='\0')) ||
	 ( (ustrcmp(first,O.SOFIRST)==0) && (ustrcmp(last,O.SOLAST)==0) )
	  || (atoi(first)==1) )
	{
	ask("\nSysop Pass: ",tpass,PASSLEN,UP+NOECHO);	/* get sysop pass */
	if (strcmp(tpass,O.SOPASS)!=0)	/* not sysop? */
		{
		tries+=2;	/* double penalty for false sysop try */
		continue;	/* bad practice I think */
		}
	send("\n[Ok]");		/* say your ok so far */
	*tpass='\0';		/* user num, not entered */
	strcpy(first,O.SOFIRST); strcpy(last,O.SOLAST);	/* for sysop response */
	}

/* if user # was entered, get password if any, or pass through */

  if (isdigit(*first))
	{
	usernum=atoi(first);	/* if #, then get it all */
	for (cfast=0; isdigit(first[cfast]); ++cfast);
	if (first[cfast]!='\0')
	  	strcpy(tpass,&first[cfast]);	/* else get password */
	dir=1;	/* set flag for user number entered */
	} else dir=0;

  if ((users=open(USERFILE,1))!=NULL)
     {					/* open users file, and create it
	 				if it doesn't exist now */
	if (dir) setarec(users,usernum-1);	/* skip to a place */

if (O.PRIVATE) send("\n[Verifying ID]");
	else send("\n[Checking registered user files]\n[.");

/* NOTE: you can't successfully delete the sysop (first user actually)
  using the following method... */


dead_user_number=dead_rec_no=0;

cfast=read(users,0);	/* get first record */
if (cfast!=128) if (dir)
	{
	dir=-1;
	toeof(users);
	setrrec(users,-1);	/* backup one */
	cfast=read(users,0);	/* re-read */
	}

  do	{
	if (cfast!=128) break;		/* exit loop if eof */

	/* let user know things are still being looked into */
	if ((getrec(users)%25)==0) putchar('.');

	/* get desired info from users file... */

	if (dead_rec_no==0) dead_user_no=user.number;

	movmem(bufloc(users),&user,128);	/* get vars, now src,dest */

	if (user.number==0 && dead_rec_no==0)
		{
		dead_user_no++;		/* get user after last since this one
					  is 0 right now... */
		dead_rec_no=getrec(users);
		}

	/* see if past user number */

	if (dir && user.number)	/* if user number entered, and this ain't 0  */
		{		/* check for past user, and exit if so */
		if ( (dir==-1) && (usernum>user.number) ) break;
		  else if (usernum<user.number) break;
		}

	/* see if a match of either name or user number */

	if ((user.number) && ( (usernum==user.number) ||
		(!ustrcmp(first,user.first) && !ustrcmp(last,user.last)) ) )
		{
		putchar(']');		/* cosmetic */
		tpass[PASSLEN]='\0';	/* make sure it's terminated here */
		if (*tpass!='\0')
		    if (ustrcmp(tpass,user.pass)==0)
			goto itshim;   /* it's him! that's all getuser needs */

		/* didn't enter user number, so get password */

		if (*tpass=='\0')
			{
			ask("\nEnter password: ",tpass,PASSLEN,UP+NOECHO+NUMBER);
			if (strcmp(tpass,user.pass)==0)
				{
	itshim:			movmem(bufloc(users),&user,128);
				putchar('\n');
				return;
				}
			}
		send("\n[Wrong!]\n");
		break;		/* exit this loop and ask for name again */
		}
	setrrec(users,dir==-1 ? -1 : 1);	/* forward or backward */
	cfast=read(users,0);				/* and read record */

	} while (cfast==128);	/* read do loop ends */

	close(users);	/* close it... */
    }	/* good open loop */

	if (cfast!=128)
	   if (usernum==-1)		/* if entered name */
if (O.PRIVATE)
	break;	/* print system info, for address of where to get account */
  else
	if (newuser(first,last,user.number)!=ERROR)   /* newuser or bad name */
		return;		/* was new user, so return to main */

} while (++tries<O.MAXTRIES);	/* get name, etc.. for MAXTRIES */

type(SYSINFO);	/* EVERYONE gets file for more info */

/* if (O.PRIVATE) type(SYSINFO);
  else send("\n[* Access Denied *]"); */

hangup(NO);

}	/* getuser .... should never ever get here */


/**/
/* this routine checks if mistaken name, or gets new user's info	*/
/**/

newuser(first,last,un)
char *first,*last;
unsigned un;
{
register int cfast;
char temp[MAXLINE+1];

setmem(&user,128,0);
user.number=un;

  printf("]\n[%s %s is not a registered user.]", first, last);
  printf("\nDo you want this name registered on the system log?");
  ask("\n  (Enter NO to re-enter name or correct spelling)\n--> ",temp,1,UP);
/*  ask("] [no record]\nAre you new to this system? ",temp,1,UP);	/* mistake? */
  if (*temp!='Y') return ERROR;	/* not new user then return to getuser */

  ask("\nWhere are you calling from (city,state/prov)?\n--> ",user.city,CITYLEN,UPLOW);
  if (user.city[0]=='\0') return ERROR;	/* not entered, get name again */
  capstr(user.city);

  printf("\nYou are %s %s from %s", first,last,user.city);
  ask("\nIs that correct? ",temp,1,UP);
  if (*temp=='N') return ERROR;

  send("\nPlease enter a password of 8 characters or less.");
  send("\n(Don`t enter something obvious, such as your name.)");
  send("\nYou will need it EVERY time you login to this system!");
  send("\nSpaces and control characters are not allowed, and\
\nthe first character must not be numeric. ");
  do	{
 	ask("\nEnter password: ",temp,PASSLEN,UP+NOECHO+NUMBER);
	if (*temp=='\0') return ERROR;
	if (isspc(temp)) {
			 send("\nSpaces aren't allowed in passwords!!\n");
			 continue;	/* ask again... */
			 }
	if (isdigit(*temp))
			{
			send("\nThe first character must NOT be numeric!!\n");
			continue;
			}
	ask("\nNow re-enter it to make sure it's correct: ",&temp[PASSLEN+10],
		PASSLEN,UP+NOECHO+NUMBER);
	if (strcmp(temp,&temp[PASSLEN+10])==0) break;
	send("\n[* Incorrect *]");
	send("\n  Try again.");
	} while (1);

if (dead_rec_no!=0) user.number=dead_user_no;
  else user.number++;	/* either use previously deleted user, or next one */

  send("\nGreat!  Now just make sure that you remember it!\n\
        You won't be able to login later without it.\n");

  printf("\nYou are user #%u.",user.number);
  printf("\n\nYour SYSTEM ID is: %u%s",user.number,temp);

  send("\n\nEntering it instead of your name will\
\ntremendously speed up the login process,\
\nthough this is not required.");

  strcpy(user.first,first);
  strcpy(user.last,last);
  strcpy(user.pass,temp);
  strcpy(&user.parm.ulcase,"0000110");     /* initial user parms.. */
  user.lastread=user.parm.calls=0;
  user.status=O.DSTATUS;
  user.type=get_type(user.status);
  user.parm.height=24;
  user.parm.width=O.INITLENGTH;

  users=open(USERFILE,1);	/* open for r/w */

if (dead_rec_no!=0)
	setarec(users,dead_rec_no);
  else toeof(users);	/* set random record to eof for append */

 type(NEWUSER);
 return NULL;		/* got a new usr ok.. */

}	/* newuser */


putlastcaller()
{

#ifdef MULTI_USER
 register unsigned crec;
#endif

lastcalr=open(LASTCALR,1);

#ifdef MULTI_USER

#ifdef MPM
  crec=bdos(153,0);	/* get MP/M console # */
#else
  crec=*(id_loc+3);	/* Id number from counters file.. */
#endif   /* mp/m */

  toeof(lastcalr);	/* seek to end, and then write junk til positioned */
  while (getrec(lastcalr)<crec) write(lastcalr,1);
  setarec(lastcalr,crec);

#endif	 /* Multi_User */

sprintf(bufloc(lastcalr),"%s %s on %s%s%s\r\n\032%u %u %s %s",
	user.first,user.last,date,O.RTC!=NOCLOCK ? " at " : "",
	O.RTC!=NOCLOCK ? time : "",getrec(users),user.lastread,
	last_date,O.RTC==NOCLOCK ? "00:00:00" : last_time);
write(lastcalr,0);
close(lastcalr);
}


/* update callers log..  */

putcaller()
{
char tt[TIMELEN+1],td[DATELEN+1];

if (O.RTC!=NOCLOCK)
	{
	strcpy(tt,time);
	timefix(tt);
	}
   else	strcpy(tt,"");

strncpy(td,date,5);  td[5]='\0';

if (!O.PRTLOG)
	{
	callers=open(CALLERS,1);	/* output to file */
	toeof(callers);
	if (getrec(callers)!=0)
		{
		setrrec(callers,-1);	/* backup one */
		read(callers,0);
		while(gchar(callers)!=26);	/* test eof */
		setbuf(callers,getbuf(callers)-1);	/* backup a char */
		}
	}
	sprintf(buffer,"%s %s %s %s from %s\n\032",
			tt,td,user.first,
			user.last,user.city);
if (!O.PRTLOG)
	{
	fputs(buffer,callers);	/* write it out there.. */
	if (getbuf(callers)!=0) write(callers,0);
	close(callers);
	}
    else print(buffer);
  
wustat(0);	/* write user info, etc to status line */

}	/* pcaller */


/* Write user status line info (name, stat, time called, city).. */

wustat(s)
 char *s;
{
char buf[128];
sprintf(buf,"%8s -- %s %s - '%c' %s -- %s",s ? s : "",user.first,
	user.last,user.status,time,user.city);
writestat(buf);
}


/* EOF: menter.c */
