/**************************************************************************
 *
 *	Global variable definitions for Metal/Z-Msg Version 1.31xx
 *
 *
 *	FILE: MEGLOB.H
 *
 *		    Copyright (c) 1984,1985  Tim Gary
 *			    All rights reserved.
 *
 **************************************************************************
 *
 * 1.31a  10/13/85  Release version.
 * 1.31xx 08/16/85  This file created from parts of HMH.H
 *
 *************************************************************************/

/*************************************************************************
 * NOTE: If INITGLOB is set, then the variables will be defined as
 *	 non-externals, and will be initialized.
 *************************************************************************/


/* Global character array for various routines */

#ifdef INITGLOB
char buffer[257]="Metal Message System (TM) Copyright (c) 1984,1985 by Tim Gary  All rights reserved.\n";
#else
extern char buffer[257];
#endif	/* INITGLOB */

char glbstr[MAXLINE+2];	/* global string used with ask(), etc.. and ';' */
char last_time[TIMELEN],last_date[DATELEN];

#ifdef INITGLOB
char print_flag=OFF;	/* flag for print mode */
char echo_flag=ON;	/* flag for "half-dup" non echo.. */
int strloc=0;		/* current position into glbstr */
int globalch='\0';	/* global char */
char sepstr='\0';	/* if !=0 then this acts same as ';' */
#else
extern char print_flag;	/* flag for print mode */
extern char echo_flag;	/* flag for "half-dup" non echo.. */
extern int strloc,globalch;
extern char sepstr;
#endif /* INITGLOB */


/****************************************
 * message base variable definitions	*
 ****************************************/

struct	{
	unsigned number;	/* message number	*/
	unsigned seek;		/* seek pointer to message header */
	unsigned parent;	/* parent msg.. original msg in rep. series */
	unsigned reply;		/* next reply in list... 0 if at end of list */
	} *msg;	/* POINTER NOW */

unsigned fmsg,lmsg;	/* first/last active msg numbers	*/
int mindex;		/* index into above msg array		*/

/**********************************************************************
 * message structure definition, new format with unencoded #'s, etc.. *
 **********************************************************************/

#ifndef CONFIG
typedef struct	{
	unsigned number;		/* message # */
	unsigned seek;			/* cp/m record, seek loc of msg */
	unsigned parent;		/* parent message #, if any	*/
	unsigned reply;			/* reply message #, if any	*/
	char	receiver[FNAMELEN+LNAMELEN+2];	/* who's msg to?	*/
	char	fsend[FNAMELEN+1];	/* who's msg from (first name)	*/
	char	lsend[LNAMELEN+1];	/*  "     "    "  (last name)	*/
	char	status;			/* private/normal, etc.. */
	int	lines;			/* # of lines in message */
	char	date[DATELEN];		/* date message entered */
	char	time[TIMELEN];		/* time message entered */
	char	topic[TOPICLEN+1];	/* subject of message	*/
	} msg_record;	/* new type */

/**************************************************************************
 * and now, the external, globally known, and loved, one and only msg var *
 **************************************************************************/

msg_record message;	/* Message variable that can be, and is, read	*/
			/* directly from the message/summary file	*/

/* these next three are for the read messages overlay */
char prevsender[FNAMELEN+LNAMELEN+3];
unsigned prevmsg;		/* previous message #, for reply */
#ifdef INITGLOB
char status=DEADMSG;		/* current message status	 */
#else
char status;
#endif

int msgcount;		/* # of active messages		*/
int privmsgs;		/* # of private messages	*/
unsigned nextmsg;	/* next message number		*/
unsigned totalmsgs;	/* total active and killed msgs allowed	*/

unsigned callnum;	/* caller number NOW UNSIGNED!	*/
char date[DATELEN];	/* todays date			*/
char time[TIMELEN];	/* time string			*/

char nothing[6];	/* place to put BYE parms if inactive */

/***********************
 * global BYE pointers *
 ***********************/

char *bye,*maxuser,*maxdrive,*tout,*nulls;

#endif /* CONFIG */

/***********************************************************************
 * global height var, so routines aren't dependent on user.parm.height *
 ***********************************************************************/

#ifdef INITGLOB
char height=24;	/* terminal height for putchar.. assume 24 char screen */
#else
extern char height;
#endif

/****************
 * global files	*
 ****************/

FILE *users;		/* users file			*/
FILE *counters;		/* message counters file	*/
FILE *lastcalr;		/* last caller file		*/
FILE *summary;		/* summary file for messages	*/
FILE *messages;		/* message base file		*/
FILE *callers;		/* callers file			*/

/*********************************************************
 * Make this a type, so that it can be defined elsewhere *
 *********************************************************/

typedef struct	{
	int	number;
	char	first[FNAMELEN+1];
	char	last[LNAMELEN+1];
	char	pass[PASSLEN+1];
	char	date[DATELEN];
	char	time[TIMELEN];
	char	city[CITYLEN+1];
	unsigned lastread;
	char	status;
	char	type;
	struct	{
		char	ulcase;		/* upper or lower case 	*/
		char	jmpcpm;		/* jump to cpm/no bbs  	*/
		char	expert;		/* expert user? 	*/
		char	bell;		/* bell on or off 	*/
		char	rp;		/* 'RP' command at bbs  */
		char	video;		/* video mode ok?	*/
		char	nulls;		/* number of nulls	*/
		char	height;		/* height of terminal	*/
		char	width;		/* width of terminal	*/
		unsigned tcap;		/* tcap ptr (coming)	*/
		unsigned uploads;	/* upload count		*/
		unsigned downloads;	/* download count	*/
		unsigned minutes;	/* time on system today	*/
		unsigned inforec;	/* user info file rec	*/
		unsigned calls;		/* # of times called	*/
		char	reserved[5];	/* reserved for future	*/
		char	udef[4];	/* parms for users use	*/
		} parm;
	} usr;

usr user;	/* user variable */


#ifndef HMLIB
struct cmdtype {	/* command structure definition  */
	char	*abbr;		/* abbreviation 	 */
	char	*full;		/* the rest of the thing */
	int	(*func)();	/* pointer to function   */
	int	value;		/* call the routine with this value */
	int	ovname;		/* overlay name if used  */
	};
#endif


/**************************
 * user type parameters.. *
 **************************/

typedef	struct	{
	char type;	/* the character that gets this type 		*/
	char maxuser;	/* Max CP/M user number this guy gets, 0=nocpm	*/
	char maxdrive;	/* Max drive avail.. 				*/
	char timeout;	/* # of mins before no-typing timeout, 0=twit	*/
	char killflag;	/* Can he kill messages?			*/
	char zcprflag;	/* Does he get master CP/M privs? (with zcpr)	*/
	char readpriv;	/* Can he read private mail?			*/
	char postmsg;	/* can the guy post messages			*/
	char minutes;	/* minutes allowed on system (Metal/MBYE)	*/
	unsigned flags;	/* special flags for Z3 commands file		*/
	char sysseg[5][14];	/* 8 zcpr3 system segments to load	*/
	unsigned regs[10];	/* z3 reg settings.. (hi=if set, low=value) */
	char sysnum;	/* system file number to put lastcaller things in */
	char path[16];	/* DU form path... for z3			*/
	} u_types;


/****************************************************
 * All Options are contained in one large structure *
 ****************************************************/

struct options	{
	char	zippo[10];		/* mark start of options	*/
	char	cfg_vers[10];		/* config file format version	*/
	u_types	user_types[9];		/* User types table		*/
	char	DSTATUS;		/* default user status (login init) */
	char	PRIVATE;		/* private system flag		*/
	   char	PRIVPASS[PASSLEN+1];	/* private system password	*/
	char	files[24][18];		/* file names/locations		*/
	char	MAXTRIES;		/* Max # of logon attempts	*/
	int	MAXMSGS;		/* Max # of ACTIVE msgs allowed	*/
	char	MAXMSGLINE;		/* Max length of msg line	*/
	int	MLINES;			/* Max # of lines		*/
	int	MAXTOTMSGS;		/* Max total active + dead msgs */
	char	RTC;			/* using clock???		*/
	char	ASKNULLS;		/* if bye asks for nulls	*/
	char	ZCPR;			/* version of ZCPR if used	*/
	   char *SECURELOC;		/* location of zcpr wheel (1&2)	*/
	char	*id_loc;		/* console id # value pointer	*/
	char	INITLENGTH;		/* initial terminal length	*/
	char	WHERE[81];		/* location of site		*/
	char	PRTLOG;			/* if using printer for log	*/
	char	STATUSLINE;		/* you have status line???	*/
	   char	TO25[16];		/* up to 15 chars to get there	*/
	   char	FROM25[16];		/* to get back to last position	*/
	   unsigned OSTAT;		/* Terminal output stat port	*/
	   unsigned ODATA;		/* Terminal data port		*/
	   char	OSMASK;			/* output status mask		*/
	char	SOFIRST[FNAMELEN+1];	/* sysop's first name		*/
	char	SOLAST[LNAMELEN+1];	/* sysop's last name		*/
	char	SOPASS[PASSLEN+1];	/* sysop password		*/
	char	BBSNAME[50];		/* Make of bbs.. Metal or Z-Msg	*/
	char	VERSION[35];		/* "Version xx.xxxx"		*/
	char	ALIASRET[20];		/* Alias ret cmd line..		*/
	char	Z3MSG;			/* z3 msg area offset.. 0x48	*/
/* zappo to end this madness */
	char	zappo[10];		/* "KABOOM!!!"	EOO flag	*/
	};

#ifdef INITGLOB
#include "MEINITO.H"	/* options variable init */
#else
	struct options O;
#endif

/* global variables needing saving */

#ifndef HMLIB
#ifndef CONFIG
#ifdef Z3

/* Z3 command line buffer pointer below */

struct cmd_line {
	char *next_char;	/* Pointer to next char in buffer */
	char buf_size;		/* length of buffer (unused)	  */
	char char_cnt;		/* character count		  */
	char buffer[250];	/* buffer area..		  */
	} ;	/* command line pointer structure */

struct envptr {
	char	jmp[3];		/* skip over initial JMP instruction */
	char	id[5];		/* Id, usually Z3ENV		*/
	char	class;		/* 1=external, 2 internal	*/
	char	*expath;
	char	expaths;
	char	*rcp;
	char	rcps;
	char	*iop;
	char	iops;
	char	*fcp;
	char	fcps;
	char	*ndir;
	char	ndirs;
	struct cmd_line *cl;	/* command line pointer			*/
	char	cls;		/* # of bytes in cl			*/
	char	*env;		/* ptr to external environment desc.	*/
	char	envs;
/*	char	*shstk;	*/	/* shell stack				*/
/*	char	shstks;	*/	/* # of (shsize) stack entries		*/
/*	char	shsize;	*/	/* size of shell stack entry		*/
   char t1[4];
	char	*msg;		/* message buffer			*/
/*	char	*extfcb;
	char	*extstk;
 */
   char t2[4];
	char	quiet;
	char	*wheel;		/* secure mode wheel		*/
	char	speed;		/* speed in mhz			*/
	char	maxdisk;
	char	maxuser;

	} *z3env;

/* This header structure variable protects globals when doing an alias */

struct g_prot {
	char n0;		/* jmp */
	char *obdos;
	char msgsys[7];		/* "MSGSYS",0 */
	char *g_vars;		/* pointer to global variables */
	struct	{
		char jmp;
		char *addr;
		} bt[6];
	char swap;		/* push h */
	char n1;		/* lxi h  */
	char *prot_bdos;
	char n2;		/* shld 6 */
	char *n3;
	char n6;		/* pop h */
	char n7;		/* ret */
	struct	{
		char call;
		char *addr;
		char jmp;
		char *swapbdos;
		} abt[6];
	} g_h
#ifdef INITGLOB
	      = {
		0xc3,0000,"MSGSYS",0000,
			{ 0xc3,0000,
			  0xc3,0000,
			  0xc3,0000,
			  0xc3,0000,
			  0xc3,0000,
			  0xc3,0000 },
		0xe5,0x21,0000,0x22,0006,0xe1,0xc9,
			{ 0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000 }
		}
#endif	/* MAIN */
;

struct g_prot *z3_hp;	/* loc to put this at */

struct g_save {
	char	*msg;
	char	glbstr[MAXLINE+2];
	int	strloc;
	int	globalchar;
	char	print_flag;	/* flag for print mode */
	char	echo_flag;	/* flag for "half-dup" non echo.. */
	char	sepstr;
	unsigned fmsg,lmsg;
	int	mindex;
	int	msgcount;
	int	privmsgs;
	unsigned nextmsg,totalmsgs;
	unsigned callnum;
	char	date[DATELEN];
	char	time[TIMELEN];
	char	height;
	char	last_date[DATELEN];
	char	last_time[TIMELEN];
	struct	cmd_line cmdbuf;  /* place to save current z3 cmd buffer */
	char	sotries;
	char	path[24];	  /* allow for 12 path entries */
	};

#endif /* Z3 */
#endif /* NOT-CONFIG */
#endif /* HMLIB */

/* EOF (MEGLOB.H) */


