/********************************************************************
 * ZCPR3 routines for Metal/Z-MSG
 *
 * 	File: MEZ3.C
 *
 *	    Copyright (c) 1984,1985 Tim Gary
 *		   All Rights Reserved.
 *
 ********************************************************************
 *
 * 1.31a   10/13/85 Release version.
 * 1.30xx  7/01/85  Print/echo flags saved...
 * 1.30xx  6/09/85  New bye stuff deleted, new protect method done.
 * 1.30xx  5/26/85  Save bye stuff if bye is active.. (at new topmem loc)
 * 1.30xx  5/25/85  Msg pointer saved in gp area, see also meinfreq..
 * 1.30xx  5/12/85  Bug in calculations fixed.
 * 1.30xx  5/11/85  Protection code that should work with bye..
 * 1.30xx  5/09/85  Protect mode working...
 * 1.30xx  5/05/85  Modified Path stuff, fixed protection for globals.
 * 1.30xx  5/03/85  Z3 Path stuff saved, and used in alias command lines.
 * 1.30xx  5/02/85  Z3BUG turned off, Z3MSG_OFFSET added, glbstr buffer
 *		   save fixed..
 * 1.30xx  5/01/85  Error returned only if command not found, not if
 *		   can't access it.  ALIASRET define used.  If allocation
 *		   error, command line is restored.
 * 1.30xx  4/28/85  Z3BUG stuff added.
 * 1.30xx  4/26/85  Fix for saving command buffer before entering Z3
 * 1.30xx  4/04/85  Etc..
 * 1.30xx  3/03/85  Back to work.
 * 1.30xx  2/26/85  Command routine started.
 *
 ********************************************************************/

/* #define Z3BUG  */	/* for Z3 alias debugging */

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"


ovmain(func,parm)
 register int func;
 register char *parm;
{
#ifndef Z3
return ERROR;

#else

switch (func)
	{
	case CMD:
		return do_command(parm);
	default:
		send("\nMEZ3: Unknown Overlay function called for.\n");
		return ERROR;
	}

#endif
}

#ifdef Z3


/*************************************************************************
 *  do_command looks for a command in a file of the following format:
 *
 *	Status mask	Command name	Number of parms	   Alias command name
 *     (4 hex chars)   (small string)	   in alias	     ONE WORD ONLY!
 *
 *	All fields are seperated by a space.
 *
 *  		*** EVERY FIELD MUST BE PRESENT!!!!!! ***
 *
 *	The number of parms is not currently acurate.  If there are
 *   more than zero parms expected, it will take the rest of the line up
 *   to the next ';' character (or eol).  It does NOT take several parms
 *   based on the value you give it.
 *	When the alias is performed, and execution should return to
 *    metal upon termination.   This will be fairly slow, but it should
 *    work ok.
 *
 ************************************************************************/

do_command(name)
 char *name;
{
FILE *commands;
unsigned flags;		/* temp storage of current mask flag from file */
char cmd_name[20];	/* current command name in file		   */
int  n_parms;		/* number of parms			   */
char alias[MAXLINE+1];	/* alias to use, parms are simply appended */
char *ccl;		/* pointer to current command line	   */
char *ts;
char a_user,a_drive;	/* user/drive alias is in */
int ti;
char *index();
static struct cmd_line savecmd;

if ((commands=open(COMMANDS,0))==0) return ERROR;

#ifdef Z3BUG
printf("\nCommands file open, trying to match --> '%s'.\n",name);
#endif

read(commands,1);	/* fill buffer to start with */

while (1) {
   fgets(buffer,commands);
   if (strlen(buffer)<10) break;	/* EOF.... */
   while (*buffer=='\n' || *buffer=='\r') strcpy(buffer,buffer+1);
   sscanf(buffer,"%x %s %d %s",&flags,cmd_name,&n_parms,alias);
#ifdef Z3BUG
   printf("\nFlag='%x'  User flag='%x'\nCommand name='%s'  Number of parms='%d'  Alias='%s'.\n",flags,O.user_types[user.type].flags,cmd_name,n_parms,alias);
#endif
   if ( !(flags & O.user_types[user.type].flags) ||
   	 (ustrcmp(name,cmd_name)))
		continue;	/* command doesn't match or not allowed */
   /* Ok, got here, command matches and available to this user */
/*   ts=1+index(1+index(1+index(buffer,' '),' '),' ');    point to alias */
   ccl=z3env->cl->buffer;		/* point to z3 command line buffer */
   movmem(z3env->cl,&savecmd,z3env->cls+4);	/* save for later */
   a_user=0; a_drive=1;	/* normally use A0: */
   if (index(alias,':') && (index(alias)<(5+alias)) )
	{
	a_user=atoi(alias+1);	/* must be duu:alias format */
	a_drive=1+(tolower(*alias)-'a');
	strcpy(alias,index(alias,':')+1); /* delete drive spec */
	}

   sprintf(ccl,"%s ",alias);
   if (n_parms && strloc)	/* get parm if there is one on the line */
	{
	ask("",buffer,40,UPLOW);	/* get next parm */
	strcat(ccl,buffer);		/* append parm to command line */
	}
   strcat(ccl,O.ALIASRET);	/* make sure we return ok.. */
   z3env->cl->next_char=ccl;
   close(commands);
#ifdef Z3BUG
   printf("Command line buffer (Z3 one) is at %xh.  Contents at %xh='%s'.\n",
	  z3env->cl,ccl,ccl);
#endif
   do_alias(&savecmd,a_user,a_drive);	/* never returning function */
   return NULL;				/* if we're here, there's a problem */
   }

/* if we get here, there were problems */

close(commands);
return ERROR;

} /* do_command */


extern char sotries;

/* do_alias function saves globals, and warm boots to perform command */

do_alias(savecmd,a_user,a_drive)
 struct cmd_line *savecmd;
 char a_user,a_drive;
{
struct g_save *gp;	/* pointer to global variable area */
struct g_prot *gh_p;	/* pointer to globals protect header */
/* char *troom;	*/	/* allocated space to play it safe */
char *g_v,*global_loc;	/* pointer to start of all globals (msg, user, etc.) */
char **m_buff;		/* pointer to char pointer */
char *ptr;
int size,i;

global_loc=g_v=malloc(sizeof(user)+sizeof(struct g_save));

#ifdef Z3BUG
printf("\n%xh bytes of free memory required.",sizeof(user)+sizeof(struct g_save) );
printf("\nMalloc=%xh (zero indicates not enough space)\n",global_loc);
#endif

if (!global_loc)
	{
	movmem(savecmd,z3env->cl,(unsigned)((z3env->cls)+4));
	if (user.status==SYSOP)	send("\nERROR: Insufficient memory for aliases.");
	else send("\nCommand unavailable at this time.\n");
	return ERROR;
	}

/* to protect the private global area, we do a bye-like fake of top memory */

ptr=*((char **)0001)+3;		/* Point to bios jump table */
g_h.obdos=*((char **)0x0006);	/* warm boot address */
g_h.g_vars=g_v;			/* pointer arith!.. pt. to globals */
movmem(ptr,g_h.bt,18);		/* copy old bios jmp table */
g_h.prot_bdos=z3_hp;		/* address of our bdos jmp (defined in main) */

/* if (bye!=nothing) movmem(g_h.obdos+0x0c,g_h.bye_a1,32); */	/* save bye vars */

/* this must go before the loop.  z3_hp defined in main */
movmem(&g_h,z3_hp,sizeof(g_h));		/* move to actual location */

for (i=0; i<6; i++)
	{
	unsigned *uptr;
	z3_hp->abt[i].addr=z3_hp->bt[i].addr;  /* fill in our new bios jumps */
	z3_hp->abt[i].swapbdos=&(z3_hp->swap);
	uptr=(ptr+(3*i)+1);
	*uptr=&(z3_hp->abt[i]);		/* store new bios vector */
	}

#ifdef Z3BUG
printf("\nz3_hp=%xh   z3_hp->g_vars=%xh\n",gh_p,gh_p->g_vars);
#endif

#ifdef Z3BUG
printf("\nAfter swap, *(0006)=%xh.\n",*(int *)0006);
#endif

g_v=(z3_hp->g_vars);	/* point to loc for variables */
movmem(&user,g_v,sizeof(user));
g_v+=sizeof(user);
gp=g_v;		/* compute gp like this or problem might occur */

#ifdef Z3BUG
printf("gp=%xh   msg=%xh  (msg should be higher!)\n",gp,msg);
#endif

gp->msg=msg;		/* save location of msg array */
movmem(glbstr,gp->glbstr,MAXLINE+1);
gp->strloc=strloc;
gp->globalch=globalch;
gp->print_flag=print_flag;
gp->echo_flag=echo_flag;
gp->sepstr=sepstr;
gp->fmsg=fmsg;
gp->lmsg=lmsg;
gp->mindex=mindex;
gp->msgcount=msgcount;
gp->privmsgs=privmsgs;
gp->nextmsg=nextmsg;
gp->totalmsgs=totalmsgs;
gp->callnum=callnum;
strcpy(gp->date,date);
strcpy(gp->time,time);
strcpy(gp->last_date,last_date);
strcpy(gp->last_time,last_time);
gp->height=height;
gp->sotries=sotries;
movmem(z3env->expath,gp->path,(z3env->expaths)*2);
(z3env->expath)[0]=a_drive;	/* setup alias drive/user */
(z3env->expath)[1]=a_user;
(z3env->expath)[2]=1;		/* setup A0: for bbs re-entry */
(z3env->expath)[3]=0;
(z3env->expath)[4]=0;		/* end of table */

/* save command buffer, away..  4 bytes overhead for info, and buflen+1 */
movmem(savecmd,&(gp->cmdbuf),(unsigned)(z3env->cls+4));

ptr=0;
*ptr=0xc3;	/* make safe to warm boot */

/* now we put location of global save spot in message buffer (0x48/9) */
m_buff=z3env->msg+O.Z3MSG;
*m_buff=z3_hp;	/* global_loc; */		/* save this away */

#ifdef Z3BUG
   printf("Command line buffer (Z3 one) is at %xh.  Contents are '%s'.\n",
	  z3env->cl,z3env->cl->buffer);
   printf("Old contents were '%s'.\n",savecmd->buffer);
#endif

exit(0);	/* and do so */

}	/* routine generally never returns */


#endif /* Z3 */

/* eof.. */

