;ASCII.ASM by Doug Cox, June 13, 1987
code    segment
	assume	cs:code,ds:code
	org	100h
start:  jmp     short begin
mode	db	0
topline db	'ASCII:   H          (use ARROW KEYS to move cursor   ESC to exit)'
ascii	db	0		;holds current ascii number
row	db	6
col	db	8
dectab  db      100,10,1        ;for binary to decimal conversion

begin:	mov	ah,0fh		;function to check screen mode
	int	10h
	cmp	al,0bh		;indicates display mode
	jb	notega
	jmp	exit
notega: mov	mode,al 	;save it
        mov     ax,02
	int	10h		;clear screen
	mov	ah,1		;function to change cursor shape
	mov	ch,0		;top line
	mov	cl,2		;2 lines down
	int	10h

	mov	ax,0b000h	;monochrome screen memory location
	cmp	mode,7
        je      mono            ;if monochrome display
	add	ax,800h 	;for CGA screen
mono:   mov     es,ax

;write top line
	lea	si,topline
	mov	di,334
	mov	cx,66
movlp:	movsb
	inc	di
	loop	movlp

;put ascii characters on screen
        mov     al,0
	mov	di,816
        mov     bx,8            ;line count
loopo:	mov	cx,32		;chars/line
loopi:	mov	es:[di],al
	add	di,4
	inc	al
	loop	loopi
	add	di,192		;160+32 (to go to next line)
	dec	bx
	jnz	loopo

;main loop
bigloop:mov     ah,2            ;function to move cursor
	mov	bh,0		;page
	mov	dh,row
	mov	dl,col
	int	10h

;display ascii char numbers in hex
	mov	ah,ascii	;it doesn't matter what's in al
	mov	di,348		;screen location
	mov	ch,2		;2 chars
binloop:mov	cl,4
	rol	ax,cl
	and	al,0fh
        add     al,30h
	cmp	al,3ah
	jl	num
	add	al,7
num:	stosb			;put it on screen
	inc	di
	dec	ch
	jnz	binloop

;display ascii char numbers in decimal
	mov	ah,ascii
	mov	di,358
	lea	si,dectab
decilp1:mov	dl,[si] 		;first loop puts 100,10,or 1 in dl
	cmp	dl,1
	je	deciend
	sub	ah,dl
	jnc	deciok
	add	ah,dl
	inc	si
	jmp	short decilp1
deciok: mov	al,'1'
decilp2:mov	es:[di],al
	sub	ah,dl
	jc	deciskp
	inc	al
	jmp	short decilp2
deciskp:add	ah,dl
	inc	di
	inc	di
	inc	si
	mov	dl,[si]
	cmp	dl,1
deciend:mov	al,'0'
	jne	decilp2
	or	al,ah
	stosb
	inc	di
	mov	al,0		;to erase left-over numbers
	mov	cx,3
endlp:	cmp	di,362
	ja	toprow		;don't erase beyond decimal area
	stosb
	inc	di
	loop	endlp

;display ctrl-chars if on top line
toprow: cmp	row,6
	jne	notrow6
	mov	es:[366],byte ptr '^'
	mov	al,ascii
	add	al,64
	mov	es:[368],al
        jmp     short readkbd

notrow6:mov	es:[366],byte ptr 0
	mov	es:[368],byte ptr 0

readkbd:mov     ah,0            ;read keyboard function
	int	16h
	cmp	al,1bh		;ESC
	jne	notexit
	jmp	exit
notexit:cmp	ah,72		;Up arrow
	je	up
	cmp	ah,80		;Down arrow
	je	down
	cmp	ah,75		;Left arrow
	je	left
	cmp	ah,77		;Right arrow
	je	right
        jmp     readkbd

up:	cmp	row,6
	je	bigjmp
	dec	row
	dec	row
        sub     ascii,32
bigjmp: jmp	bigloop

down:	cmp	row,20
	je	bigjmp
	inc	row
	inc	row
        add     ascii,32
	jmp	bigloop

left:	cmp	col,8
	je	bigjmp
	dec	col
	dec	col
        dec     ascii
	jmp	bigloop

right:	cmp	col,70
	je	bigjmp
	inc	col
	inc	col
        inc     ascii
	jmp	bigloop

exit:	mov	bh,0		;page
	mov	al,mode
	mov	ah,0		;set screen mode function
	int	10h
	mov	ax,2		;clear screen function
	int	10h
        int     20h             ;return to DOS

code    ends
	end	start
