
/*
Ŀ
jzcpyfil.c								     
Copy a file (wild cards are ok)					     
									     
synopsis								     
  werr = jzcpyfil("\\jaz\\*.*","a:\");                                      
									     

*/

#include <jaz.h>
#include <jzdirect.h>

#define SIZE 32767

jzcpyfil(fsource,fdestin)
char *fsource;
char *fdestin;
{
  int wsource,wdestin;
  int wnum;
  TDIR wdir;
  int werr,wpos;
  int w;
  char wspath[65],wdpath[65];		/* source and destin path names */
  char wtemp[65];
  char *wbuf,*malloc();

  if ( (wbuf = malloc(SIZE)) == 0 ) {
    printf("\Out of memory for copy, Aborting...");
    exit(255);
  }

  strcpy(wspath,fsource);
  strcpy(wdpath,fdestin);

  for (w = strlen(wspath) - 1 ; w >= 0 ; w --)	/* parse out path */
    if (wspath[w] == '\\')
      break;

  if (w >= 0)
    wspath[w+1] = 0;			/* hold only the path */
  else
    *wspath = 0;			/* Null path string */

  w = strlen(wdpath) - 1;

  if (index("?*:",*(wdpath+w)) != -1 ) {
    for ( ; w >= 0 ; w --)
      if ((index("\\:",*(wdpath+w))) != -1)
	break;
    *(wdpath+w+1) = 0;
  }
  else
    strcat(wdpath,"\\");

  #if DEBUG
    printf("\nsource: %s",wspath);
    printf("\ndestin: %s",wdpath);
  #endif
		       /**
			** Here's where we search the directory
			**/

  werr = jzfndfst(fsource,32,&wdir);	/* find first matching file */

  if (werr == 0)			/* perform directory search   */
    do {
      strcpy(wtemp,wspath);		/* get source path into wtemp */
      strcat(wtemp,wdir.name);		/* get full source path name  */
      wsource = jzopnfil(wtemp,0);	/* open for read only  */
      strcpy(wtemp,wdpath);		/* get destin path into wtemp */
      strcat(wtemp,wdir.name);		/* get full destin path name  */
      wdestin = jzcrtfil(wtemp,0);	/* create file normal attribute */
      printf("\n%s",wdir.name);

		       /**
			** Here's where we copy the file.
			**/

      do {
	wnum = jzredfil(wsource,wbuf,SIZE);	/* request SIZE bytes to read */
	if (wnum)
	  jzwrtfil(wdestin,wbuf,wnum);		/* write only num read */
      } while (wnum);

      jzclsfil(wdestin);
      jzclsfil(wsource);

      werr = jzfndnxt(&wdir);			/* get next item */
    } while (werr == 0);
  else
    printf("\Not Found");
}
