#include <jaz.h>

/*
Ŀ
jzpop									     
Pop data off the stack into a data structure				     
If fsize <> 0 then we use fsize, otherwise we use the size of the stack data
Synopsis								     
   jzpush (&whead,&wdata,10);						     
   jzpop  (&whead,wstr,0);						     

*/

jzpop(fhead,fdata,fsize)
TSTKHEAD *fhead;
char *fdata;
int fsize;
{
  TSTACK *wtemp;

  if (fhead->numitems) {	/* don't pop anything if there is no stack */

    /** AT this point, wint contains the
     ** size of the data on the stack.
     ** if fsize, use that for number of bytes,
     ** otherwise use the saved size of the data
     **/

   if (! fsize) 			/* Check user size arg */
     fsize = fhead->last->wint;

    memcpy(fdata,fhead->last->pointer,fsize);

    wtemp = fhead->last;		/* save temp copy of pointer */

    fhead->last = fhead->last->prev;
    fhead->numitems --; 		/* decrement count of items */

    free(wtemp->pointer);		/* free memory for path */
    free((char *) wtemp);

    if (! fhead->last)			/* empty list ? */
      fhead->first = 0; 		/* set first = NULL */

  }
}
