
/*
Ŀ
jzsekfil.c								     
Seek forwards or backwards in a file					     
Parms									     
  whandle	  handle of file to seek				     
  Offset	  Distance to seek (Long Integer)			     
  Method	  0 = offset from beginning,1 = offset from current loc,     
		  2 = end of file + offset.				     
  Returns	  Offset from beginning of file.			     

*/

#include <jaz.h>

long jzsekfil(fhandle,foffset,fmethod)
int fhandle;
unsigned long foffset;
int fmethod;

{
  TREG wreg;

  wreg.h.ah = 0x42 ;		    /* seek file */
  wreg.h.al = fmethod;

  wreg.x.dx = (int) (foffset & 0xFFFFL);

  wreg.x.cx = (int) ((foffset & 0xFFFF0000L) >> 8);

  wreg.x.bx = fhandle;

  msdos(&wreg);

  if (wreg.x.flags & 1)
    return(-1L);
  else
    return((long)((wreg.x.dx << 8) + wreg.x.ax));
}
