/****************************************************************
*                                                               *
*                       O R B I T S                             *
*                                                               *
*  This program will compute the Helio-centric, Geo-centric,    *
*  and Alt-Azimuth coordinates for the nine planets and         *
*  Halley's comet for any date and time in the reasonable past, *
*  present, or future. (reasonably accurate for +- 500 years)   *
*                                                               *
*  This program was translated to 'C' by Pete Mastren from a    *
*  BASIC program by Don Carrera 'Planetary Orbits' that         *
*  appeared in 80 micro, January 1983, Pages 156-174.  Please   *
*  see the original article for excellent discussions of the    *
*  mathematics and error analysis of these calculations.        *
*                                                               *
*  The statement labels in this program are for reference to    *
*  the line numbers in the original BASIC program.              *
*								*
*  Be sure to change the compile time defaults for LATT and	*
*  LONG for your area.						*
*								*
****************************************************************/
/****************************************************************
*								*
*			N O T E S				*
*								*
*  This program runs well on a unix machine but it has a few	*
*  blemishes on MS-DOS.  It compiles and computes ok with	*
*  Lattice 'C' ver 2.10 but the escape for entering another	*
*  equinox and different lattitude and longitude needs to be	*
*  changed from an 'eof' to something else for MS-DOS.		*
*								*
*  You might want to supply a routine (time) to return the	*
*  local time of day and a routine (gmtime) to convert it	*
*  to GMT so you can just enter return to get the current	*						*
*  planetary positions.						*
*								*
*  I apologise for the slow execution.  This program is run	*
*  on a Z8000 based unix machine with an almost imperceptible	*
*  compute delay.						*
*								*
*					Pete Mastren		*
*                                                               *
****************************************************************/
#include <math.h>
#include <stdio.h>
#include <time.h>
#undef abs
#undef min

#define pi 3.14159265358979323846
#define rad(x) ((x)*pi/180.)
#define deg(x) ((x)*180./pi)
#define abs(x) ((x)<0 ? -(x) : (x))

int days[] = {0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
int year, month;                /* date of interest             */
double day;                     /*  "   "     "                 */
double jd;                      /* julian date                  */
double tod;                     /* time of day                  */
double tj;                      /* number centuries to adjust   */
double an;                      /* ascending node               */
double per;                     /* argument of perihelion       */
double ecc;                     /* eccentricity                 */
double i;                       /* inclination to ecliptic      */
double u;                       /* argument of latitude         */
double ma;                      /* mean anomaly                 */
double ea;                      /* eccentric anomaly            */
double ta;                      /* true anomaly                 */
double obliq;                   /* obliquity of ecliptic        */
double xsun, ysun, zsun;        /* sun rectangular coordinates  */
double xp, yp, zp;              /* planet rect coordinates      */
double rh;                      /* right ascension (hours)      */
double rm;                      /* right ascension (minutes)    */
double LONG = 117.85;           /* longitude of Anaheim, CA     */
double LATT = 33.8;		/* latitude of Anaheim, CA      */

typedef struct {
        char z[10];             /* name                         */
        double n;               /* period of revolution         */
        double a;               /* orbit radius                 */
        double e1cc, de;        /* orbit eccentricity (& delta) */
        double i1, di;          /* orbit inclination (& delta)  */
        double p1er, dp;        /* arg of perihelion (& delta)  */
        double a1n, da;         /* ascending node (& delta)     */
        double tpp;             /* last perhelion passage       */
      } PLANETS;

PLANETS *parm;

/************************************************
*                                               *
*   Planetary constants as of June 10, 1980     *
*                                               *
************************************************/
PLANETS planet[] = {
    { "Mercury",4.0923388,
                0.387099,
                0.205631,       .00002,
                7.00437,        .002,
                77.1509,        1.5555,
                48.0994,        1.1852,
                2444376.770 },
    { "Venus",  1.60213,
                .723332,
                .006783,        -.00005,
                3.39444,        .001,
                131.2958,       1.4080,
                76.5038,        .8998,
                2444323.110 },
    { "Earth",  .985609,
                1.,
                .016717,        -.00004,
                0.,             0.,
                102.6040,       1.7192,
                0.,             0.,
                2444242.321 },
    { "Mars",   .524033,
                1.52369,
                .093387,        .00009,
                1.8498,         -.0007,
                335.6989,       1.8408,
                49.4066,        .77099,
                2443951.049 },
    { "Jupiter",.083091,
                5.2028,
                .0484687,       .00016,
                1.3042,         -.006,
                14.008,         1.6111,
                100.251,        1.0108,
                2442636.0 },
    { "Saturn", .0334597,
                9.53884,
                .055614,        -.0003,
                2.4889,         -.004,
                92.665,         1.9583,
                113.486,        .87306,
                2442078.000 },
    { "Uranus", .011732,
                19.1818,
                .047262,        .0003,
                .77194,         .0006,
                170.34,         1.6250,
                73.90,          .5111,
                2439384.2 },
    { "Neptune",.005981,
                30.058,
                .008590,        .0001,
                1.7719,         -.009,
                44.453,         .8778,
                131.565,        1.1017,
                2408034.700 },
    { "Pluto",  .003921,
                39.829,
                .25478,         0.,
                17.137,         0.,
                223.014,        1.5,
                109.96,         .8,
                2355886.700 },
    { "Halley", -.0130008,
                17.95,
                .9673,          0.,
                -17.5,          0.,
                306.9,          1.6,
                60.0,           3.3,
                2418781.500 }
  };
#define NPL (sizeof(planet)/sizeof(PLANETS))

double r[NPL], l[NPL], lat[NPL];        /* heliocentric coordinates */
double ds[NPL], cl[NPL], ra[NPL];       /* geocentric coordinates   */

/****************************************************************
*                                                               *
*  Compute planetary orbits                                     *
*                                                               *
****************************************************************/
main()
{
    int b, c, lyr, y1, k;
    int iday, hour, min, sec;
    long tim;
    double j0, m0, dl;
    double alt, az, hra, z1, z2;
    char ans[80];
    struct tm *gmt, *gmtime();

    printf("\f");

st630: /* enter the date of interest and convert to julian date */
    while(1)
      { printf("\nEnter date of interest (YYYY/MM/DD [HH:MM]) GMT: ");
        if (gets(ans) != NULL) break;
        do
          { printf("\f");
            printf("\nWant geocentric referred to another equinox? ");
            if ((c=scanf("%s",ans)) < 0) exit(0);
          } while (c == 0);

        if (ans[0] == 'y' || ans[0] == 'Y')
        do
          { printf("What year do you want results referred to? ");
            if ((c=scanf("%d",&y1)) < 0) exit(0);
            k = 1;
          } while (c == 0);
        else k = 0;

        do
          { printf("Enter reference lattitude (%g): ",LATT);
            if ((c=scanf("%lf",&LATT)) < 0) exit(0);
          } while (c == 0);

        do
          { printf("Enter reference longitude (%g): ",LONG);
            if ((c=scanf("%lf",&LONG)) < 0) exit(0);
          } while (c == 0);

        printf("\f");
      }

    if (strlen(ans) > 1)
      { hour = min = sec = 0;
        sscanf(ans,"%d/%d/%d %d:%d:%d",&year,&month,&iday,&hour,&min,&sec);
        day = iday;
      }
/****************************************
*  May have to substitute your own      *
*  method of setting current date       *
*  and time here                        *
****************************************/
    else
      { time(&tim);
        gmt = gmtime(&tim);
        year = gmt->tm_year + 1900;
        month = gmt->tm_mon + 1;
        day = gmt->tm_mday;
        hour = gmt->tm_hour;
        min = gmt->tm_min;
        sec = gmt->tm_sec;
      }

/****************************************
*  compute Julian date                  *
****************************************/
    tod = 60*hour + min;
    tod = (60.*tod + sec) / 86400.;
    day += tod;
    tod = 24. * tod;
    j0 = (year%4 == 0) && (year%400==0 || year%100!=0) && month>2;
    if (year < 0) year -= 1;
    jd = year + 4712;
    lyr = (int) ((jd-1)/4);
    jd = 365*jd + lyr;

st660: /* correction for Julius Ceaser's shortsightedness */
    if(year>1582||(year==1582&&(month>10||(month==10&&day>=15))))
      { jd -= 10;
        jd += (float)((int)((year-1201)/400) - (int)((year-1501)/100));
      }
    jd += (float) days[month-1] + (float) day - .5 + j0;
    printf("\nJulian date is %.10g:  %02d/%02d/%4d",jd,month,(int)day,year);
    printf("  %02d:%02d GMT\n",hour,min);

st750: /* number of centruies between date and June 10, 1980 */
    tj = (jd-2444400.5) / 36525.;

st910: /* loop for 9 planets and Halley's comet */
    for (b=0; b<NPL; b++)
      { parm = &planet[b];
	if (kbhit()) break;

st930: /* correct June 10, 1980 constants to day of interest */
        ecc = parm->e1cc + parm->de*tj;
        per = rad(parm->p1er) + rad(parm->dp)*tj;
        an = rad(parm->a1n) + rad(parm->da)*tj;
        i = rad(parm->i1) + rad(parm->di)*tj;

st970: /* calculate the mean anomaly */
        ma = rad(parm->n * (jd-parm->tpp) - (parm->dp-1.3965)*tj);

st980: /* iterate apporximation of eccentric anomaly */
        ea = ma + ecc*sin(ma);
        do
          { m0 = ea - ecc*sin(ea);
            dl = (ma-m0) / (1-ecc*cos(ea));
            ea += dl;
          } while (abs(dl) > .0001);

st1030: /* find distance from sun */
        r[b] = parm->a * (1-ecc*cos(ea));

st1040: /* find true anomaly of planet */
        ta = 2 * atan(sqrt((1+ecc)/(1-ecc)) * tan(ea/2));

st1050: /* find argument of latitude to correct longitude for
           orbital inclination */
        u = ta + per - an;
        if (u <= 0) u += 2*pi;
        if (u > 2*pi) u -= 2*pi;

st1090: /* find longitude of planet in correct quadrant */
        l[b] = an + atan(cos(i) * tan(u));
        if (u>pi/2)
          { if (u>3*pi/2) l[b] += 2*pi;
            else          l[b] += pi;
          }
        if (l[b] > 2*pi) l[b] -= 2*pi;

st1150: /* find lattitude of planet */
        lat[b] = asin(sin(i) * sin(u));

      }


/****************************************************************
*                                                               *
* calculate geocentric coordinates for selected date optionally *
* referred to the equinox of a different date                   *
*                                                               *
****************************************************************/
    if (k) printf("Results referred to equinox of %d\n",y1);
    printf("\t**** Heliocentric *****  ****** Geocentric *******");
    printf("    ** Alt-Azimuth **\n");
    printf("\t    R     Lon      Lat       R    Rt Ascen  Declin");
    printf("    Azimuth    Alt\n");
    printf("\t (A.U.)  (Deg)    (Deg)   (A.U.)  (Hr:Min)   (Deg)");
    printf("      (Deg)   (Deg)\n");

st1420: /* correct obliquity for date of interest */
    obliq = rad(23.4419 - .013*tj);

st1430: /* get rectangular coordinates of earth */
    xsun = r[2] * cos(l[2]+pi);
    ysun = r[2] * sin(l[2]+pi) * cos(obliq);
    zsun = r[2] * sin(l[2]+pi) * sin(obliq);

    for (b=0; b<NPL; b++)
      { if (kbhit()) break;
	if (b==2)
          { cl[b] = atan2(zsun,sqrt(xsun*xsun + ysun*ysun));
            ra[b] = atan2(ysun,xsun);
            ds[b] = r[b];
            if (ra[b] < 0) ra[b] += 2*pi;
            goto st1630;
          }

st1480: /* get rectangular coordinates of planet */
        xp = r[b] * cos(lat[b]) * cos(l[b]) + xsun;
        yp = r[b] * (cos(lat[b]) * sin(l[b]) * cos(obliq) - sin(lat[b]) * sin(obliq)) + ysun;
        zp = r[b] * (cos(lat[b]) * sin(l[b]) * sin(obliq) + sin(lat[b]) * cos(obliq)) + zsun;

st1540: /* get arguments of planet */
        ds[b] = sqrt(xp*xp + yp*yp + zp*zp);
        cl[b] = asin(zp/ds[b]);
        ra[b] = atan2(yp,xp);
        if (ra[b] < 0) ra[b] += 2*pi;

st1630: /* reference to equinox of different date */
        if (k)
          { z1 = y1 - year;
            cl[b] += rad(.005567*z1)*cos(ra[b] + rad(.0064*z1));
            ra[b] += rad(.0128*z1) + rad(.005567*z1)*sin(ra[b])*tan(cl[b]);
            if (ra[b] <= 0) ra[b] += 2*pi;
            if (ra[b] > 2*pi) ra[b] -= 2*pi;
          }

st1680: /* convert right ascension from degrees to hours */
        rh = (int) (deg(ra[b])/15);
        rm = 60 * (deg(ra[b])/15 - rh);

st1870: /* compute alt-azimuth coordinates */
        hra = 15*rad(17.2182 + .0657093*(jd-2444400.5) + 1.0027*tod);
        hra -= ra[b] + rad(LONG);
        z2 = sin(cl[b])*sin(rad(LATT)) + cos(cl[b])*cos(rad(LATT))*cos(hra);
        alt = atan2(z2,sqrt(1-z2*z2));
        z1 = -cos(cl[b])*sin(hra);
        z2 = sin(cl[b])*cos(rad(LATT)) - cos(cl[b])*sin(rad(LATT))*cos(hra);
        az = atan2(z1,z2);
        if (az<0) az += 2*pi;

        printf("%-8s %6.3f %7.3f %7.3f",planet[b].z,r[b],deg(l[b]),deg(lat[b]));
        printf("  %7.3f %2.0f:%06.3f %7.3f    %7.3f %7.3f\n",ds[b],rh,rm,deg(cl[b]),deg(az),deg(alt));
      }
    goto st630;
}
                                                                                             