
#include "dos.h";
#include "stdio.h";

#define PORT 0                         /* For COM1. 1 for COM2 */
#define _DATAREADY 1

unsigned char calcparm();
unsigned int setparms();
unsigned char charin();
unsigned int getstat();
FILE *fstart();

main(argc, argv)
int argc;
char *argv[];
{
FILE *f;
unsigned char ch, parmbyte;

   f = fstart(argc, argv);
   if (f == NULL) 
      exit();

/* Calculate and set the parameter byte */

   parmbyte = calcparm(300, 0, 1, 8);            /* Program 16.5           */
   setparms(PORT, parmbyte);                     /* Program 16.1           */

/*
* First we have to call charin because only that sets up the outgoing
* handshaking lines. It will return after a time-out.
*/
   charin(PORT, &ch);

   printf("%s \n", "Press any key to start download");
   getch();

   downl2(f);

   fclose(f);                                    /* Close the File         */

   printf("%s \n", "Finished");
      
}

downl2(f)
FILE *f;
{
unsigned char ch, ah, al;
unsigned int status, timeout;

   printf("%s \n", "Press 'ESC' to stop download");

   for (;;) {

      if (kbhit()) {
         if (getch() == 27) 
                                return;          /* Hit ESC                */
      }

      if (timeout == 4000) {                     /* Warning Message        */
         printf("%s \n", "Waiting");
         timeout = 0;
      }

      status = getstat(PORT);                    /* Program 16.4           */

      ah = status >> 8;

      al = status;
/*
* We could test the other status bits for errors here
*/
      if (! (ah & _DATAREADY)) {                 /* Nothing received       */
         ++timeout;
         continue;
      }

      timeout = 0;

/* We know a character has been received so we will read it       */

      charin(PORT, &ch);                         /* Program 16.3           */

      fputc(ch, f);                              /* record it to the file  */

      putchar(ch);                               /* Display it             */
   }
}



/* Figure 16.9: DOWNL2: Read a File, ROM-BIOS version */


