#include <dos.h>

int _delaycounter;  /* used by delay() to count number of loops = 1/100 sec */

void setupdelay(void);
void delay(int HundredthSec);
void sound(int Freq, int Duration);
void beep(void);

/*
 *  I wrote these procedures not because I'm an expert in C (by no means)
 *  but because I was used to the Turbo Pascal functions for:
 *
 *  TP  delay(time) <->  TC delay(time)
 *  TP  sound(freq) <->  TC sound(freq,time)
 *  TP  nosound     <--^
 *
 *  I created my own sound() and delay() functions.  I did not create a
 *  nosound() function simply because I included an additional parameter
 *  in the sound statement to ask for the length of time that the speaker
 *  should be left on.
 *
 *  NOTE:  In order to use either the sound() or the delay() functions you
 *         MUST have called setupdelay() at least once.  (you only need to
 *         do it once, thereafter the delay counter is already set up).
 *
 *  The delay() function accepts a parameter signifying one hundredth (1/100)
 *  of a second.  In other words  delay(50)  will cause a delay of 1/2 second
 *  while delay(505) will pause for 5.05 seconds.
 *
 *  The sound() function accepts two parameters, a frequency and a time
 *  delay.  Since in TP I was always doing sound(x); delay; nosound;  I
 *  figured why not include all three statements in one function.
 *
 *  The beep() function is just a sample bell that I use all of the time.
 *  Anyway, I hope this benefits somebody...
 *                                             David W. Terry 71560,3550
 */

/*************************************************************************
 *
 *  setupdelay()   MUST BE CALLED IN ORDER TO USE:  delay() or sound()
 */

void setupdelay(void) {
  unsigned long int far *Timer = 0x46CL;
  unsigned long int Stop;
  int register Count,SubCount;

  Count = 0;
  disable();
  Stop = *Timer;
  enable();
  while (*Timer == Stop);       /* wait until the beginning of a clock tick */

  disable();
  Stop = *Timer + 4;            /* Stop = *Timer + 4 clock ticks */
  enable();
  while (*Timer < Stop) {       /* wait until stopping point is reached   */
    Count++;
    for (SubCount = 200; SubCount; SubCount--);
  }
  _delaycounter =((long)Count * 455) / 10000; /* number of loops = 1/100 sec */
}

/*************************************************************************
 *
 *  delay()   parameter = 1/100 sec.  i.e.  delay(50) = pause of 1/2 sec.
 */

void delay(int HundredthSec) {

  unsigned int register Count,SubCount;

  for (Count = HundredthSec * _delaycounter; Count; Count--)
    for (SubCount = 200; SubCount; SubCount--);
}

/*************************************************************************
 *
 *  sound()   parameters = Sound Frequency and Duration of sound - see delay()
 */

void sound(int Freq, int Duration) {
  unsigned int Count;
  unsigned char Off,On;

  Count = 1193280L / Freq;  /* determine the timer frequency */

  outportb(67,182);         /* set up the timer */
  outportb(66,Count & 255);
  outportb(66,Count >> 8);

  Off = inportb(97) & 0xFC; /* get current status   */
  On  = Off | 3;            /* turn on bits 0 and 1 */

  outportb(97,On);          /* turn on the speaker            */
  delay(Duration);          /* wait for Duration/1000 seconds */
  outportb(97,Off);         /* turn off the speaker           */
}

/*************************************************************************
 *
 *  beep()  An example bell I use in my programs
 */

void beep(void) {
  sound(440,10);
  sound(220,10);
}
