#include <stdio.h>


extern FILE *fopen();
extern int timestart(), timend(), timeohd();


char test_disk[10];


/* Declare all benchmark routines
*/
extern int cparr(), cpptr();
extern int lpauto(), lpstatic(), lp2regs(), lp5regs();
extern int clcint(), clclong(), clcflt(), clcdbl();
extern int aacptr(), aasptr();
extern int calltest();
extern int lbstrlen(), lbstrcpy(), lbstrcmp();
extern int fcharcpy(), charcpy(), fbufcpy(), bufcpy(), fseekio(), seekio();
extern int rptcsort(), rptshell();
extern int dry();



struct benchdat
        {
        int (*bd_brtn)();       /* Pointer to the benchmark routine */
        char *bd_name;          /* printf format */
        unsigned int bd_lpcnt;  /* Loop count for the test */
        int bd_time;            /* Running time for the test */
        };

struct benchdat testbed[] =
        {
        /* Test to be performed goes here */
           { dry,       "drystone     ",     1, 0 },
           { (int (*)()) 0, NULL, 0, 0 }

#if 0

        /* Memory reference */
           { cparr,     "cp array     ",  1500, 0 },
           { cpptr,     "cp pointer   ",  4000, 0 },
           { lpauto,    "lp auto      ",    75, 0 },
           { lpstatic,  "lp static    ",    75, 0 },
           { lp2regs,   "lp 2 reg vars",    75, 0 },
           { lp5regs,   "lp 5 reg vars",    75, 0 },

        /* Math */
           { clcint,    "calc int     ",  7000, 0 },
           { clclong,   "calc long    ",  1000, 0 },
           { clcflt,    "calc float   ", 10000, 0 },
           { clcdbl,    "calc double  ", 10000, 0 },
           { aacptr,    "aa char ptr  ",  6400, 0 },
           { aasptr,    "aa struct ptr",  6400, 0 },

        /* Call */
           { calltest,  "call overhead", 10000, 0 },

        /* Disk I/O - buffered/unbuffered, ram disk
         *   NOTE:      charcpy takes about 180 seconds/pass to disk c:
         */
           { fcharcpy,  "cp f- char   ",     7, 0 },
           { charcpy,   "cp    char   ",     1, 0 },
           { fbufcpy,   "cp f- block  ",    25, 0 },
           { bufcpy,    "cp    block  ",    25, 0 },
           { fseekio,   "cp f- seekio ",  1000, 0 },
           { seekio,    "cp    seekio ",  1500, 0 },

        /* Libraries */
           { lbstrlen,  "lib strlen   ",  4000, 0 },
           { lbstrcpy,  "lib strcpy   ",  2500, 0 },
           { lbstrcmp,  "lib strcmp   ",  2500, 0 },

        /* Dummy applications */
           { rptcsort,  "rpt c sort   ",     1, 0 },
           { rptshell,  "rpt shellsort",     1, 0 },
           { dry,       "drystone     ", 50000, 0 },

           { (int (*)()) 0, NULL, 0, 0 }
#endif
        };





main (argc, argv)
        int argc;
        char *argv[];
        {
        register struct benchdat *testbedp;
        FILE *resfp;
        long lpm;
        int total, timeovrhd, runtime;
        char resultfile[40];


        total = 0;
        if (argc != 3)
                {
                printf ("\n\n\nuse:  bench resultfile test_drive\n\n\n");
                exit (1);
                }

        strcpy (resultfile, argv[1]);
        strcat (resultfile, ".dat");
        strcpy (test_disk, argv[2]);


/* Figure out the timer overhead.
*/
        timeovrhd = timeohd ();


/* Run the benchmark routines
*/
        for (testbedp = &testbed[0];  testbedp->bd_name != NULL;  testbedp++)
                {
                if ((testbedp->bd_time =
                     (*testbedp->bd_brtn) (testbedp->bd_lpcnt)) == 0x8000)
                        printf ("%s  FAILED\n");

                else    {
                        if ((runtime = testbedp->bd_time - timeovrhd) == 0)
                                printf ("%s  %5u     %4d.%1d\n",
                                        testbedp->bd_name, testbedp->bd_lpcnt,
                                        runtime / 10, runtime % 10);
                        else    {
                                total += runtime;
                                lpm = testbedp->bd_lpcnt *
                                        ((6000L + (runtime / 2)) / runtime);
                                printf ("%s  %5u     %4d.%1d     %6ld.%1ld\n",
                                        testbedp->bd_name, testbedp->bd_lpcnt,
                                        runtime / 10, runtime % 10,
                                        lpm / 10, lpm % 10);
                                }
                        }
                }


/* Print out the results
*/
        resfp = fopen (resultfile, "w");
        fprintf (resfp,
                 "Test name   Loop Count     Time     Loops / Minute\n\n");

        for (testbedp = &testbed[0];  testbedp->bd_name != NULL;  testbedp++)
                {
                if (testbedp->bd_time == 0x8000)
                        fprintf (resfp, "%s  FAILED\n");

                else    {
                        if ((runtime = testbedp->bd_time - timeovrhd) == 0)
                                fprintf (resfp, "%s  %5u     %4d.%1d\n",
                                         testbedp->bd_name, testbedp->bd_lpcnt,
                                         runtime / 10, runtime % 10);

                        else    {
                                lpm = testbedp->bd_lpcnt *
                                        ((6000L + (runtime / 2)) / runtime);
                                fprintf (resfp,
                                         "%s  %5u     %4d.%1d     %6ld.%1ld\n",
                                         testbedp->bd_name, testbedp->bd_lpcnt,
                                         runtime / 10, runtime % 10,
                                         lpm / 10, lpm % 10);
                                }
                        }
                }

        fprintf (resfp, "\nTOTAL:  %4d.%1d\n", total / 10, total % 10);

        fclose (resfp);
        exit (0);
        }
