
/*
 * dt - disk test
 *
 * Samuel H. Smith, 13-feb-88
 *
 */

#include <stdio.h>
#include <dos.h>
#include <bios.h>
#include <ctype.h>
#include <errno.h>

struct dfree   dfree;

#define SECSIZ   512    /* bytes per sector */
#define NSECT    31     /* sectors per read */
#define CLUSTSEC 1      /* clusters per sector (used after errors) */
char secbuf[NSECT*SECSIZ];


test_range(char disk,
           unsigned last)
{
        unsigned current;
        unsigned single;
        int result;
        long start;
        int elapsed;
        int maxtime = 999;

        printf("\nTesting disk %c: sectors 0..%u\n",disk,last);

        for (current = last-NSECT+1;
             current > NSECT;
             current -= NSECT)
        {
                printf("\r  %5u ",current);
                start = biostime(0,0L);
                result = absread(disk-'A',NSECT,current,secbuf);
                elapsed = biostime(0,start) - start;
                printf("%3d    ",elapsed);

                /* extablish max time for read based on SECOND read request */
                if (maxtime == 999)
                        maxtime = 888;
                else
                if (maxtime == 888)
                        maxtime = elapsed * 2 + 1;

                /* report errors or slow reads */
                if (result)
                        perror("- Error");
                else
                if (elapsed > maxtime) 
                {
                        printf("- Slow\n");
                        result = 999;
                }

                /* if there was an error then switch to single sectors and
                   rescan the sectors in question */
                if (result && (NSECT > 1)) 
                {
                        for (single = current; 
                             single < (current+NSECT); 
                             single += CLUSTSEC)
                        {
                                printf("\r     %5u ",single);
                                start = biostime(0,0L);
                                result = absread(disk-'A',CLUSTSEC,single,secbuf);
                                elapsed = biostime(0,start) - start;
                                printf("%3d    ",elapsed);
                                if (result)
                                        perror("- Error");
                                else
                                if (elapsed > maxtime) {
                                        printf("- Slow\n");
                                        result = 999;
                                }
                        }
                }
        }

        printf("\nTest completed.\n");
}



main(int argc,
     char *argv[])
{
        char disk;

        if (argc != 2)
        {
                printf("usage:  disktest d:\n");
                exit(1);
        }

        disk = argv[1][0];
        if (islower(disk))
                disk = toupper(disk);

        getdfree(disk-'@',&dfree);
        test_range(disk,dfree.df_total*dfree.df_sclus);
}

