PAGE ,132
TITLE List Bad Cluster Program, Version 1.23, 12-Jan-1987

;
; Written By Steven Georgiades
;
; List Bad Cluster Program
;   Will respond with a list of all the clusters on the disk that are
;   marked as bad.
;
;       If you are using this program and find it of value, your
;       contribution in any amount ($5.00 suggested) will be greatly
;       appreciated.  Makes checks payable to Steven M. Georgiades.
;               Thank you.
;
;       If you have any questions or comments about this or any other
;       SMG program, call or write:
;
;               Steven M. Georgiades
;               SMG Software
;               701-H South Hayward Street
;               Anaheim, CA 92804
;               (714) 826-9549
;

CODE      SEGMENT BYTE PUBLIC 'CODE'

          ASSUME  CS:CODE,DS:CODE,ES:CODE,SS:CODE

          ORG     5CH

FCB       LABEL   BYTE

          ORG     100H

LISTBAD:  JMP     BEGIN

AND_STR   DB      " , $"
CLSTSTR   DB      "XXXXX$"
ERR_DRV   DB      "Error reading drive x:",7
CRLF      DB      13,10,"$"
HDR_MSG   DB      "Drive x: has $"
BAD_MSG   DB      "the following clusters marked as bad:",13,10,10,"$"
NBAD_MSG  DB      "no clusters marked as bad$"
SIGNON    DB      "List Bad Cluster Program, Version 1.23",13,10
          DB      "SMG Software",13,10
          DB      "(C) Copyright 1986,1987 Steven Georgiades",13,10,10,"$"
TO_STR    DB      " to$"
TOT_MSG   DB      13,10,10,"Total Clusters Marked as Bad = $"

BAD_CLST  DW      0FF7H
BAD_CNT   DW      0
DRIVE     DB      ?
FAT_BITS  DB      12
FIRST     DW      0
LAST      DW      0
LASTCLST  DW      ?

BEGIN:    MOV     AX,OFFSET SIGNON              ; Output Sign-On Message
          CALL    MSG_OUT
          MOV     AL,FCB[0]                     ; Read Specified Drive Number
          DEC     AL
          JNS     USE_DEF
          MOV     AH,19H
          INT     21H
USE_DEF:  MOV     DRIVE,AL                      ;   and Save
          ADD     AL,'A'                        ; Set Drive Letter
          MOV     HDR_MSG[6],AL
          MOV     ERR_DRV[20],AL
          MOV     AX,OFFSET HDR_MSG             ; Output Header Message
          CALL    MSG_OUT
          MOV     AL,DRIVE                      ; Read Boot Record
          MOV     CX,1
          MOV     DX,0
          MOV     BX,OFFSET FATBUF
          INT     25H
          POPF
          MOV     BX,FATBUF[22]                 ; Read Sectors per FAT
          PUSH    BX
          MOV     AH,36H                        ; Get Disk Info
          MOV     DL,DRIVE
          INC     DL
          INT     21H
          POP     CX
          CMP     AX,-1
          JNE     DRV_OK
          MOV     AX,OFFSET ERR_DRV             ; Output Drive Error Message
          CALL    MSG_OUT
          MOV     AX,4C01H                      ; Exit to DOS
          INT     21H
DRV_OK:   MOV     LASTCLST,DX                   ; Save Total Clusters
          INC     LASTCLST
          CMP     DX,4079                       ; If Necessary, Adjust FAT Size
          JLE     FAT_OK
          MOV     FAT_BITS,16
          MOV     BAD_CLST,0FFF7H
FAT_OK:   MOV     AL,DRIVE                      ; Read FAT
          MOV     BX,OFFSET FATBUF
          MOV     DX,1
          INT     25H
          POPF
          MOV     DX,2                          ; Check Clusters from #2
GET_NEXT: MOV     BX,DX                         ; Get Next Cluster Number
          CALL    NEXTCLST
          CMP     BX,BAD_CLST                   ; If Bad,
          JNE     NOT_BAD
          MOV     AX,OFFSET AND_STR
          CMP     BAD_CNT,0                     ;   If First Bad Cluster,
          JNE     NOTFIRST                      ;     Setup Bad Cluster Message
          MOV     AX,OFFSET BAD_MSG             ;   Else Setup AND_STR
NOTFIRST: CMP     FIRST,0                       ;   If First in Range,
          JNE     NO_STR
          CALL    MSG_OUT                       ;     Output Message
NO_STR:   INC     BAD_CNT                       ;   Increment Bad Cluster Count
          MOV     LAST,DX                       ;   Range Last = Current
          CMP     FIRST,0                       ;   If First,
          JNE     CHK_NEXT
          MOV     FIRST,DX                      ;     Range First = Current
          MOV     AX,DX                         ;     Output Cluster Number
          CALL    OUT_CLST
          JMP     SHORT CHK_NEXT
NOT_BAD:  MOV     AX,LAST                       ; Else If Range,
          OR      AX,AX
          JZ      NO_RANGE
          CMP     AX,FIRST                      ;     If First != Last
          JE      NO_RANGE
          MOV     AX,OFFSET TO_STR              ;       Output TO_STR
          CALL    MSG_OUT
          MOV     AX,LAST                       ;       Output Last Cluster #
          CALL    OUT_CLST
NO_RANGE: MOV     FIRST,0                       ;   Clear Range
          MOV     LAST,0
CHK_NEXT: INC     DX                            ; Try Next Cluster Number
          CMP     DX,LASTCLST                   ; Repeat until End of Disk
          JBE     GET_NEXT
          CMP     BAD_CNT,0                     ; If no Bad Clusters,
          JNE     CNT_BAD
          MOV     AX,OFFSET NBAD_MSG            ;   Output No Bad Message
          CALL    MSG_OUT
          JMP     SHORT DONE
CNT_BAD:  MOV     AX,OFFSET TOT_MSG
          CALL    MSG_OUT
          MOV     AX,BAD_CNT
          CALL    OUT_CLST
DONE:     MOV     AX,OFFSET CRLF                ; Output CRLF
          CALL    MSG_OUT
          MOV     AX,4C00H                      ; Exit to DOS
          INT     21H

MSG_OUT:  PUSH    DX                            ; Save Register
          MOV     DX,AX                         ; Print String to Video
          MOV     AH,9
          INT     21H
          POP     DX                            ; Restore Register
          RET                                   ; Done

NEXTCLST: CMP     FAT_BITS,12                   ; If FAT Size = 16 Bits,
          JE      NEXTCLS1
          SHL     BX,1                          ;   Simply Read Next Cluster #
          MOV     BX,FATBUF[BX]
          RET                                   ;   Done
NEXTCLS1: PUSH    AX                            ; Save Registers
          PUSH    CX
          MOV     AX,BX                         ; Word # = Cluster # * 1.5
          SHL     AX,1
          ADD     BX,AX
          SHR     BX,1
          MOV     BX,FATBUF[BX]
          JNC     NEXTCLS2                      ; If Odd, Use 12 MSB's
          MOV     CL,4
          SHR     BX,CL
NEXTCLS2: AND     BX,0FFFH                      ; Else Use 12 LSB's
          POP     CX                            ; Restore Registers
          POP     AX
          RET                                   ; Done

OUT_CLST: PUSH    AX                            ; Save Registers
          PUSH    DI
          MOV     DI,OFFSET CLSTSTR[5]          ; Convert Cluster # to Decimal
          CALL    DEC5OUT
          CALL    STRIP0                        ; Strip Off Leading Zeroes
          MOV     AX,OFFSET CLSTSTR
          CALL    MSG_OUT
          POP     DI                            ; Restore Registers
          POP     AX
          RET                                   ; Done

STRIP0:   CMP     BYTE PTR [DI],'0'             ; If Character != '0', Done
          JNE     STRIP1
          CMP     BYTE PTR [DI+1],'0'           ; If Next Character != Digit,
          JL      STRIP1                        ;   Done
          CMP     BYTE PTR [DI+1],'9'
          JG      STRIP1
          MOV     BYTE PTR [DI],' '             ; Change '0' to ' '
          INC     DI                            ; Point to Next Character
          JMP     SHORT STRIP0                  ; Repeat
STRIP1:   RET                                   ; Done

DEC2OUT:  PUSH    AX                            ; Save Registers
          PUSH    BX
          XOR     AH,AH                         ; Clear AH
          MOV     BL,10                         ; AH=AX%10,AL=AX/10
          DIV     BL
          ADD     AX,'00'                       ; Convert to ASCII
          SUB     DI,2
          MOV     [DI],AX                       ; Store in String
          POP     BX                            ; Restore Registers
          POP     AX
          RET                                   ; Done

DEC4OUT:  PUSH    AX                            ; Save Registers
          PUSH    BX
          MOV     BL,100                        ; AH=AX%100,AL=AX/100
          DIV     BL
          XCHG    AH,AL                         ; Convert 2 LSD's
          CALL    DEC2OUT
          XCHG    AH,AL                         ; Convert 2 MSD's
          CALL    DEC2OUT
          POP     BX                            ; Restore Registers
          POP     AX
          RET                                   ; Done

DEC5OUT:  PUSH    AX                            ; Save Registers
          PUSH    BX
          PUSH    DX                            ; DX=AX%10000,AX=AX/10000
          MOV     BX,10000
          XOR     DX,DX
          DIV     BX
          XCHG    DX,AX                         ; Convert 4 LSD's
          CALL    DEC4OUT
          XCHG    DX,AX                         ; Convert MSD
          ADD     AL,'0'
          SUB     DI,1
          MOV     [DI],AL
          POP     DX                            ; Restore Registers
          POP     BX
          POP     AX
          RET                                   ; Done

FATBUF    LABEL   WORD

CODE      ENDS

          END     LISTBAD
