/*$mmod l */
/*$objs crcrt */
/*$llib chain2 */

/*=========================================================================

   CRC_HD4    by Rip Toren, Columbia MD 21045

   This computes a 32-bit crc for each file under the specified directory.
   Subdirectories are recursively traversed.
   If a file name from a prior run is given, use that as a database
   to locate files that are missing, have changed, or are new.

=========================================================================*/
#include <stdio.h>
#include <malloc.h>
#include <dos.h>
#include <direct.h>
#include <chain2.h>
#include <time.h>
#include <sys\types.h>
#include <sys\stat.h>


struct   find_t  f_data;
char     cur_path[256], *append_pt;
char     root_path[80];
char     *invoke_dir, *chain_member;
unsigned attrs = 0x3f;
void     *subdir_anchor = NULL;
unsigned long total_char = 0;
long     file_cnt = 0;
clock_t  start, finish, elapsed;
float    bytes_per_sec, elapsed_sec;

int      do_compare = 0;
int      f_count = 0;
unsigned long *fs_crc, *fn_crc;
unsigned long *match_pt;


int    crc32file (char * filename, unsigned long * crc, long * char_cnt);

#define ID "CRC_HD4"
/*ͻ
                                                                              
*/
main ( int argc, char **argv )
  {
   int i;
   struct  stat  p_stat;

   // save where we started
   invoke_dir = getcwd(NULL,128);
   if (invoke_dir == NULL)  {
       perror("Invoking directory");
       exit (-1);
       }

   //  Default root path = drive i.e. "D:\"

   strncpy (root_path,invoke_dir,3);

   root_path[3] = 0x00;

   if ( argc == 2 )  {

       // argv[1] is the name of the database listing or a directory

       strupr (argv[1]);

       // does it have a trailing \ ?
       // if so, remove it.

       i = strlen( argv[1] ) -1;
       if (argv[1][i]== '\\') argv[1][i] = 0x00;

       if (stat (argv[1],&p_stat) == -1)  {
           // error in 'stat'ing the file
           fprintf (stderr,"Error in %s\n",argv[1]);
           perror (argv[1]);
           exit (-1);
           }
       if (p_stat.st_mode & S_IFDIR == S_IFDIR)  {

           // this is a directory -- so start here

           strcpy (root_path , argv[1]);
           }
       else  {

           // this is a file -- so do a comparison

           load_list (argv[1]);
           do_compare = 1;
           }
       }
   //
   //  start out where ever root path set up
   //

   chain_member = push_chain ( &subdir_anchor, strlen(root_path)+1);
   if (chain_member == NULL)  {
       printf ("Memory allocation error at root.\n");
       exit (-1);
       }
   strcpy (chain_member,root_path);
   if ( !do_compare) printf ("%s %s\n",ID,chain_member);

   //  record the start time
   start = clock ();

   //  Look at the next sub_directory

   chain_member = pop_chain ( subdir_anchor );
   while (chain_member != NULL)  {
       strcpy (cur_path,chain_member);
       append_pt = cur_path + strlen (cur_path);
       if ( *(append_pt-1) != '\\')
           strcpy (append_pt,"\\");
       parse_dir (cur_path, chain_member);
       free (chain_member);
       chain_member = pop_chain ( subdir_anchor );
       }
   finish = clock();
   elapsed = finish - start;
   elapsed_sec = (float)elapsed / (float) CLK_TCK;
   bytes_per_sec = (float) total_char / elapsed_sec;
   printf ("\nelapsed time is %7.3f seconds for %8.4f bytes/second\n@@%ld files",
       elapsed_sec, bytes_per_sec, file_cnt);

   }

/*ͻ
  parse directory                                                             
*/
parse_dir (char *sub_dir, char *chain_member)
  {
   unsigned long int crc, s_crc;
   long        char_cnt;
   int         rc, hit,i;
   char        *append_pt, *cp;



   //fprintf (stderr,"working <%s>\n",sub_dir);
   append_pt = sub_dir + strlen (sub_dir);
   strcpy (append_pt,"*.*");

   // hold top of chain

   cp = push_chain ( &subdir_anchor, 3);

   rc = _dos_findfirst ( sub_dir, attrs, &f_data );
   while ( rc == 0 )  {
       if (f_data.attrib & (_A_VOLID | _A_SUBDIR)) {
           //
           //  Push new directories under this one on the top of
           //  the stack (chain) of directories
           //
           if ((f_data.attrib & _A_SUBDIR) && (f_data.name[0] != '.'))  {
               // push this on the stack
               strcpy (append_pt,f_data.name);
               cp = insert_chain (AFTER, cp, strlen(sub_dir)+4);
               strcpy (cp, sub_dir);
               }
           rc = _dos_findnext ( &f_data );
           continue;
           }

       strcpy (append_pt,f_data.name);
       crc32file (sub_dir, &crc, &char_cnt);
       total_char += char_cnt;
       crc32str  (sub_dir, &s_crc, &char_cnt);
       s_crc ++;

       if ( do_compare )  {
           for (hit=0,match_pt = fn_crc, i=0; i< f_count; i++)  {
               if (*match_pt == s_crc)  {
                   if (*(fs_crc+i) == crc)  {
                       hit = 1;
                       break;
                       }
                   }
               match_pt++;
               }
           if ( !hit )  {
               printf (" !! No match -- %s\n",
                           sub_dir);
               }
           }
       else  {
           printf ("%8lX %8lX %s\n",  s_crc, crc, sub_dir);
           }
       file_cnt ++;
       rc = _dos_findnext ( &f_data );
       }
   // remove top of chain marker
   cp = pop_chain (subdir_anchor);
   free (cp);
   }

/*ͻ
                                                                              
*/

load_list ( char * filename )
  {
   FILE * list;
   struct stat f_stat;
   char   rec[80],base_name[80];
   int    i;
   unsigned long *fn_v, *fs_v;

   if ((list = fopen (filename,"rt"))== NULL)  {
       fprintf (stderr,"database file <%s> open error\n",filename);
       perror (filename);
       exit (-1);
       }
   fscanf (list,"%s %s \n",rec,base_name);
   if ( strcmp (rec,ID) != 0 )  {
       fprintf (stderr,"Database file <%s> is not valid\n",filename);
       exit (-1);
       }
   strcpy (root_path, base_name);
   fprintf (stderr,"Cheching %s\n",root_path);

   fstat (fileno(list), &f_stat);
   fseek (list, -16l, SEEK_END);
   fread (rec, 1, 16, list);
   for ( i=0; i<16; i++)  {
       if ((rec[i] == '@') && (rec[i+1] == '@'))  {
           f_count = atoi (&rec[i+2]);
           break;
           }
       }
   if ( f_count > 0 )  {
       fprintf (stderr, "\n%d files in list\n",f_count);
       fs_crc = (unsigned long *)calloc (f_count,sizeof(long));
       fn_crc = (unsigned long *)calloc (f_count,sizeof(long));
       if ((fn_crc == NULL) || (fs_crc == NULL))  {
           fprintf (stderr,"Not enough memory to hold database\n");
           exit (-1);
           }
       //printf ("fn_crc = %Fp  fs_crc = %Fp\n",fn_crc,fs_crc);
       fseek ( list, 0L, SEEK_SET);
       fgets (rec,80,list);        // flush that first ID line
       fn_v = fn_crc;
       fs_v = fs_crc;
       i = 0;
       while ( fscanf(list,"%lX %lX %s\n", fn_v, fs_v, rec) != EOF)  {
           i++;
           if ( i == f_count ) break;
           fn_v++;
           fs_v++;
           }
       fclose (list);
       fprintf (stderr,"%d records read\n",i);
       }
   }
