/*
      This program uses modem4/7/yam protocal for file transfers.  To receive a
file type '<esc>', you will be prompted for the file name. (<esc> is
the ascii escape character: ^[).

      To compile define either pmmi or modem (pmmi is presently defined).  Add
whatever code necessary to the initialize_port() function (setup your port for
8 bits, 1 stop bit, baud rate of 300 if necessary, etc.).  If using a serial
modem you will have to make changes of port addresses and masks in the #ifdef
modem area.  Note that the base address for the pmmi board is not the standard,
change USTAT to 0xc0 if you use the standard base.  There is a define CLKMHZ 4
that would need to be changed to 2 for 2 megahertz systems.

	This program uses large chunks of the yam package for file transfers, 
thanks Chuck.

*/

#include "bdscio.h"

#define SOH 0x01
#define EOT 0x04
#define ACK 0x06
#define NAK 0x15
#define CAN 0x18
#define RETRYMAX 10
#define TIMEOUT (-1)
#define PATHLEN 20
#define WCEOT (-2)
#define CLKMHZ 4
#define PMMI

#ifdef PMMI
#define USTAT 0x80		/* 0xc0 for standard pmmi boards */
#define UDATA USTAT + 1
#define MSTAT USTAT + 2
#define IMLOAD USTAT + 3
#define UCNTRL USTAT
#define T_RATE USTAT + 2
#define MCNTRL USTAT + 3
#define MIMASK 2
#define MOMASK 1
#define NORMAL 0x1c
#define ORIG 0x01
#define ANSWER 0x02
#define READY 0x5f
#define OPT300 0x20
#define OPT600 0X00
#define CLEAR 0x3f
#endif

#ifdef MODEM
#define UDATA 2
#define USTAT 3
#define MIMASK 2
#define MOMASK 1
#endif

#define CONSTAT 2
#define CONIN 3
#define DIR_IO 0x06
#define INPUT 0xff
#define FLAG char

int Baud;
FLAG Rfile;
char Rname[PATHLEN];
unsigned T1pause, Timeout;
char File_buf[BUFSIZ];
char Checksum, Lastrx;
int Wcj, Firstch;

main()
{
	char received, to_send, in_modem(), getch(), escflag;
	Tfile = Rfile = NO;
	T1pause = 311*CLKMHZ;
	escflag = NULL;
	Baud = 300;
	initialize_port();
	printf("\n\tbootmodem in the style of w.c.\n\n");
	while (TRUE) {
		if (received = in_modem()) putch(received);
		else if (to_send = getch())
			(to_send == ESC) ? download():out_modem(to_send);
	}
}
char
in_modem()
{
	if (inp(USTAT) & MIMASK) return inp(UDATA);
	else return FALSE;
}
out_modem(out_char)
char out_char;
{
	while (!(inp(USTAT) & MOMASK))	;
	outp(UDATA, out_char);
}
char
getch()
{
	return bdos(DIR_IO, INPUT);
}

/*

	Most of the following functions taken from yam package by
Chuck Forsberg, cug disk Utilities III, some modifications made for
compatibility with cnode code.

*/

download(filename)
char *filename;
{
	printf("\n\n\treceive: ");
	scanf("%s", Rname);
	printf("ready to receive '%s'\n", Rname);
	if(wcrx(Rname)==ERROR) {
		abort('r');
	}
	return OK;
}

/* Adapted from CMODEM13.C, by Jack M. Wierda and Roderick W. Hart */
wcrx(name)
char *name;
{
	int sectnum, sectcurr, sectcomp;
	char *cp, rxbuf[128], sendchar;
	if(openrx(name)==ERROR)
		return ERROR;
	sectnum=0;
	sendchar=NAK;
	for(;;) {
		out_modem(sendchar);
		sectcurr=wcgetsec(rxbuf, (sectnum & 0x7f) ? 50 : 130);
		if(sectcurr==(sectnum+1 & 0xff)) {
			sectnum++;
			for(cp=rxbuf,Wcj=128; --Wcj>=0; )
				if(putc(*cp++, File_buf)==ERROR) {
					printf("\nDisk Full\n");
					return ERROR;
				}
			sendchar=ACK;
		}
		else if(sectcurr==sectnum) {
			printf("\nReceived dup Sector %d",sectcurr);
			sendchar=ACK;
		}
		else if(sectcurr==WCEOT) {
			out_modem(ACK);
			closerx(FALSE);
			return OK;
		}
		else {
			printf(" Sync Error\n");
			return ERROR;
		}
	}
}
wcgetsec(rxbuf, time)
char *rxbuf;
int time;
{
	int sectcurr,errors;
	char *cp;

	for(Lastrx=errors=0; errors<RETRYMAX; errors++) {
		do {
			Firstch=readbyt(time);
		}
		while(Firstch != SOH && Firstch != TIMEOUT && Firstch != EOT
			  && Firstch != CAN);	/* wait for one of these */
		if(Firstch==SOH) {
			sectcurr=readbyt(1);
			if((sectcurr+readbyt(1))==255) {
				Checksum=0;
				for(cp=rxbuf,Wcj=128; --Wcj>=0; ) {
					isprint(*cp = readbyt(1)) ? putchar(*cp) : putchar('.');
					Checksum += (*cp++);
				}
				if(((Checksum-readbyt(1))& 0xff)==0)
					return sectcurr;
				else
					printf("Checksum Error #%d", errors);
			}
			else
				printf("Sector number garbled #%d", errors);
		}
		else if(Firstch==EOT)
			return WCEOT;
		else if(Firstch==CAN) {
			if(Lastrx==CAN) {
				printf("\nSender CANcelled");
				return ERROR;
			} else {
				Lastrx=CAN;
				continue;
			}
		}
		else if(Firstch==TIMEOUT)
			printf("\nSOH Timeout #%d", errors);
		Lastrx=0;
		while(readbyt(1)!=TIMEOUT)
			;
		out_modem(NAK);
		time=40;
	}
	out_modem(CAN);out_modem(CAN);out_modem(CAN);
	return ERROR;
}
openrx(name)
char *name;
{
	printf("\nsaving it as '%s'", name);
	if(fopen(name, File_buf) != ERROR) {
		fclose(File_buf);
		printf("\nI already have one, try another name");
		return ERROR;
	}
	if(fcreat(name, File_buf)==ERROR){
		printf("\nCan't create '%s'", name);
		return ERROR;
	}
	Rfile= TRUE;
	return OK;
}
readbyt(decisecs)
int decisecs;
{
	if (inp(USTAT) & MIMASK)
		return inp(UDATA);
	while (--decisecs >= 0) {
		if (inp(USTAT) & MIMASK)
			return inp(UDATA);
		if (bdos(DIR_IO, INPUT))
			return TIMEOUT;
		if (inp(USTAT) & MIMASK)
			return inp(UDATA);
		for (Timeout = T1pause; --Timeout; )
			if (inp(USTAT) & MIMASK)
				return inp(UDATA);
	}
	return TIMEOUT;
}
abort(flag)
char flag;
{
	flag == 't' ? closetx() : closerx();
	out_modem(CAN);out_modem(CAN);out_modem(CAN);
	return ERROR;
}
closerx()
{
	if(Rfile) {
		fflush(File_buf);
		fclose(File_buf);
		printf("\n\n%s closed", Rname);
		Rfile=FALSE;
	}
}
purgeline()
{
	while (inp(USTAT) & MIMASK)
		inp(UDATA);
}

/* end of code from yam */

initialize_port()
{
#ifdef PMMI
	outp(UDATA, NULL);
	outp(T_RATE, 0x10);
	inp(IMLOAD);			/* enable the hook relay */
	outp(T_RATE, 15625/Baud);
	outp(MCNTRL, READY | OPT300);
	sleep(2);
	outp(UCNTRL, NORMAL | ORIG);
	sleep(2);
	outp(UCNTRL, NORMAL);
#endif
#ifdef MODEM
#endif
}
isprint(c)
char c;
{
  return (c >= ' ' && c <= '~') || (c == 0x0d) || (c == 0x0a) || (c==0x09);
}
