/* a program to create/alter callfiles for the cboard software */

/* begincode */

/* includes */

#include "a:std.h"		/* bdscio + my stuff */
#include "b:cnode.h"		/* things for the cnode package */

/* defines */

/* structs */

/* globals */

struct _file call;
struct _call_data call_data;
string call_name[20];
unsigned next_call, base_call, call_num;

/* beginmain */

main()
{
	_allocp = NULL;
	call._blksiz = sizeof(call_data);		/* for bseek */

	int fake;
	char c;

	printf("\f\n\tCallfile maintainance program:\n\n");
	strcpy(call_name, "b:callfile.dat");	/* default file */
name:	printf("\nOk to work with %s? ", call_name);
	if (tolower(getchar()) == 'n') {
		printf("\n\t\tSpecify file name: ");
		scanf("%s", call_name);
	}
/* open call_data file for random access */
	if (ropen(call_name, &call, 'd', 1) == ERROR) {
		printf("\n\tCan't open %s", call_name);
		printf("\n\t\tShall I create %s? ", call_name);
		if (tolower(getchar()) == 'n') goto name;
		if (new_call() == ERROR) goto name;
	}
/* display next call and base call of this file */
	next_call = rgetw(&call);
	base_call = rgetw(&call);
call:
	printf("\n\tThe next call would be # %d,", next_call);
	printf("\n\t\tthe base call of this file is %d.", base_call);
/* ask for call */
	printf("\n\t\tWhich call# shall we work with? ");
	if (scanf("%d", &call_num) == 0) done();
	if (call_num < base_call) {
	  printf("\n\tCan't, base of this file is call# %u",base_call);
		goto call;
	}
	if (call_num > next_call)
		printf("\n\tWARNING:next call is %u",next_call);
/* block seek the relative call struct */
	if (bseek(&call, (call_num - base_call + 1), 0) == ERROR) {
		printf("\n\tCan't seek call %u.", call_num);
		goto call;			/* start fresh */
	}
/* read structure */
	if (rgetstruct(&call,&call_data,sizeof(call_data)) == ERROR) {
		printf("\n\tCan't read struct for call# %u", call_num);
		goto call;			/* start fresh */
	}
/* label fields */
    printf("\n\n%-9s%-13s","1.call #","2.caller id#");
    printf("%-7s%-7s%-9s","3.date","4.time","5.length");
    printf("%-14s%-11s","6.term. cause","7.file err");
    printf("%-8s","8.spare");

    while (TRUE) {		/* change loop */

/* display their values */
    printf("\n%8u%13u",call_data._call_number,call_data._caller_id);
    printf("%7u%7u",call_data._calldate,call_data._calltime);
    printf("%9u%14d",call_data._call_length,call_data._termination);
    printf("%11d%8d",call_data._file_err,call_data._call_2);
	printf("\n\nChange field # ");		/* ask for change */
	if ((c = getchar()) == '\n') break;	/* exit from loop */
	switch (c) {
	case '1':
		printf("  %u to ", call_data._call_number);
		scanf("%u", &call_data._call_number);
		break;
	case '2':
		printf("  %u to ", call_data._caller_id);
		scanf("%u", &call_data._caller_id);
		break;
	case '3':
		printf("  %u to ", call_data._calldate);
		scanf("%u", &call_data._calldate);
		break;
	case '4':
		printf("  %u to ", call_data._calltime);
		scanf("%u", &call_data._calltime);
		break;
	case '5':
		printf("  %u to ", call_data._call_length);
		scanf("%u", &call_data._call_length);
		break;
	case '6':
		printf("  %d to ", call_data._termination);
		scanf("%d", &fake);
		call_data._termination = fake;
		break;
	case '7':
		printf("  %d to ", call_data._file_err);
		scanf("%d", &fake);
		call_data._file_err = fake;
		break;
	case '8':
		printf("  %d to ", call_data._call_2);
		scanf("%d", &fake);
		call_data._call_2 = fake;
		break;
	default:
		printf("Can't do field # %c", c);
	}
    }
update:
	printf("\n\n\t(K)eep or (P)urge this call? ");
	switch (tolower(getchar())) {
	case 'k':
/* inc next_call if necessary */
		if (call_num >= next_call) {
			next_call = call_num + 1;
		}
		break;
	case 'p':
		call_data._call_number = 0;		/* nullify rec */
		break;
	default:
		printf("\n\n\tHuh?");
		goto update;
	}
/* write struct to disk */
	if (bseek(&call, 0, 1) == ERROR) { /* reseek struct be4 read */
		printf("\n\tCan't reseek %u", call_num);
	}
	if (rputstruct(&call, &call_data, sizeof(call_data)) == ERROR) {
		printf("\n\tCan't update call# %u", call_num);
	}
	goto call;
}
/* endmain */

/* close files and return to opsystem */

done()
{
	fseek(&call, 0, 0, 0);			/* go to beginning */
	rputw(next_call, &call);		/* store next call # */
	if (rclose(&call) == ERROR) {
		printf("\n\t\tCan't close %s!", call_name);
	}
	exit();					/* return to opsys */
}

/* create and initialize a new callfile, erasing any old copies */

new_call()
{
/* create the file */
	if (rcreat(call_name, &call, 'd', 2) == ERROR) {
		printf("\n\tCan't create %s", call_name);
		return ERROR;
	}
/* add the 'next_call' & 'base_call' value at record 0, 1 */
	printf("\n\tWhat is the first call# of this file? ");
	scanf("%d", &base_call);
	next_call = base_call;
	rputw(next_call, &call);		/* store next call # */
	rputw(base_call, &call);		/* store next call # */
	fseek(&call, 0, 0, 0);			/* back to beginning */
	return TRUE;
}

/* endcode */
