/********************************************************************
	cnmain.c - the main() function for the cnode package
*/

#include "a:std.h"
#include "b:cnode.h"		/* for the package */
#include "b:cnode.g"		/* globals for cnode */

/* beginmain */

main()
{
	_allocp = NULL;		/* initialize alloc() */
	inits();		/* set up initial values */
	answer_phone();		/* manipulate pmmi board */
	start_call();		/* open call file, etc */
	sys_welcome();		/* brief intro */
	login();		/* check them out */
	sys_bulletin();		/* 'message of the day' */
	commands();		/* process commands */
	logout();		/* close shop */
	hangup(NORM_END);	/* update files, etc. */
}
/* endmain */

/* set up initial values */

inits()
{
	File_error = FALSE;
	Tfile = Rfile = Call_open = Log_open = Opmbx_open = NO;
	T1pause = 311*CLKMHZ;
	Abort = NO;
	Cterm._vrows = 25;	/* local term specs */
	Cterm._vcolms = 80;
	Cterm._vnulls = 0;
	Cterm._vtab_size = 4;
	Cterm._vbell = 0x07;
	Cterm._vmore = FALSE;	/* let remote call it */
	Cterm._vrow_p = 0;
	Cterm._vcolm_b = Cterm._vcolm_p = 0;
	Mterm._vrows = 16;	/* (default) remote term specs */
	Mterm._vcolms = 64;
	Mterm._vnulls = 5;
	Mterm._vtab_size = 8;
	Mterm._vbell = 0x07;
	Mterm._vmore = TRUE;
	Mterm._vrow_p = 0;
	Mterm._vcolm_b = Mterm._vcolm_p = 0;
	More = FALSE;
	Version = VERSION + UPDATE;
}

/* setup modem, answer the phone, send carrier, ack carrier,
	 enable modem hangup, etc. */

answer_phone()
{
	outp(INT_MASK, OFFHOOK);	/* connect the coupler 'hook' */
	inp(LOAD_INT_MASK);
	outp(TIMER_RATE, 300_B);	/* default 300 baud */
	outp(DATA_OUT, NULL);		/* clear modem */
	outp(MODEM_CONTROL, READY);	/* DTR on */
	sleep(2);			/* let it work */
	vprintf(CON, "\nDTR ready...");	/* show it to be true */
	vprintf(CON, "\n\tanswering the phone...");
	outp(UART_CONTROL, NORMAL | ANSWER);	/* answer the phone */
	sleep(2);			/* allow ans to work */
	outp(UART_CONTROL, NORMAL);	/* enable hangup */
	if (!still_there()) {
		vprintf(CON, "\n\t\tno connection made!");
		hangup(NO_CONTACT);	/* 15 secs */
	}
	vprintf(CON, "\n\t\tgot a carrier, setting baud rate.");
	set_baud();		/* set baudrate */
}

/* return true if carrier present, wait for hangup or carrier
	before returning */

still_there()
{
	char status;

    while (TRUE) {		/* loop */
		status = inp(MODEM_STATUS);	/* connect and carrier bits */
		if (status & NOT_CONNECTED) return FALSE;   /* modem hungup */
		if (status & NO_CARRIER) continue;	/* keep trying */
		else return TRUE;
    }
}

/* determine the baud rate of calling computer, first version fake */

set_baud()
{
	vgetchar(C_M);
	vgetchar(C_M);
	outp(TIMER_RATE, 300_B);		/* baud rate is 300 */
}

/* open callfile and setup */

start_call()
{
	unsigned next_call, base_call;

/* open callfile */
	if ((Call = ropen("a:callfile.dat", 'd', 1)) == ERROR) {
		File_error = CALL_OPEN;
		return ERROR;
	}
	Call_open = TRUE;
	Call->_blksiz = sizeof(Call_data);
	next_call = rgetw(Call);	/* this call's # */
	base_call = rgetw(Call);	/* first call, this file */
	bseek(Call, 0, 0);		/* point at next_call */
	rputw((next_call + 1), Call);		/* update it */
/* seek block for next call */
	if (bseek(Call, (next_call - base_call + 1), 0) == ERROR) {
		rclose(Call);			/* give up */
		Call_open = NO;
		File_error = CALL_SEEK;
		return ERROR;
	}
/* init call#, set date;time;length to 0 */
	Call_data._call_number = next_call;
	Call_data._caller_id = 0;
	Call_data._calldate = Call_data._calltime =
					Call_data._call_length = 0;
	Call_data._termination = Call_data._file_err =
					Call_data._call_2 = 0;
	return OK;
}


/** check the files for user, set tty, log him/her in */

login()
{
	char login_trys;	login_trys = 0;
/* open for direct access with 1 sector buffered */
	if ((Log = ropen("a:logfile.dat", 'd', 1)) == ERROR) { /* open */
		File_error = LOG_OPEN;		/* make a note */
		return guest();			/* gotta fake it */
	}
	Log_open = YES;
	Log->_blksiz = sizeof(Log_data);
start:
	++login_trys;
	if (login_trys == LOG_LIMIT)
		vprintf(C_M, "\n\tOne more chance, you might try just <cr>");
	else if (login_trys > LOG_LIMIT) {
		vprintf(C_M, "\n\tSorry, that's the limit");
		close_log();		/* close logfile.dat */
		hangup(LOG_FAILURE);
	}
	vprintf(C_M, "\n\nLogin: ");			/* prompt */
	if (vscanf(C_M, "%s", Reply) == 0) {	/* blank line means 'guest' */
		strcpy(First_name, "guest");		/* default name */
		Id_num = GUEST_ID;		/* default id # */
	}		/* otherwise cleanup and place in First_name */
	else {
		purge_ws(Reply);		/* remove white space */
		purge_uc(Reply);		/* make all lowercase */
		if ((strcmp(Reply,"help") IS_SAME) || Reply[0] == '?') {
			send_text("a:login.hlp", YES);
			goto start;
		}
		strcpy(First_name, Reply);	/* valid name */
		vprintf(C_M, "\nPassword: ");
		vscanf(C_M, "%d", &Id_num);	/* get id # */
		if (Id_num < GUEST_ID || Id_num > MAX_ID) {
			vprintf(C_M, "\n\tIllegal password, try again.");
			goto start;
		}
	}
		/* check First_name and id# against logfile entries */
	if (bseek(Log, (Id_num - 1000), 0) == ERROR) {
		close_log();		/* close logfile.dat */
		File_error = LOG_SEEK;	/* make a note */
		return guest();		/* gotta fake it */
	}
	else if (rgetstruct(Log,&Log_data,sizeof(Log_data)) == ERROR){
		close_log();		/* close logfile.dat */
		File_error = LOG_GSTRUCT;/* make a note */
		return guest();		/* gotta fake it */
	}
	else if (Id_num != Log_data._id_number) {
		close_log();		/* close logfile.dat */
		File_error = LOG_SYNC;	/* make a note */
		return guest();		/* gotta fake it */
	}
/* compare _first_name from logfile to declared First_name */
	if (strcmp(First_name, Log_data._first_name) IS_DIFFERENT) {
		vprintf(C_M, "\n\tRecords show different name");
		goto start;
	}
/** if valid: stty, get/update call#, update _last_call */
	++Log_data._total_calls;
	Call_data._caller_id = Log_data._id_number;
	Mterm._vbell = 	Log_data._bell;	/* store bell flag */
	if (bseek(Log, 0, 1) != ERROR) {/* reset ptr & update */
		rputstruct(Log, &Log_data, sizeof(Log_data));
	}
	close_log();			/* close logfile.dat */
	return OK;
}

/* close the log file properly */

close_log()
{
	if (Log_open) {
		Log_open = NO;
		return rclose(Log);
	}
	return ERROR;
}

/** default to 'guest' status on error of some sort, return ERROR */

guest()
{
	vprintf(C_M, "\n\tCan't open the logfile, you will be");
	vprintf(C_M, "\n\t\tlimited to guest status, sorry.");
	Call_data._caller_id = Log_data._id_number = 1001;
	Log_data._group = Log_data._privileges = 1;
	Mterm._vcolms = 64;
	Mterm._vrows = 16;
	Mterm._vbell = Log_data._bell = 0x07;
	strcpy(Log_data._first_name, "guest");
	return ERROR;
}

/* print a 'sign-on' message */

sys_welcome()
{
	send_text("b:welcome", YES);
}

/* print a 'message of the day' */

sys_bulletin()
{
	send_text("b:motd", YES);
}


/* leave messages for sysop, ask q's, and whatever */

logout()
{
	int result;
top:
	vprintf(C_M, "\n\tWould you like to leave any comments");
	vprintf(C_M, " for the sysop? (Y or <anykey>) "); /* feedback */
	switch (tolower(vgetchar(C_M))) {
	case '?':
		send_text("a:logout.hlp", YES);
		goto top;
	case 'y':
		result = sysop_box();
		break;
	default:
		result = OK;
	}
	vprintf(C_M, "\n\n\57\52\n\tc you later, %s.", First_name);
	sleep(100);				/* kill 5 seconds */
	return result;
}

/* place a letter in the sysop's mailbox */

sysop_box()
{
	int more;
	unsigned more_left;

	if ((Op_mbx = ropen("a:sysop.mbx", 'd', 2)) == ERROR) {
	    vprintf(C_M, "\n\tCan't, problems with sysop's mailbox, sorry.");
	    File_error = OPMBX_OPEN;	/* make a note */
	    return ERROR;
	}
	more = More;
	More = NO;
	Opmbx_open = YES;
	rgetstruct(Op_mbx, &Mbxptr, sizeof(Mbxptr));
	if (fseek(Op_mbx, Mbxptr._sector, Mbxptr._byt, 0) == ERROR) {
		vprintf(C_M, "\n\tCan't, box is full.");	/* hopefully */
		close_opmbx();
		File_error = OPMBX_SEEK;
		return ERROR;
	}
/* record call# and caller id# */
	rputw(Call_data._call_number, Op_mbx);
	rputw(Call_data._caller_id, Op_mbx);
/* prompt for message */
    vprintf(C_M, "\n\n\tready for input, enter a ^z to end message -\n\n");
/* get lines of text into box till ^z */
	do { more_left = vgets(Reply, MAXLINE - 2, C_M);/* get lines till ^z */
		strcat(Reply, "\n");	/* add cr/lf */
		rputl(Reply, Op_mbx);	/* put each in sysop mailbox */
	}	while (more_left);
	More = more;
	return close_opmbx();
}

/* close the sysop's box */

close_opmbx()
{
	if (Opmbx_open) {
		rputc(CNTL_Z, Op_mbx);	/* put ^z at end of letter */
/* call ftell() for _cursec, _curbyt, write to Mbxptr */
		Mbxptr._sector = ftell(Op_mbx);	/* get _cursec */
		Mbxptr._byt =  Op_mbx->_curbyt;		/* and _curbyt */
		fseek(Op_mbx, 0, 0, 0);		/* to beginning */
		rputstruct(Op_mbx, &Mbxptr, sizeof(Mbxptr));
/* close file and return OK */
		Opmbx_open = NO;
		return rclose(Op_mbx);			/* close it */
	}
	return ERROR;
}

/* hangup the phone, update and close files, shut down the system */

hangup(reason)
char reason;
{
	vprintf(CON, "\n\nhanging up...");
	outp(MODEM_CONTROL, CLEAR);	/* hangup phone (modem) */
	sleep(2);			/* let it work */
	if (Call_open) {
		vprintf(CON, "\n\tclosing call file...");
		close_call(reason); 
	}
	if (Log_open) {
		vprintf(CON, "\n\tclosing log file...");
		close_log();
	}
	if (Opmbx_open) {
		vprintf(CON, "\n\tclosing opmbx...");
		rputl(Reply, Op_mbx);
		close_opmbx();
	}
	closetx();			/* close open trans file */
	closerx();			/*  or receive file */

/*		flush the bios block/deblock buffer!!!
			(for godbout disk 1)	*/

	bios(HOME);			/* force the flush */

	vprintf(CON, "\n\t\tshutdown!");
	outp(MODEM_CONTROL, TURN_OFF);	/* turn off computer */
deadlock:
	vput('*', CON);
	goto deadlock;			/* loop till power off */
}

/* close the call file */

close_call(reason)
char reason;
{
	Call_data._termination = reason;/* place reason in callfile */
	Call_data._file_err = File_error;/* file error flag in callfile */
	rputstruct(Call, &Call_data, sizeof(Call_data));/* close it */
	Call_open = NO;
	return rclose(Call);
}

/*	for the dnld overlay command */

closetx()
{
	if(Tfile) {
		fclose(File_buf);
		vprintf(CON, "%s closed\n", Tname);
		Tfile=FALSE;
	}
}

/* for the upld overlay command */

closerx()
{
	if(Rfile) {
		fflush(File_buf);
		fclose(File_buf);
		Rfile=FALSE;
	}
}

/* explain purpose of command and possible actions */

help(argc, argv)
int argc;
char **argv;
{
	char pname[PATHLEN];
	if (argc != 2)	{
		return send_text("a:help.hlp", YES);
	}
	if (build_fn(pname, "a", argv[1], "hlp") == ERROR) return ERROR;
	return (send_text(pname, YES));
}

/* send a text file, (name pointed at by filename) */

send_text(filename, more_flag)
string *filename;
FLAG more_flag;
{
	int c, fd, more;
	char linebuf[MAXLINE];
	char x;

	Abort = NO;
	more = More;
	More = more_flag;

	if (fopen(filename, File_buf) == ERROR) {	/* open filename */
		vprintf(C_M,"\n\tsorry, file error on that one, check your spelling.");
		return ERROR;
	}
	Cterm._vrow_p = Mterm._vrow_p = 0;	/* fresh page */
	vprintf(C_M, "\n\n");
	while (fgets(linebuf, File_buf) AND !Abort) {
						/* get line from file... */
		vprintf(C_M, "%s", linebuf);	/* ...and send till done */
	}
	fclose(File_buf);			/* close file and return */
	Abort = NO;
	More = more;
	return OK;
}

/* endcode */
