/********************************************************************
	cnode.h - lots of #defines for the cnode package
*/

struct _vterm {
	char _vrows;
	char _vcolms;
	char _vnulls;
	char _vtab_size;
	char _vbell;
	char _vmore;
	char _vcolm_b;
	char _vcolm_p;
	char _vrow_p;
};

struct _log_data {
	unsigned _id_number;
	char _group;
	char _privileges;
	char _plen;		/* lines to a page */
	char _llen;		/* chars to a line */
	char _nulls;		/* nulls after '\r' */
	string _first_name[15];
	unsigned _total_calls;
	unsigned _last_call;
	char _bell;
	char _spare_2;
};

struct _call_data {
	unsigned _call_number;
	unsigned _caller_id;
	unsigned _calldate;
	unsigned _calltime;
	unsigned _call_length;
	char _termination;
	char _file_err;
	char _call_2;
};

/* 'help' function switch values */

#define AREA_COMMAND 0
#define AREA_LOGIN 1
#define AREA_UNLOG 2

/* hangup() reasons */

#define NORM_END 1		/* signoff by caller */
#define NO_CONTACT 2		/* no initial connection */
#define CONN_BROKEN 3		/* carrier lost by still_there() */
#define LOG_FAILURE 4		/* failure to login correctly */

/* file error types */

#define LOG_OPEN 1
#define LOG_CLOSE 2
#define LOG_SEEK 3
#define LOG_GSTRUCT 4
#define LOG_PSTRUCT 5
#define LOG_SYNC 10

#define CALL_OPEN 11
#define CALL_CLOSE 12
#define CALL_SEEK 13
#define CALL_GSTRUCT 14
#define CALL_PSTRUCT 15

#define OPMBX_OPEN 21
#define OPMBX_CLOSE 22
#define OPMBX_SEEK 23

/* misc. defines */

#define VERSION 100		/* changable only by cnode consensus */
#define UPDATE 01		/* changable by local cnode, range 1-99 */
#define TAB_SIZE 8		/* not pres. used, Tab_size does its job */
#define GUEST_ID 1001
#define MAX_ID 65000
#define LOG_LIMIT 5
#define P_ARGNUM 10		 /* number of args allowed in a command */
#define BELL 0x07
#define CNTL_Z 0x1a
#define CNTL_C 0x03
#define CNTL_U 0x15
#define CNTL_H 0x08
#define CNTL_X 0x18
#define CNTL_Q 0x11
#define CNTL_R 0x12
#define CNTL_S 0x13
#define CNTL_T 0x14

/* logical channels */

#define CON 5
#define MOD 6
#define C_M 7

/* pmmi ports */

#define DATA_IN 0x81
#define DATA_OUT 0x81

#define UART_STATUS 0x80
#define DATA_READY 0x02
#define BUFFER_EMPTY 0x01

#define MODEM_STATUS 0x82
#define NO_RING 0x02		/* neg. ring flag */
#define NOT_CONNECTED 0x10	/* neg. connect flag */
#define NO_CARRIER 0x04		/* CTS, neg. carrier flag */

#define TIMER_RATE 0x82
#define 300_B 0x34		/* divisor for 300 baud */
#define 600_B 0x1a		/* ...for 600 baud */
#define 110_B 0x8e		/* ...for 110 baud */

#define UART_CONTROL 0x80
#define NORMAL 0x1c		/* 8 bits, no parity */
#define ANSWER 0x02		/* answer the phone */
#define ORIGINATE 0x01		/* off hook, orig. tones */

#define MODEM_CONTROL 0x83
#define READY 0x7f		/* DTR, optimum for 0-300b */
#define CLEAR 0x3f		/* DTR off */
#define TURN_OFF 0xdf		/* turn off computer */
#define OFFHOOK 0x10		/* enable 'offhook' to coupler */

#define INT_MASK 0x82
#define LOAD_INT_MASK 0x83

/* bdos flags */

#define CON_STAT 0x0b
#define CON_IN 0x01
#define CON_OUT 0x02
#define DIR_IO 0x06
#define INPUT 0xff			/* for DIR_IO input */
#define RESET_DISK 0x0d		/* for 'cm' command */
#define SEL_DSK 0x0e
#define CUR_DSK 0x19
#define DISK_PARMS 0x1f
#define RESET_DRIVE 0x25	/* for hangup, to flush buf */

/* bios stuff */

#define CONST 2			/* bios console char ready */
#define CONIN 3			/* bios cons char input */
#define CONOUT 4		/* bios cons char output */
#define HOME 8			/* bios home function */
#define SELDSK 9
#define SETTRK 10
#define SETSEC 11
#define SETDMA 12
#define READ 13
#define SECTRAN 16

/* stuff for yam/modem code */

#define RESTRICTED

#define SOH 0x01
#define EOT 0x04
#define ACK 0x06
#define NAK 0x15
#define CAN 0x18

#define RETRYMAX 10
#define TIMEOUT (-1)
#define PATHLEN 20
#define WCEOT (-2)
#define CLKMHZ 4

/* stuff for the typesq package */
/* #include "sqcom.h" */
#define RECOGNIZE 0xFF76	/* unlikely pattern */
		/* *** Stuff for first translation module *** */
#define DLE 0x90
		/* *** Stuff for second translation module *** */
#define SPEOF 256	/* special endfile token */
#define NUMVALS 257	/* 256 data values plus SPEOF*/

/* #include "usq.h" */
#define LARGE 30000

struct _sqleaf {	/* Decoding tree */
	int _children[2];	/* left, right */
};
