	TITLE	'CONFIG - AUTOMATIC CONFIGURATOR FOR CP/M ON MICROPOLIS'
;	COPYRIGHT 1978,1979,1980 BY BRUCE R RATOFF
;	REVISED 12/12/79	(CP/M VERSION 2.0)
;		12/28/79	(BUG FIXED IN SOLOS CODE)
;		07/19/80	(ADDED CONFIG. H, BUG FIXED IN IOINIT)
;
	
FCB	EQU	5CH
;
	ORG	100H
;
START:	LXI	SP,$-1
	LDA	FCB	;TEST FOR CONFIGURATION NUMBER NON-ZERO
	ORA	A	;IF NO CONFIGURATION LETTER, HANG
	JZ	START
	LHLD	1	;GET ADDRESS OF CONSOLE STATUS VECTOR
	MVI	L,7
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	SHLD	IOBASE	;SAVE AS PATCH BASE ADDRESS
	LDA	FCB	;GET CONFIG AGAIN
	CPI	19	;CONTROL-S MEANS SOL
	JZ	SOLCON
	CPI	24	;CONTROL-X MEANS EXIDY SORCERER
	JZ	XIDCON
	CPI	26	;CONTROL-Z MEANS ZAPPLE
	JZ	ZAPCON
	CPI	9	;OTHERWISE, MUST BE BETWEEN 1 AND 8
	JNC	START
CONOK:	DCR	A	;INDEX INTO CONFIGURATION TABLE
	RLC
	MOV	E,A
	MVI	D,0
	LXI	H,CNTBL
	DAD	D
	MOV	E,M		;GET ADDRESS OF CONFIG. DATA INTO DE
	INX	H
	MOV	D,M
	LXI	H,GHTBL		;HL POINTS TO LIST OF PATCH OFFSETS
	MVI	C,GHSIZ-1	;MAKE THIS MANY PATCHES
STDLUP:	LDAX	D		;GET PATCH VALUE
	INX	D
	PUSH	D
	MOV	E,M	;GET PATCH ADDRESS
	INX	H
	MOV	D,M
	INX	H
	PUSH	H
	LHLD	IOBASE	;ADD PATCH BASE ADDRESS
	DAD	D
	MOV	M,A	;INSERT PATCH
	POP	H
	POP	D
	DCR	C
	JNZ	STDLUP	;DO IT SOME MORE
;
	MOV	C,M	;GET OFFSET TO IOINIT
	INX	H
	MOV	B,M
	LHLD	IOBASE	;ADD BASE ADDRESS
	DAD	B
	XCHG	;	SAVE IN DE
	MOV	C,M	;GET SIZE OF INITIALIZATION ROUTINE
	INX	H
MOVINI:	MOV	A,M	;COPY INITIALIZATION ROUTINE TO CP/M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	MOVINI
;
GOCPM:	LHLD	1		; GET BOOT ADDRESS
	MVI	L,0		; FORCE DOWN TO COLD BOOT
	PCHL			; GO START CP/M
;
SOLCON:	LXI	H,SOLTBL	; POINT TO LIST OF PATCHES FOR SOLOS
	LXI	D,CONFS		; POINT TO PATCH DATA
	MVI	C,SOLSIZ-1	; NUMBER OF PATCHES TO MAKE
	JMP	STDLUP		; GO DO PATCHING
;
ZAPCON:	LXI	H,ZAPTBL	; LIST OF ZAPPLE PATCHES
	LXI	D,CONFZ		; PATCH DATA
	MVI	C,ZAPSIZ-1	; NUMBER OF PATCHES
	JMP	STDLUP		; GO DO IT
;
XIDCON:	LXI	H,XIDTBL	; EXIDY PATCH ADDRESSES
	LXI	D,CONFX		; PATCH DATA
	MVI	C,XIDSIZ-1	; NUMBER OF PATCHES
	JMP	STDLUP		; GO MAKE PATCHES
;
MKTBL	MACRO	L,N	;;GENERATE <LABEL>&<NUMBER>
	DW	L&N
	ENDM
;
CNUM	SET	1	;;BUILD TABLE OF CONFIGURATIONS
CNTBL:	REPT	8
	MKTBL	CONF,%CNUM
CNUM	SET	CNUM+1
	ENDM
;
CONF1:	DB	16,1,1,17,16,2,2,17
	DB	9
	MVI	A,3
	OUT	16
	MVI	A,11H
	OUT	16
	RET
;
CONF2:	DB	3,2,2,2,3,1,1,2
	DB	17
	MVI	A,0AAH
	OUT	3
	MVI	A,40H
	OUT	3
	MVI	A,0CEH
	OUT	3
	MVI	A,27H
	OUT	3
	RET
;
CONF3:	DB	0,1,0,1,0,128,0,1
	DB	1
	RET
;
CONF4:	DB	0,32,32,1,0,2,2,1
	DB	1
	RET
;
CONF5:	DB	0,64,64,1,0,128,128,1
	DB	1
	RET
;
CONF6:	DB	67,2,2,66,67,1,1,66
	DB	4
	SUB	A
	OUT	67
	RET
;
CONF7:	DB	16,128,128,17,18,128,128,19
	DB	17
	SUB	A
	OUT	16
	OUT	17
	OUT	18
	CMA
	OUT	19
	MVI	A,24H
	OUT	16
	OUT	18
	RET
;
CONF8:	DB	128,64,64,129,128,128,128,129
	DB	12
	MVI	A,1
	OUT	130
	SUB	A
	OUT	131
	MVI	A,64
	OUT	128
	RET
;
;
;
; TABLE OF PATCH OFFSETS FOR PORT DRIVER CONFIGURATIONS
;
GHTBL:	DW	4,9,11,28,43,45,47,59,130
GHSIZ	EQU	($-GHTBL)/2
;
; TABLE OF PATCH OFFSETS FOR SOLOS
;
SOLTBL:	DW	3,4,5,8,9,10,11,12,13,14,15,16,17,18,27,28
	DW	41,42,43,44,45,46,47,48,49,50,53,54,55
	DW	64,65,66,67,68,69
	DW	77,78,79,80,81,82,83
	DW	93,94,95,96,97,98,99,100,101,104,105
	DW	130
SOLSIZ	EQU	($-SOLTBL)/2
;
; TABLE OF PATCH OFFSETS FOR ZAPPLE
;
ZAPTBL:	DW	3,4,5,26,27,28,42,43,44
	DW	61,62,63,77,78,79,93,94,95,96,97,98,99
	DW	130
ZAPSIZ	EQU	($-ZAPTBL)/2
;
; PATCH OFFSETS FOR EXIDY SORCERER
;
XIDTBL:	DW	3,4,5,8,9,10,11,12,13,14,15,16,17,18,27,28
	DW	41,42,43,44,45,46,47,48,49,53
	DW	130
XIDSIZ	EQU	($-XIDTBL)/2
;
; THESE ARE THE ACTUAL PATCHES FOR SOLOS
;
CONFS:	MOV	A,M		; CONSOLE STATUS PATCHES
	ANA	A
	DB	0C2H	;JNZ
;
	LDA	3
	CALL	0C022H
;
	RZ
	MOV	M,A
	MVI	A,0FFH
	RET
;
	MVI	M,0	;CONSOLE INPUT
;
	RZ		;CONSOLE OUTPUT
	PUSH	B
	MOV	B,C
	LDA	3
	CALL	0C01CH
	DB	21H	;LXI H
	POP	B
	MOV	M,C
	RET
;
	RLC		;LIST OUTPUT
	RLC
	MOV	B,C
	JMP	0C01CH
;
	LDA	3	;PUNCH OUTPUT
	RLC
	RLC
	NOP
	DB	0C3H	;JMP
;
	LDA	3	;READER INPUT
	RRC
	RRC
	CALL	0C022H
	DB	0CAH	;JZ
;
	NOP
	NOP
;
	DB	1	;INITIALIZATION
	RET
;
; THESE ARE THE ACTUAL PATCHES FOR ZAPPLE
;
CONFZ:	JMP	0F012H	;CONSOLE STATUS
	CALL	0F003H	;CONSOLE INPUT
	JMP	0F009H	;CONSOLE OUTPUT
	JMP	0F00FH	;LIST OUTPUT
	JMP	0F00CH	;PUNCH OUTPUT
	CALL	0F006H	;READER INPUT
	RNC
	MVI	A,1AH
	RET
	DB	1	;INITIALIZATION
	RET
;
; ACTUAL PATCHES FOR EXIDY SORCERER
;
CONFX:	MOV	A,M
	ANA	A
	DB	0C2H
	NOP ! NOP ! NOP
	CALL	0E018H
	RZ
	MOV	M,A
	MVI	A,0FFH
	RET
;
	MVI	M,0
;
	RZ
	NOP ! MOV A,C
	NOP ! NOP ! NOP
	CALL	0E01BH
	RET
;
	DB	4
	CALL	0E9B1H
	RET
;
IOBASE:	DW	0
;
;
;
	END
