/*
	an ls for any type disk, dd odd dir number etc.
	with args for data wanted, wildcards, etc,
*/

/* begincode */

#include "a:std.h"		/* bdscio.h + my stuff */
#include "b:cnode.h"		/* for the package */
#include "b:cnode.g"		/* globals for cnode */


#define OPTNUM 10
#define EXTSIZ 16384
#define USER 0x20
#define GET 0xff

	struct _dpb {
		unsigned _spt;	/* sectors per track */
		char _bsh;	/* data allocation block shift factor */
		char _blm;	/* ? */
		char _exm;	/* extent mask */
		unsigned _dsm;	/* total storage capacity of disk */
		unsigned _drm;	/* total # of directory entries possible */
		char _al0;	/* first 8 reserved directory blocks */
		char _al1;	/* second 8 reserved directory blocks */
		unsigned _cks;	/* size of directory check vector */
		unsigned _off;	/* number of reserved tracks */
	};

	struct dir_entry {
		char usernum;
		char fname[8];
		char ftype[3];
		char extent;
		char rsv1;		/* reserved for bdos */
		char rsv2;		/* reserved for bdos */
		char rc;
		char diskmap[16];
	};

main(argc,argv)
int argc;
char **argv;
{
	struct _dpb dpb;
	struct dir_entry *dir_buf;
	char old_drive, mask_drive, more;
	int curr_drive, new_drive, x;
	char mask[12], dfltmask[13], options[OPTNUM];
	char *maskptr, *ftptr;
	int maskc;
	char **maskv, *maskv_a[P_ARGNUM];

	options[0] = '\0';		/* init default option list */
	mask[11] = '\0';		/* make it a string */
	maskc = argc;
	movmem(argv, maskv_a, (P_ARGNUM * 2));	/* store our own copy */
	maskv = maskv_a;
	dir_buf = curr_drive = NULL;
	Abort = NO;
	more = More;	More = YES;
	Cterm._vrow_p = Mterm._vrow_p = 0;

	old_drive = bdos(CUR_DSK, 0);		/* save */
	mask_drive = 'B';			/* default 'working' dir */

	if ((maskc == 2) && (maskv[1][0] == '-')) {
		purge_lc(maskv[1]);		/* make like from cp/m */
		strcpy(options, &maskv[1][1]);	/* cheat */
		maskv[1] = dfltmask;
		strcpy(dfltmask, "????????.???");
	}
	if (maskc == 1) {
		maskv[0] = dfltmask;
		strcpy(dfltmask, "????????.???");
	}
	else {
		++maskv;		/* no default mask */
		--maskc;		/* don't count it */
	}
	for (x = 0; x < maskc; ++x) {		/* for each arg... */

		purge_lc(maskv[x]);		/* make like from cp/m */
		if (maskv[x][0] == '-') {	/* check for option list */
			strcpy(options, &maskv[x][1]);/* modify default list */
			continue;
		}
		maskptr = maskv[x];
		if (ftptr = index('.', maskptr)) {
			*ftptr = '\0';			/* make fn a str */
			make_mask(mask + 8, ++ftptr, 3);	/* expand ft */
		}
		else setmem(mask + 8, 3, ' ');
		make_mask(mask, maskptr, 8);			/* expand fn */
		if (mask_drive != curr_drive) {
			if (dir_buf) free(dir_buf);
			dir_buf = get_dir(&dpb, mask_drive);
			if (dir_buf == NULL) {	/* ERROR to cnode */
				bdos(SEL_DSK, old_drive);
					/* restore default drive */
				More = more;
				return ERROR;
			}
			curr_drive = mask_drive;
		}
		print_dir(dir_buf, &dpb, mask, options, mask_drive);
		if (Abort) {
			Abort = NO;
			break;
		}
	}		/* end of for loop */

	if (dir_buf) free(dir_buf);	/* free allocated space */
	bdos(SEL_DSK, old_drive);	/* restore default drive */
	More = more;
	return OK;			/* back to 'commands' */
}

print_dir(dir_buf, dpb, mask, options, dr)
struct dir_entry *dir_buf;
struct _dpb *dpb;
char *mask;
char *options;
char dr;
{
 	unsigned nr, blks_used, dskblks_used, pfiles, pblocks, user;
	int extents, x;
	char room, name[9], type[4], al, rsv_blks;
	char *all, *long, *users;

	all = index('A', options);	/* display everything */
	long = index('L', options);	/* long form */
	users = index('U', options);	/* show all user files */
	user = bdos(USER, GET);
	room = 4;
	if (long) {
		vprintf(C_M, "\n   Sectors    Storage       Acc Sys  User    Filename");
		vprintf(C_M, "\n (%d byte)  (kbytes)\n", SECSIZ);
	}
	else {
		vprintf(C_M, "\n Name     Sectors   Name     Sectors  ");
		vprintf(C_M, " Name     Sectors   Name     Sectors\n\n");
	}
	pfiles = pblocks = dskblks_used = 0;
	for(x = 0; (dir_buf[x].usernum >= 0)&&(dir_buf[x].usernum<=15); ++x) {
					/* for each active file... */
		if (Abort) return;
		extents = 0;
		while (dir_buf[x+1].extent
 				&& dir_buf[x+1].usernum >= 0
				&& dir_buf[x+1].usernum <= 15
		) {
			extents = dir_buf[++x].extent;
					/* another extent to file */
		}			/* is there more? */
		nr = (extents * (EXTSIZ / SECSIZ)) + dir_buf[x].rc;
		blks_used = (nr + dpb->_blm) / (dpb->_blm + 1);
		dskblks_used += blks_used;
		movmem(dir_buf[x].fname, name, 8);
		name[8] = '\0';				/* make name a str */
		movmem(dir_buf[x].ftype, type, 3);
		type[3] = '\0';				/* make type a str */
#ifdef RESTRICTED
		if	(	cisubstr(name, "!")
			||	cisubstr(type, "!")
			||	cisubstr(type, "com")
			||	cisubstr(type, "cmd")
			||	cisubstr(type, "bad")
			||	cisubstr(type, "sys")
			||	cisubstr(type, "mbx")
			)	continue;
#endif
		if (match(mask, dir_buf[x].fname)
				&& (all || !(dir_buf[x].ftype[1] & 0x80))
				&& (users || (user == dir_buf[x].usernum))
		) {				/* qualifies for printing */
			++pfiles;
			pblocks += blks_used;
			if (long) {
				vprintf(C_M, "\n %11d  %8d     ",nr,blks_used * ((dpb->_blm+1) / 8));
				vprintf(C_M, " r/%c ", dir_buf[x].ftype[0] & 0x80 ? 'o' : 'w');
				vprintf(C_M, "%s", dir_buf[x].ftype[1] & 0x80 ? "sys " : "    ");
				vprintf(C_M, "# %2d  ", dir_buf[x].usernum);
				vprintf(C_M, "  %s", name);
				if ((type[0] & 0x7f) != ' ') vprintf(C_M, ".%s", type);
				else vprintf(C_M, "    ");
			}
			else {
				vprintf(C_M, "%s", name);
				if ((type[0] & 0x7f) != ' ') vprintf(C_M, ".%s", type);
				else vprintf(C_M, "    ");
				vprintf(C_M, "%5d  ", nr);
				if (!--room) {
					vprintf(C_M, "\n");
					room = 4;
				}
			}
		}
	}			/* all active files counted */
	rsv_blks = 0;
	al = dpb->_al0;
	while (al & 0x80) {
		++rsv_blks;
		al <<= 1;
	}
	al = dpb->_al1;
	while (al & 0x80) {
		++rsv_blks;
		al <<= 1;
	}
	vprintf(C_M, "\n\n\t%d files using %d kilobytes",
		pfiles, pblocks * ((dpb->_blm + 1) / 8));
	vprintf(C_M, "\n\tFree space:  %d files, %d kilobytes\n",
		dpb->_drm+1-x,(dpb->_dsm+1-dskblks_used-rsv_blks)*((dpb->_blm + 1) / 8));

}

match(mask, entry)
char *mask;
char *entry;
{
	while (*mask) {
		if ((*mask == '?') || (*mask == (*entry & 0x7f))) {
			++mask;
			++entry;
		}
		else return FALSE;
	}
	return TRUE;
}

dir_comp(x, y)
char *x;
char *y;
{
	char xx;

	for (xx = 13; (*x != 0xe5) && (*x == *y) && xx; ++x, ++y, --xx)
		;				/* find first difference */
	if (*x > *y) return 1;
	if (*x < *y) return -1;
	return 0;
}

/* same as bios() except returns an unsigned in hl */

hlbios(n, bc, de)
char n;
unsigned bc;
unsigned de;
{
	unsigned addr, *base_ptr;

	base_ptr = 1;
	addr = *base_ptr;
	addr -= 3;
	addr += (n*3);
	return call(addr, 0, 0, bc, de);
}

unsigned *
pick_drive(d)
char d;
{
	if ((d = toupper(d)) < 'A' || d > 'P') {
		vprintf(C_M, "\nbad disk identifier!");
		return NULL;
	}
	bdos(SEL_DSK, (d -= 'A'));	/* select drive in question */
	return hlbios(SELDSK, d, 0);
}

make_mask(mask, ambgstr, pad_length)
char *mask;
char *ambgstr;
char pad_length;
{
	char c;

	while (c = *ambgstr++) {
		if (c == '*') {
			while (pad_length--) *mask++ = '?'; /* pad with '?' */
			return;
		}
		else {
			*mask++ = c;
			--pad_length;
		}
	}
	while (pad_length--) *mask++ = ' ';	/* pad with spaces */
}

struct dir_entry *
get_dir(dpb, drive)
struct _dpb *dpb;
char drive;
{
	struct dir_entry *dir_buf;
 	unsigned *dph_ptr;
	unsigned track;
	int sector, dir_sects, dir_block;
	int dir_comp();
	int x;

	dph_ptr = pick_drive(drive);		/* new disk picked */
	movmem(bdos(DISK_PARMS, 0), dpb, 15);	/* fill dpb */

/* allocate enough memory to hold all the dir sects on it */

	dir_sects = (dpb->_drm + 4) / 4;
	if (!(dir_buf = alloc(dir_sects * SECSIZ))) {
		vprintf(C_M, "\n\tout of free memory!!!");
		return NULL;
	}

/* read them into the buffer */

	dir_block = 0;
	for (track = dpb->_off; dir_sects >= dpb->_spt; dir_sects -= dpb->_spt) {
		bios(SETTRK, track++);
		for (sector = 1; sector <= dpb->_spt; ++sector,++dir_block) {
			bios(SETSEC, hlbios(SECTRAN, sector-1, *dph_ptr));
					/* godbout indexs sectors from 0 */
			bios(SETDMA, dir_buf + (dir_block * (SECSIZ / 32)));
			bios(READ);	/* 32 bytes to a dir entry */
		}
	}		
	bios(SETTRK, track);
	for (sector = 1; sector <= dir_sects; ++sector, ++dir_block) {
		bios(SETSEC, hlbios(SECTRAN, sector-1, *dph_ptr));
				/* godbout indexs sectors from 0 */
		bios(SETDMA, dir_buf + (dir_block * (SECSIZ / 32)));
		bios(READ);	/* 32 bytes to a dir entry */
	}

	qsort(dir_buf, dpb->_drm + 1, 32, dir_comp);		/* sort them */
	return dir_buf;
}

purge_lc(str)
char *str;
{
	while (*str) *str = toupper(*str++);
}

/* endcode */
