/*>>> PACUTIL.C	4/9/82	JCM <<<*/
#include <a:bdscio.h>
#include "pacdefs.h"

update()
{
	char	str[10];

	sprintf(str, "%6d", pscore);
	SPLOT(0, 52, str);
	sprintf(str, "%6d", goldcnt);
	SPLOT(21, 57, str);
}

reinit()
{
	register int locx, locy;
	register char tmp;

	if (boardcount % 2 == 0)
		movie();
	for (locy = 0; locy < BRDY; locy++)
	{
		for (locx = 0; locx < BRDX; locx++)
		{
			tmp = initbrd[locy][locx];
			brd[locy][locx] = tmp;
			if ((display[locy][locx] = tmp) == CHOICE)
			{
				display[locy][locx] = GOLD;
			};
		};
	};
	goldcnt = GOLDCNT;
	delay = delay * 3 / 4;	/* hot it up */
	boardcount++;
}

errgen(string)
char	*string;
{
	SPLOT(23,45,string);
}

dokill(mnum)
	int mnum;
{
	register struct pactyp *mptr;
	char msgbuf[50];

	beep();
	if (monst[mnum].danger == FALSE)
	{
		if (++killcnt == MAXMONSTER)
		{
			if (display[TRYPOS][TRXPOS] == GOLD)
			{
				goldcnt--;
			};
			display[TRYPOS][TRXPOS] = TREASURE;
			PLOT(TRYPOS, TRXPOS, TREASURE);
			killcnt = 0;
			treascnt = potintvl;
		}
		SPLOT(5, 45, "MONSTERS KILLED: ");
		sprintf(message, "%1d", killcnt);
		SPLOT(5, 62, message);
		mptr = (&monst[mnum]);
		mptr->ypos = MSTARTY;
		mptr->xpos = MSTARTX + (2 * mnum);
		mptr->danger = TRUE;
		mptr->stat = START;
		PLOT(mptr->ypos, mptr->xpos, monst_names[mnum]);
		monsthere++;
		rounds = 1;	/* force it to be a while before he comes out */
		switch (monsthere) {
		case 1: pscore +=     KILLSCORE; break;
		case 2: pscore += 2 * KILLSCORE; break;
		case 3: pscore += 4 * KILLSCORE; break;
		case 4: pscore += 8 * KILLSCORE; break;
		}
		sprintf(msgbuf, "You got %s!\n", full_names[mnum]);
		SPLOT(4, 45, msgbuf);
		return(GOTONE);
	};
	wmonst = mnum;
	return(TURKEY);
}

/*
 * clr -- issues an escape sequence to clear the display
 */

clr()
{
	puts(CLEARS);
}


/*
 *	display initial instructions
 */

instruct()
{
	clr();
	POS(0, 0);
	printf("Attention: you are in a maze, being chased by monsters!\n\n");
	printf("There is food scattered uniformly in the maze, marked by \".\".\n");
	printf("One magic potion is available at each spot marked \"O\". Each potion will\n");
	printf("enable you to eat monsters for a limited duration. It will also\n");
	printf("scare them away. When you eat a monster it is regenerated, but this takes\n");
	printf("time. You can also regenerate yourself %d times. Eating all the monsters\n", (MAXPAC-1));
	printf("results in further treasure appearing magically somewhere in the dungeon,\n");
	printf("marked by \"$\". There is a magic tunnel connecting the center left and\n");
	printf("center right parts of the dungeon. The monsters know about it!\n\n");
	printf("        Type:   h or s  to move left\n");
	printf("                l or f  to move right\n");
	printf("                k or e  to move up\n");
	printf("                j or c  to move down\n");
	printf("                <space> to halt \n");
	printf("                q       to quit\n\n");
	printf("        Type:   1       easy game\n");
	printf("                2       intelligent monsters\n");
	printf("                3       very intelligent monsters\n");
	refresh();
}

/*
 * over -- game over processing
 */

over()
{
	register int line, col;
/*
	register int i;
	int scorefile = 0;
	struct passwd *getpwuid(), *p;
*/
	refresh();
	/* clr(); */
	/* high score to date processing */
	if (game != 0)
	{
		col = 45;
		line = 10;
		POS(line++, col);
		printf(" ___________________________ ");
		POS(line++, col);
		printf("|     G A M E   O V E R     |");
		POS(line++, col);
		printf("|                           |");
		POS(line++, col);
		printf("| Game type: %6.6s         |",game==1?"easy":game==2?"medium":"smart");
/*
		if ((scorefile = open(MAXSCORE, 2)) != -1)
		{
			read(scorefile, (char *)scoresave, sizeof(scoresave));
			for (i = MSSAVE - 1; i >= 0; i--) {
				if (scoresave[game - 1].entry[i].score < pscore)
				{
					if (i < MSSAVE - 1)
					{
						scoresave[game - 1].entry[i + 1].score =
							scoresave[game - 1].entry[i].score;
						scoresave[game - 1].entry[i + 1].uid =
							scoresave[game - 1].entry[i].uid;
					};
					scoresave[game - 1].entry[i].score = pscore;
					scoresave[game - 1].entry[i].uid = getuid();
				};
			};
			lseek(scorefile, 0l, 0);
			write(scorefile, (char *)scoresave, sizeof(scoresave));
			close(scorefile);
			POS(line++, col);
			printf("| High Scores to date:      |");
			for (i = 0; i < MSSAVE; i++)
			{
				setpwent();
				p = getpwuid(scoresave[game - 1].entry[i].uid);
				POS(line++, col);
				printf("| Player : %-8s  %5u  |", p->pw_name,
					scoresave[game - 1].entry[i].score);
			};
		}
		else
		{
			/* clr(); */
			POS(line++, col);
			printf("|                           |");
			POS(line++, col);
			printf("| Please create a 'paclog'  |");
			POS(line++, col);
			printf("| file. See 'MAXSCORE' in   |");
			POS(line++, col);
			printf("| 'pacdefs.h'.              |");
		};
*/
		POS(line++, col);
		printf("|                           |");
		POS(line++, col);
		printf("| Your score: %-5u         |", pscore);
		POS(line, col);
		printf("|___________________________|");
	};
	refresh();
	leave();
}

/*
 * leave -- flush buffers,kill the Child, reset tty, and delete tempfile
 */

leave()
{
	POS(22, 0);
	puts(CURSORON);
	/*endwin();*/
	exit(0);
}

/*
 * init -- does global initialization and spawns a child process to read
 *      the input terminal.
 */

init()
{
	TTYMode(16);	/* Tell cio.c to be raw, but expand \n and \t */
	initPOS();	/* initialize the fixed part of posnstr */
	killcnt = 0;
	pacsymb = PACMAN;
	pacptr = &pac;
	boardcount = 1;
	potintvl = POTINTVL;
	treascnt = 0;
	strcpy( monst_names,"BIPC");
	strcpy( runner_names,"bipc");
	strcpy( full_names[0],"Blinky");
	strcpy( full_names[1],"Inky");
	strcpy( full_names[2],"Pinky");
	strcpy( full_names[3],"Clyde");
	full_names[4][0] = '\0';
	strcpy( bigmonster[0],"   _____    ");
	strcpy( bigmonster[1],"  /     \\   ");
	strcpy( bigmonster[2],"  | O O |   ");
	strcpy( bigmonster[3],"  v^v^v^v   ");

	strcpy(initbrd[0], "#######################################");
	strcpy(initbrd[1], "# . . . * . . . . ### . . . . * . . . #");
	strcpy(initbrd[2], "# O ### . ##### . ### . ##### . ### O #");
	strcpy(initbrd[3], "# * . . * . * . * . . * . * . * . . * #");
	strcpy(initbrd[4], "# . ### . # . ########### . # . ### . #");
	strcpy(initbrd[5], "# . . . * # . . . ### . . . # * . . . #");
	strcpy(initbrd[6], "####### . ##### . ### . ##### . #######");
	strcpy(initbrd[7], "      # . # . . * . . * . . # . #      ");
	strcpy(initbrd[8], "      # . # . ### - - ### . # . #      ");
	strcpy(initbrd[9], "####### . # . #         # . # . #######");
	strcpy(initbrd[10],"        * . * #         # * . *        ");
	strcpy(initbrd[11],"####### . # . #         # . # . #######");
	strcpy(initbrd[12],"      # . # . ########### . # . #      ");
	strcpy(initbrd[13],"      # . # * . . . . . . * # . #      ");
	strcpy(initbrd[14],"####### . # . ########### . # . #######");
	strcpy(initbrd[15],"# . . . * . * . . ### . . * . * . . . #");
	strcpy(initbrd[16],"# O ### . ##### . ### . ##### . ### O #");
	strcpy(initbrd[17],"# . . # * . * . * . . * . * . * # . . #");
	strcpy(initbrd[18],"### . # . # . ########### . # . # . ###");
	strcpy(initbrd[19],"# . * . . # . . . ### . . . # . . * . #");
	strcpy(initbrd[20],"# . ########### . ### . ########### . #");
	strcpy(initbrd[21],"# . . . . . . . * . . * . . . . . . . #");
	strcpy(initbrd[22],"#######################################");

	strcpy(brd[0], "#######################################");
	strcpy(brd[1], "# . . . * . . . . ### . . . . * . . . #");
	strcpy(brd[2], "# O ### . ##### . ### . ##### . ### O #");
	strcpy(brd[3], "# * . . * . * . * . . * . * . * . . * #");
	strcpy(brd[4], "# . ### . # . ########### . # . ### . #");
	strcpy(brd[5], "# . . . * # . . . ### . . . # * . . . #");
	strcpy(brd[6], "####### . ##### . ### . ##### . #######");
	strcpy(brd[7], "      # . # . . * . . * . . # . #      ");
	strcpy(brd[8], "      # . # . ### - - ### . # . #      ");
	strcpy(brd[9], "####### . # . #         # . # . #######");
	strcpy(brd[10],"        * . * #         # * . *        ");
	strcpy(brd[11],"####### . # . #         # . # . #######");
	strcpy(brd[12],"      # . # . ########### . # . #      ");
	strcpy(brd[13],"      # . # * . . . . . . * # . #      ");
	strcpy(brd[14],"####### . # . ########### . # . #######");
	strcpy(brd[15],"# . . . * . * . . ### . . * . * . . . #");
	strcpy(brd[16],"# O ### . ##### . ### . ##### . ### O #");
	strcpy(brd[17],"# . . # * . * . * . . * . * . * # . . #");
	strcpy(brd[18],"### . # . # . ########### . # . # . ###");
	strcpy(brd[19],"# . * . . # . . . ### . . . # . . * . #");
	strcpy(brd[20],"# . ########### . ### . ########### . #");
	strcpy(brd[21],"# . . . . . . . * . . * . . . . . . . #");
	strcpy(brd[22],"#######################################");

	strcpy(display[0], "#######################################");
	strcpy(display[1], "# . . . . . . . . ### . . . . . . . . #");
	strcpy(display[2], "# O ### . ##### . ### . ##### . ### O #");
	strcpy(display[3], "# . . . . . . . . . . . . . . . . . . #");
	strcpy(display[4], "# . ### . # . ########### . # . ### . #");
	strcpy(display[5], "# . . . . # . . . ### . . . # . . . . #");
	strcpy(display[6], "####### . ##### . ### . ##### . #######");
	strcpy(display[7], "      # . # . . . . . . . . # . #      ");
	strcpy(display[8], "      # . # . ### - - ### . # . #      ");
	strcpy(display[9], "####### . # . #         # . # . #######");
	strcpy(display[10],"        . . . #         # . . .        ");
	strcpy(display[11],"####### . # . #         # . # . #######");
	strcpy(display[12],"      # . # . ########### . # . #      ");
	strcpy(display[13],"      # . # . . . . . . . . # . #      ");
	strcpy(display[14],"####### . # . ########### . # . #######");
	strcpy(display[15],"# . . . . . . . . ### . . . . . . . . #");
	strcpy(display[16],"# O ### . ##### . ### . ##### . ### O #");
	strcpy(display[17],"# . . # . . . . . . . . . . . . # . . #");
	strcpy(display[18],"### . # . # . ########### . # . # . ###");
	strcpy(display[19],"# . . . . # . . . ### . . . # . . . . #");
	strcpy(display[20],"# . ########### . ### . ########### . #");
	strcpy(display[21],"# . . . . . . . . . . . . . . . . . . #");
	strcpy(display[22],"#######################################");
	srand(0);	/* start rand randomly */
	delay = 500;	/* number of ticks per turn */

	/*
	 * New game starts here
	 */
	if(game == 0)
		instruct();

	while (game == 0)
		poll(1);

	goldcnt = GOLDCNT;
	pscore = 0;
	clr();
	puts(CURSOROFF);
}

/*
 * poll -- read characters sent by input subprocess and set global flags
 */

poll(sltime)
{
	int command;

	if(!kbhit())
		return;

readin:
	command = getchar();

	switch(command & 0177)
	{
	case LEFT:
	case NLEFT:
		pacptr->dirn = DLEFT;
		break;

	case RIGHT:
	case NRIGHT:
		pacptr->dirn = DRIGHT;
		break;

	case NORTH:
	case NNORTH:
		pacptr->dirn = DUP;
		break;

	case DOWN:
	case NDOWN:
		pacptr->dirn = DDOWN;
		break;

	case HALT:
		pacptr->dirn = DNULL;
		break;

	case ABORT:
	case DELETE:
	case QUIT:
		over();
		break;

	case CNTLS:
		goto readin;

	case GAME1:
		game = 1;
		break;

	case GAME2:
		game = 2;
		break;

	case GAME3:
		game = 3;
		break;

	}
}

getrand(range)
	int range;
{
	register unsigned q;

	q = rand();
	return(q % range);
}

/*
 * This function is convenient for debugging pacman.  It isn't used elsewhere.
 * It's like printf and prints in a window on the right hand side of the screen.
 */
/*
msgf(fmt, arg1, arg2, arg3, arg4)
char *fmt;
int arg1, arg2, arg3, arg4;
{
	char msgbuf[100];
	static char msgline = 13;

	sprintf(msgbuf, fmt, arg1, arg2, arg3, arg4);
	SPLOT(msgline, 45, msgbuf);
	if (msgline++ > 20)
		msgline = 13;
}
*/

beep()
{
	putchar('\7');
}
/*
 * Dummy tie-off for the refresh function, since BDS doesn't get hassled by
 * buffered I/O to the console...
 */
refresh()
{
}

/*
 * The PLOT function is normally defined using a preprocessor macro:
 * #define PLOT(A,B,C)  POS(A,B);putchar(C)
 */
PLOT(row,col,ch)
int row,col;
char ch;
{
	POS (row, col);
	putchar(ch);
}

/*
 * The SPLOT function is normally defined as:
 * #define SPLOT(A,B,S) POS(A,B);printf("%s",S)
 */
SPLOT(row,col,str)
int row,col;
char *str;
{
	POS (row, col);
	puts(str);
}

/*
 * napms.  Sleep for ms milliseconds.
 */
#define CLOCKMHZ 2	/* Speed of system clock.  Adjust to fit (sigh...) */
napms(ms)
int ms;
{
	int i,j;
	for (j=0; j<=ms; j++)
		for (i=0; i<=(2*CLOCKMHZ); i++); /* DON'T USE SLEEP!  It uses
					BDOS to check for ^C, so screws up the
					raw i/o */
}
/* This function is called at initialization time to set up
 * the fixed portion of the cursor positioning string.
 */
initPOS()
{
	posnstr[0] = ESC;
	posnstr[1] = 'Y';
	posnstr[4] = '\0';
}

/*
 * The POS function us normally defined, using termcap, as:
 * #define POS(row,col) tputs(tgoto(vs_cm,(col),(row),1,putch)
 */
POS(row,col)
int row,col;
{
	posnstr[2] = 32 + row;
	posnstr[3] = 32 + col;
	puts(posnstr);
}


PLOT(row,col,ch)
int row,col;
char ch;
{
	POS (row, col);
	putchar(ch);
}

/*
 * The