;
;	Pass - Command to enable priviledged use of a ZCPR system
;		running under secure mode with restricted Max user.
;		By Paul S. Traina -- OxGate Node 001 Sysop
;
;		Version 2.0 - 4/27/82
;
;	To run pass do the following:
;		A>PASS <password>  -  To enable wheel mode
;		A>PASS<cr>	   -  To enable wheel mode without
;		  Password: <password>     any echo of password
;		A>PASS D	   -  To disable wheel mode manually
;					 and give default maxuser.
;
;04/27/82-ADDED USRMAX function and made so an incorrect
;	password locks user to USER 0 unless he is already higher.
;	This feature will work only if you have implemented the
;	USRMAX feature added to ZCPR version 1.4 as noted in
;	file ZCPRNOTES.DOC.  Changed (-) to a  D for 'DEFAULT'
;	to give default values for maxuser on restore of system by
;	the ' WHEEL'. An incorrect password will now make max user
;	zero. If incorrect password is used by the Wheel while
;	he is in user 15, he can not get out without abort or running
;	PASS D, or a correct password.  ADDED Comments to tell what
;	happened after each command .Hal  Walchli,W3TWI
;
CR	EQU	0DH		;termination character
PSTRING	EQU	09H		;BDOS Print a string
ENABLE	EQU	0FFH		;this is poked into WHEEL
FCB	EQU	005CH		;file control block+1
BDOS	EQU	0005H		;bdos location
WHEEL	EQU	003EH		;location of wheel byte
USRMAX	EQU	003FH		;location of maxuser byte
;
	ORG	100H
;
;
SELECT:	LDA	FCB+1		;see what we are supposed to do
	CPI	' '		;don't echo pasword (someone looking over
	JZ	GETPASS		;your shoulder?)
	CPI	'D'		;disable wheel mode (become humble again)
	JZ	DISABLE
				;No, we have a JCL, so let's read it in...
COMPARE:
	LXI	H,PASSWD	;set up all the pointers
	LXI	D,FCB+1		;location of password buffer
	MVI	B,PRGEND-PASSWD	;number of characters of real password
CKPASS:	LDAX	D		;trial password to A
	CMP	M		;check for a match
	JNZ	RESET		;return to CCP (beware of skewed stacks)
	INX	H		;HL=HL+1
	INX	D		;DE=DE+1
	DCR	B		;B=B-1
	JNZ	CKPASS		;if B>0 then CKPASS
	MVI	C,9		;WHEEL message
	LXI	D,PMSG3
	CALL	BDOS
	MVI	A,ENABLE	;Set enable flag
J2:	STA	USRMAX		;MAKE MAXUSR=15
PWOUT:	STA	WHEEL
	RET			;return to CCP (watch stack or else...)
;
DISABLE:
	MVI	C,9		;Default Message
	LXI	D,PMSG2
	CALL	BDOS
	MVI	A,0BH		;MAXUSER +1
	STA	USRMAX
	XRA	A
	JMP	PWOUT
;
RESET:
	MVI	C,9
	LXI	D,PMSG4
	CALL	BDOS
	XRA	A
	JMP	J2
;
GETPASS:
	MVI	C,9
	LXI	D,PMSG
	CALL	BDOS
	LXI	H,FCB+1		;ok, use the fcb as a buffer
GETLOOP:
	PUSH	H		;save HL
LOOP1:	MVI	C,6		;use direct console i/o
	MVI	E,0FFH		;input a character
	CALL	BDOS		;get character into A
	ORA	A		;set flags
	JZ	LOOP1		;no character found, try again
	POP	H		;restore HL
	ANI	95		;lowercase to uppercase (indiscriminate but
				;effective). Must not have numbers/symbols
				;in password with this here.
	CPI	CR		;is it a <cr>?
	JZ	COMPARE
	MOV	M,A		;store character in fcb
	INX	H		;increment pointers
	JMP	GETLOOP		;loop until we get a <cr>
;
PMSG:	DB	'Password? $'
PMSG2:	DB	'Default User $'
PMSG3:	DB	'WHEEL in force $'
PMSG4:	DB	'Not Accepted $'
PASSWD:	DB	'PASSWD'	;Password shouldn't be more than 10 chars
				;or somethings may die exotically.
PRGEND:
;

	END
..)
;
DISABLE:
	MVI	C,9		;Default Message
	LXI	D,PMSG2
	CALL	BDOS
	MVI	A,0BH		;MAXUSER +