TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE
;
WBOOT	EQU	0	;WARM BOOT ENTRY
BDOS	EQU	0005H	;BDOS ENTRY LOCATION
ACR	EQU	0DH	;ASCII CARRIAGE RETURN
ALF	EQU	0AH	;ASCII LINE FEED
AFF	EQU	0CH	;ASCII FORM FEED
;
PIP20	EQU	FALSE
;
  	ORG  0167H
;	
PATCH$1:
	CALL 0894H
	CALL MOVE$NAME
	RET  
;
PATCH$2:
	MVI  E,0FFH	;DIRECT CONSOLE INPUT FLAG
	MVI  C,06H	;DIRECT CONSOLE I/O
	CALL BDOS	;GET CONSOLE KEY
	CPI  ACR	;QUIT ?
	JZ   WBOOT
	CALL MOVE$NAME

	IF	PIP20

	JMP  1B5FH

	ELSE	

	JMP  1B5AH

	ENDIF
;
MOVE$NAME:
	PUSH PSW  
	LXI  H,005DH	;POINT TO FILE NAME IN FCB
	LXI  D,DUMMY	;TEMP NAME STORE
	MVI  B,11	;LENGTH OF NAME
NAME$LOOP:
       	LDAX D		;GET A BYTE FROM STORE
	MOV  C,A	;HOLD IT IN C
	MOV  A,M	;GET BYTE FROM FCB
	MOV  M,C	;PUT STORE BYTE INTO FCB
	STAX D		;PUT FCB BYTE INTO STORE
	INX  H		;POINT TO NEXT BYTES
	INX  D
	DCR  B		;ADJUST COUNT
	JNZ  NAME$LOOP
	POP  PSW  
	RET  
;	
DUMMY	DB	'???????????'	;TEMPORARY FILE NAME STORE
;
	ORG	5A8H
;
	NOP
	NOP
	NOP
;
	IF	NOT PIP20

	ORG	1AEFH

	DB	0FAH

	ENDIF
;
	IF	PIP20

	ORG	1B95H

	ELSE

	ORG	1B6EH

	ENDIF
;
	DW	PATCH1
;
	IF	PIP20

	ORG	1C46H

	ELSE

	ORG	1C0CH

	ENDIF
;
	DW	PATCH2
;
	END
