;REMOTE TERMINAL PROGRAM
;by Harry Kaemmerer (C) 05/14/1982
;
;The relocator portion of this program is based
;on Kelly Smith's I/O-CAP.ASM (CP/M-NET)
;Thank's Kelly...
;
;This program is in the PUBLIC DOMAIN, but is NOT 
;to be used for COMMERCIAL BENEFIT in any form.
; 
;
; DEFINE TRUE/FALSE ASSEMBLY PARAMETERS
				;
TRUE	EQU	-1		;DEFINE TRUE
FALSE	EQU	NOT TRUE	;DEFINE FALSE
DEBUG	EQU	TRUE		;DEFINE DEBUG
CCS2830	EQU	TRUE		;TRUE=CCS-2830 SER. BOARD
				;
	IF	DEBUG		;
DEST	EQU	0A000H		;RUNNING LOCATION OF CODE
	ENDIF			;DEBUG
				;
	IF	NOT DEBUG	;
DEST	EQU	0FE00H		;RUNNING LOCATION OF CODE
	ENDIF			;NOT DEBUG
				;
BASE	EQU	0		; 
				; 
BDOS	EQU	BASE+5		;BDOS ENTRY POINT AND FUNCTION CODES 
				; 
				;
	IF CCS2830		;
OTSB	EQU	 4H		;VALUE WHEN READY SEND CHAR
INSB	EQU	 1H		;VALUE WHEN WE HAVE CHAR
DDATA	EQU	10H		;CONSOLE DATA   PORT
DSTAT	EQU	11H		;CONSOLE STATUS PORT
SDATA	EQU	24H 		;MODEM   DATA   PORT
SSTAT	EQU	25H 		;MODEM   STATUS PORT 
	ENDIF			;CCS2830
				;
	IF NOT CCS2830		;
	'You must Def. your ports and status check Bits'
	ENDIF			;
				; 
CR	EQU	0DH		;CARRIAGE RETURN
LF	EQU	0AH		;LINE FEED
BELL	EQU	07H		;DEF BELL
MASK	EQU	7FH		;KILL BIT 7
				;
	ORG	BASE+100H	;
				;
	LXI	H,0		;SAVE OLD STACK POINTER
	DAD	SP		;
	SHLD	OLDSTK		;
	LXI	SP,STACK	;MAKE A NEW STACK POINTER
				;
	IF	CCS2830		;
CTC12:	MVI	A,01000111B	;CTC MODE FOR 1200 BAUD
	OUT	20H		;
	MVI	A,104		;CTC COUNT FOR 1200 BAUD
	OUT	20H		;
DART1:	MVI	A,00010100B	;RESET DART1     CREG.0
	OUT	SSTAT		;
	MVI	A,01000100B	;CLK, 1 STOP BIT CREG.4
	OUT	SSTAT		;
	MVI	A,00000011B	;CREG.3 NEXT
	OUT	SSTAT		;
	MVI	A,11000001B	;8 DATA BITS, RX EN CREG.3
	OUT	SSTAT		;
	MVI	A,00000101B	;CREG.5
	OUT	SSTAT		;
	MVI	A,11101000B	;DTR, 8 BITS, TX EN, CREG.5
	OUT	SSTAT		;
	IN	SSTAT		;READ STATUS TO FIND OUT IF
	ANI	00100000B	;ISOLATE BAUD RATE INDICATOR
	CPI	00100000B	;IS BAUD RATE 1200 BAUD
	JZ	BAUDOK		;BAUD RATE IS 1200 BAUD
				;
CTC30:	MVI	A,00000111B	;CTC MODE FOR 300 BAUD
	OUT	20H		;
	MVI	A,52 		;CTC COUNT FOR 300 BAUD
	OUT	20H		;
	MVI	A,00010000B	;RESET DART1     CREG.0
	OUT	SSTAT    	;
	ENDIF			;CCS2830
				;
BAUDOK	LXI	H,0		; 
	LHLD	BASE+1		;GET BIOS POINTER
	LXI	D,5		;ADD BIAS TO CONSOLE STATUS ADDRESS
	DAD	D		;
	MOV	D,M		;SAVE IN [D]
	LHLD	NEWJTBL+1	;SEE IF VECTOR ADDRESSES ACTIVE
	MOV	A,H		;BEEN PATCHED BY PREVIOUS EXECUTION?
	CMP	D		;
	JZ	UNPATCH		;UN-PATCH, IF SO
	LXI	B,PEND-START+1		;NUMBER OF BYTES TO MOVE
	LXI	H,DEST+PEND-START+1	;END OF MOVED CODE
	LXI	D,SOURCE+PEND-START	;END OF SOURCE CODE
				;
MVLP	LDAX	D		;GET BYTE
	DCX	H		;BUMP POINTERS
	MOV	M,A		;NEW HOME
	DCX	D		;
	DCX	B		;BUMP BYTE COUNT
	MOV	A,B		;CHECK IF ZERO
	ORA	C		;
	JNZ	MVLP		;IF NOT, DO SOME MORE
	PCHL			;DO IT, TO IT...
				;
SOURCE	EQU	$		;BOUNDARY MEMORY MARKER
				;
OFFSET	EQU	DEST-SOURCE 	;RELOCATION AMOUNT
				;
; THE FOLLOWING CODE GETS MOVED TO HIGH RAM LOCATED AT "DEST", 
; WHERE IT IS EXECUTED. C A U T I O N :  IF MODIFYING ANYTHING 
; IN THIS PROGRAM FROM HERE ON: ALL LABELS MUST BE OF THE FORM:
;
; LABEL	EQU	$+OFFSET		
;
; ...IN ORDER THAT THE RELOCATION TO HIGH RAM WORK 
; SUCCESSFULLY.  FORGETTING TO SPECIFY '$+OFFSET' WILL CAUSE 
; THE PROGRAM TO JMP INTO WHATEVER IS CURRENTLY IN LOW MEMORY, 
; WITH UNPREDICTABLE RESULTS.  BE CAREFUL....		
				;
START	EQU	$+OFFSET	;
				;
				;PATCH IN THE NEW JUMP TABLE 
				;(SAVING THE OLD)
PATCH	EQU	$+OFFSET	;
	CALL	TBLADDR		;CALC [HL] =  CP/M JMP TABLE
	LXI	D,VCSTAT	;POINT TO SAVE LOCATION
	CALL	MOVE		;MOVE IT
				;NOW MOVE NEW JUMP TABLE TO CP/M
	CALL	TBLADDR		;CALC [HL] = CP/M'S JMP TABLE
	XCHG			;MOVE TO DE
	LXI	H,NEWJTBL	;POINT TO NEW
	CALL	MOVE		;MOVE IT
	LXI	H,ACTIVE$MESSAGE	;
	CALL	MSGOUT		;
	LHLD	OLDSTK		;GET OLD CP/M STACK POINTER
	SPHL			;
	RET			;
				;
UNPATCH EQU	$+OFFSET	;
	LXI	H,INACTIVE$MESSAGE	;
	CALL	MSGOUT		;
	CALL	TBLADDR		;[HL] = CP/M'S JMP TABLE
	XCHG			;MOVE TO DE
	LXI	H,VCSTAT	;GET SAVED TABLE
	CALL	MOVE		;MOVE ORIG BACK
	LHLD	OLDSTK		;GET OLD CP/M STACK POINTER
	SPHL			;
	RET			;
				;
				;CALCULATE [HL] = CP/M'S JUMP TABLE, 
				;[B] = LENGTH
TBLADDR EQU	$+OFFSET	;
	LHLD	BASE+1		;GET BIOS POINTER
	INX	H		;..SKIP
	INX	H		;..TO
	INX	H		;..CONSOLE STATUS
	MVI	B,9		;MOVE CONSOLE JUMP VECTORS
	RET			;
				;
				;MOVE [HL] TO [DE], LENGTH IN [B]
MOVE	EQU	$+OFFSET	;
	MOV	A,M		;GET A BYTE
	STAX	D		;PUT AT NEW HOME
	INX	D		;BUMP POINTERS
	INX	H		;
	DCR	B		;DECREMENT BYTE COUNT
	JNZ	MOVE		;IF MORE, DO IT
	RET			;IF NOT, RETURN
				;
MSGOUT	EQU	$+OFFSET	;
	MOV	A,M		;GET CHARACTER FROM MESSAGE STRING
	ORA	A		;ALL OF STRING DISPLAYED?
	RZ			;RETURN, IF SO
	INX	H		;NO, BUMP POINTER FOR NEXT CHARACTER
	MOV	C,A		;PASS CHARACTER TO 'OLD' BIOS VECTOR
	CALL	CONOUT		;
	JMP	MSGOUT		;DISPLAY NEXT CHARACTER IN MESSAGE STRING
				;
CONOUT	EQU	$+OFFSET	;
	PUSH	B		;
	PUSH	D		;
	PUSH	H		;
	CALL	VCOUT		;
	POP	H		;
	POP	D		;
	POP	B		;
	RET			;
				;
				;THIS IS THE JUMP TABLE WHICH 
				;IS COPIED ON TOP OF THE ONE 
				;POINTED TO BY LOCATION 1 IN CP/M
				;
NEWJTBL EQU	$+OFFSET	;
	JMP	READS1          ;CONSOLE STATUS TEST
	JMP	KEYBD1		;CONSOLE INPUT ROUTINE
	JMP	PUNCH		;CONSOLE OUTPUT ROUTINE
				;
				;
CONST1  EQU	$+OFFSET	;
	IN	DSTAT           ;CHECK CONSOL STATUS
	ANI	INSB            ;IS IT CLEAR
	CPI	INSB		;
	JNZ     CT1             ;NO I DON'T HAVE A CHARACTER  
	CMA                     ;COMPLIMENT A REGISTER (MAKE FFH)
	ORA     A               ;CLEAR FLAGS
	RET                     ;RETURN
                                ;
CT1     EQU	$+OFFSET	;
	XRA	A               ;CLEAR A REGISTER AND FLAGS
	RET                     ;RETURN IF NO CHARACTER IS PRESENT
                                ;
READS1  EQU	$+OFFSET	;
	IN	SSTAT           ;CHECK READER STATUS
	ANI	INSB            ;IS IT CLEAR
	CPI	INSB		;
	JNZ     CONST1          ;NO I DON'T HAVE A CHARACTER  
        CMA                     ;COMPLIMENT A REGISTER (MAKE FFH)
        ORA     A               ;CLEAR FLAGS
        RET                     ;RETURN
                                ;
READST  EQU	$+OFFSET	;
	IN	SSTAT           ;CHECK READER STATUS
	ANI	INSB            ;IS IT CLEAR
	CPI	INSB		;
	JNZ     CT2             ;NO I DON'T HAVE A CHARACTER  
        CMA                     ;COMPLIMENT A REGISTER (MAKE FFH)
        ORA     A               ;CLEAR FLAGS
        RET                     ;RETURN
                                ;
CT2     EQU	$+OFFSET	;
	XRA	A               ;CLEAR A REGISTER AND FLAGS
	RET                     ;RETURN IF NO CHARACTER IS PRESENT
                                ;
KEYBD   EQU	$+OFFSET	;
	CALL    CONST1          ;CHECK CON STATUS
	CPI	0		;
        JZ      KEYBD           ;DO IT AGAIN IF ZERO
        IN      DDATA           ;GET CHARACTER
        ANI     MASK            ;CLEAR BIT 7
        RET                     ;RETURN
                                ;
KEYBD1  EQU	$+OFFSET	;
	CALL	CONST1          ;GET CONSOL STATUS
        JZ      READ1           ;GET READER STATUS
        IN      SDATA           ;CLEAR READER PORT
        IN      SDATA           ;CLEAR READER PORT
        IN	DDATA           ;GET A CHARACTER
	ANI	MASK            ;CLEAR BIT 7
	RET                     ;RETURN
                                ;
READ1	EQU	$+OFFSET	;
	CALL    READST          ;GET READER STATUS
	JZ      KEYBD1          ;GET CONSOL STATUS
        IN      DDATA           ;CLEAR CONSOL PORT
        IN      DDATA           ;CLEAR CONSOL PORT
	IN      SDATA           ;GET DATA
        ANI     MASK            ;CLEAR BIT 7
        RET                     ;RETURN
                                ;
READER  EQU	$+OFFSET	;
	CALL    READST          ;CHECK READER STATUS
	JZ      TEST2           ;TEST FOR "ESC"
	IN      SDATA           ;GET DATA
        RET                     ;RETURN
                                ;
TEST2   EQU	$+OFFSET	;
	CALL    CONST1          ;CHECK CONSOLE FOR CHARACTER
	CPI	0		;
        JZ      READER          ;RETURN TO CALLER
        CALL    KEYBD           ;GET CHARACTER FROM CONIN
        RET                     ;IF NO RETURN
                                ;
PUNCH	EQU	$+OFFSET	;
	IN      SSTAT           ;CHECK PORT STATUS
	ANI	OTSB            ;SEE IF READY TO SEND
	CPI	OTSB		;
	JNZ     PUNCH           ;
        MOV     A,C             ;PUT CHARACTER IN A REGISTER
        OUT     SDATA           ;SEND DATA TO PUNCH
	OUT	DDATA		;ECHO TO CONSOLE
        RET                     ;RETURN
                                ;
						;
ACTIVE$MESSAGE	EQU	$+OFFSET		;
	DB	'Remote On  -->',CR,LF,LF,0 	;
						;
INACTIVE$MESSAGE  EQU	$+OFFSET		;
	DB	'Remote Off -->',CR,LF,0 	;
						;
PEND	EQU	$+OFFSET	;END OF RELOCATED CODE
				;
				;DATA AREA
				; 
	DS	128		;64 LEVEL STACK
STACK	EQU	$+OFFSET	;LOCAL STACK
				;
				;SAVE THE CP/M JUMP TABLE HERE
				;
VCSTAT	EQU	$+OFFSET	;
	DS	3		;
				;
VCIN	EQU	$+OFFSET	;
	DS	3		;
				;
VCOUT	EQU	$+OFFSET	;
	DS	3		;
				;
OLDSTK	EQU	$+OFFSET	;
	DS	2		;STORAGE FOR OLD CP/M STACK POINTER
ENDMARK	EQU	$+OFFSET	;IGNORE ERROR - THIS MARKS END OF PROGRAM
				;
	END
