/*	Machine Code Linkage (quick and dirty!!!)

	Sometimes it can be helpful to add a small piece (5-10 bytes)
of machine code to a c program, perhaps to test an idea, or to speed
something up.  The right way would be to write it in MAC asm language,
using the library provided with bdsc to create crl functions.  I'm
going to show you the cheap way.

	If we need to pass values in the registers we can use the
stdlib function call().  If we just need to get there we can use
redirection (I know we could also strip stuff from the stack, don't
confuse me!).  

	First we need to get the code into the program.  A large piece
could could be assembled and 'swapin()ed'.  Several bytes can be
placed directly into an array as below.  We declare a 2 byte long
array called restart, then place f7 hex (software restart #6) in the
first byte and c9 hex (return) in the second.

	An alternative method is shown next using indirection on a
pointer to char.  Bar was declared to be a pointer to char and
assigned a value of 30 hex.  This just happens to be the address the
8080/z80 will to go when it executes a 'rst 6' instruction (any
guesses on what we're going to do yet?).  We make the address that bar
points to contain c3 hex (jump), then inc bar.  The next 2 indirection
assignments put the address of the function foo() at 31 and 32 hex. We
had previously declared foo_ptr to be a pointer to a function and then
made it equal the address of foo().  '*bar++ = foo_ptr & 0xff' gets
the low order byte of the address into 31 hex, 'foo_ptr >>= 8' shifts
the high order byte into the low byte of foo_ptr and then '*bar ='
puts the byte into 32 hex.  We could have made bar a pointer to
unsigned and stuffed the address in one swipe (hindsight).

	Anyway, we're ready to do something, I think.  Calling restart
sends us to our software restart instruction. That pushes its address
on the stack and calls 0x30.  Here our 'dirty' code jumps to the
address of the function foo(), which executes and returns to the c9
hex we placed after the software restart.  This 'ret' returns to the
'call() invocation and main reports our successful return.

	What good is all this?  Beats me.  But it sure was fun.
Actually this was a little experiment I developed to test some theory
on writing interrupt driven tasks and coroutines in c.  But that's way
beyond the scope of this article, contact me if this idea intrigues
you also.

*/

main()
{
	int foo();
	unsigned foo_ptr;
	char *bar;
	char restart[2];

	restart[0] = 0xf7;
	restart[1] = 0xc9;
	foo_ptr = foo;
	bar = 0x30;
	*bar++ = 0xc3;
	*bar++ = (foo_ptr & 0xff);
	*bar = (foo_ptr >>= 8);
	call(restart, 0,0,0,0);
	printf("\n...and got back too!!!!!!!!!!!!");
}

foo()
{
	printf("\nmade it!!!!!");
}


ready