	title	'BDS C 1.44 setjmp.s & longjmp.s'
;
	maclib	bds
	maclib	cmac
;
;	J. Giraud
;	26 Arlington Ave, Toronto, Ont.
;	M6G 3K8
;	(416) 651-6648
;
;
;	This routines do the setjmp and longjmp a la v7 Unix.
;
;	setjmp(buf)
;	char buf[6];
;	takes a buf 6 char long and save the stack
;	pointer, bc and the pc from the stack.
;	It returns 0.
;
;	longjmp(buf, val)
;	char buf[6];
;	int val;
;
;	longjmp takes a saved buffer and transfer the
;	contents of it into the appropriate registers affecting
;	a non-local goto that preserves the enviroment. It
;	returns val to the procedure where the setjmp was first
;	used.
;
;	The setjmp routine is self modifying, but I couldnt do
;	it any other way and maintain stack integraty.
;

	direct
	define	setjmp
	define	longjmp
	enddir
;
	prelude setjmp
;
setjmp: call	arghak		;get pointer to save in hl
	lhld	arg1
	mov	m,c		;save c
	inx	h
	mov	m,b		;save b
	inx	h
;
	xchg			;put pointer in de
	lxi	h,2
	dad	sp		;transfer sp + 2 into hl
	xchg			;sp now in de.
	mov	m,e		;save e
	inx	h
	mov	m,d		;save d
	inx	h
;
	xchg			;transfer ptr to de
	lxi	h,0		;transfer sp to hl
	dad	sp
;
	push	d		;push the pointer
;
	mov	e,m
	inx	h
	mov	d,m		;get return addr in de
;
	pop	h		;restore ret addr
;
	mov	m,e
	inx	h
	mov	m,d		;save it
;
	lxi	h,0		;return value of 0
	ret
;
	postlude setjmp
;
	prelude longjmp
;
longjmp equ	$
;
; arg 1 - pointer to saved buffer
; arg 2 - pointer to return val for function
;
	call	arghak		;transfer parameters
	pop	d		;discard return addr
	lhld	arg1		;get pointer to save buffer
;
	mov	c,m		;restore c
	inx	h
	mov	b,m		;restore b
	inx	h
;
	mov	e,m		;get sp word and put in de
	inx	h
	mov	d,m
	inx	h
	xchg			;hl points to old stack
	sphl			;restore stack
;
	xchg			;restore pointer
	mov	e,m		;get e
	inx	h
	mov	d,m
	xchg			;hl = return addr
	reloc	shld,jmpret
;
	lhld	arg2		;get return value
	db	jmp		;put in a jump byte
jmpret: dw	0
;
	postlude longjmp
;
	end
