/*
 *	sort filter
 *	-----------
 *
 *	Simple sort filter taken from Software Tools in Ratfor.
 *	Sort used is shell sort. Implemented by J. Giraud
 *
 *	usage: sort
 *
 *	Sort reads stdin and write stdout, so to sort a file
 *	called foo.dat and write it into fum.dat, you would go
 *	sort <foo.dat >fum.dat. For more info on directed i/o
 *	see dio.c and dio.h.
 *
 */

#include  "bdscio.h"
#include  "dio.h"

#define	  MAXPTR    1500	/* max line to be sorted */
#define	  MAXLINE   128		/* max size of a line */
#define	  stderr    4		/* console file descriptor */

     char *tbuf;

/*
 *	Build takes input and places each line in ptable.
 */
build(ptable, icnt)
char **ptable;		/* pointer to table */
int  *icnt;		/* number of data item read */
{
     int  bufs;	    /* maximium size of buffer */
     char *mptr;    /* in memory pointer */

     bufs = topofmem() - 1000;
     mptr = &tbuf + 1;

     while ((mptr < bufs) && (getds(mptr) != 0)) {
	  ptable[(*icnt)++] = mptr;
	  mptr += strlen(mptr) + 1;
     }

     if (mptr > bufs+200) {
	  fprintf(stderr, "\n+To large to sort in memory\n");
	  dioflush();
	  exit();
     }
}
sort(ptrs, n)		/* in mem shell sort */
char **ptrs;
int  n;
{
     int  i,j,gap,ig;
     char *k;

     for (gap = n / 2; gap > 0; gap = gap / 2)
	  for (j = gap + 1; j <= n; j++)
	       for (i = j - gap; i > 0; i = i - gap) {
		    ig = i + gap;
		    if (strcmp(ptrs[i],ptrs[ig]) <= 0)
			 break;
		    k = ptrs[i];
		    ptrs[i] = ptrs[ig];
		    ptrs[ig] = k;
	       }
}
main(argc,argv)
int  argc;
char **argv;
{
     char *ptrs[MAXPTR];
     int  nptrs;
     char *mptr;
     int  i;

     dioinit(&argc,argv);	/* init the dio */

     mptr = &tbuf;
     nptrs = 1;

     for (i=0; i<MAXPTR; ptrs[i++] = NULL)
	  ;

     build(ptrs,&nptrs);	/* get the data */
     sort(ptrs,nptrs);		/* and sort it */

     for (i = 1; i < nptrs; ++i)	/* output it */	       
	if (putds(ptrs[i]) == ERROR)
		fprintf(stderr, "\nDisk Full Error?\n");

     dioflush();
}
