;APPATCH1.ASM 26SEP82
;written by Matthew Von-Maszewski
;P.O. Box 5189
;College Station ,TX  77840
;from Lifelines, MarcH 1982
;Apple ][ keyboard patch to allow control
;characters to get to the operating system
;WITHOUT being filtered out by the 24x80 card.
;
;There should be no characters defined under CONFIGIO.
;This patch requires the following hardware changes.
;A wire from the third from the left end of the 25-pin
;keyboard connector goes to pin 4 of the ls251 in front
;of the game paddle connector. A wire from the second right
;from the end of the keyboard connector goes to pin 4
;of the game paddle connector. The lead from the
;game paddle must be bent out of the way.
;NOTE   this is the STANDARD fix (i.e. for PASCAL)
;detailed instructions on patching:
;1. ASM APPATCH1.ASM
;2. LOAD APPATCH1
;3. MBASIC CONFIGIO
;4. in section 2 of CONFIGIO, delete any redefinitions.
;5. in section 3 of CONFIGIO, read in APPATCH1
;6. save on the disk using section4 of CONFIGIO.
;
;RECORD OF CHANGES
;25 SEPT 82 W F MCGEE CHANGED FROM GAME PADDLE E062 TO E060
;TO ALLOW THE KIDS TO KEEP THE PADDLES GOING!!
;I solder to the keyboard connector, but just insert the
;wire-wrap wire into a LSI socket hole, along with the IC.
;
;
PATCH	EQU	0F280H	;placed in the punch area because the
			;keyboard patch area is too small
FALSE	EQU	0
TRUE	EQU	NOT FALSE

SHIFT	EQU	TRUE	;SHIFT KEY
SHLOCK	EQU	TRUE	;CTRL KEY

	ORG	100H
	DB	1
	DW	PATCH	;DESTINATION OF PATCH
	DW	LC2-LC1	;LENGTH OF CODE
	DB	1	;PATCH TYPE 1
	DB	2	;PATCH	VECTOR	2
	DW	PATCH	;WHERE TO SEND VECTOR

LC1	EQU	$
BIAS	EQU	PATCH-$
L1:	LDA	0E000H	;GET VALUE FROM KEYBOARD
	CPI	80H	;TEST A NEW ENTRY
	JC	L1+BIAS	;NOT YET
	ANI	7FH	;STRIP HIGH BIT
	STA	0E010H	;TURN OFF KEYBOARD STROBE

	IF	SHIFT

	IF	SHLOCK
	PUSH	B
	MOV	B,A	;SAVE CHAR
	LDA	FLAG+BIAS	;SEE IF UNDER SHIFT LOCK
	INR	A	;TEST FLAG
	MOV	A,B	;GET CHARACTER BACK
	JZ	L2+BIAS	;JUMP IF SHIFT LOCK
	CPI	41H	;TEST IN LETTER AREA
	JC	L2+BIAS	;LEAVE IF NOT ALPHA
	ENDIF
	IF	NOT SHLOCK
	CPI	41H	;TEST IN LETTER AREA
	JC	L2+BIAS+1	;LEAVE IF NOT ALPHA
	PUSH B	;SAVE THIS REGISTER
	ENDIF

	MOV	B,A
	LDA	0E063H	;GET SHIFT
	ANI	80H	;STRIP GARBAGE
	RRC	;MOVE TO BIT 6
	RRC	;MOVE TO BIT 5
	ORA	B	;DO THE STUFF
L2:	POP	B
	CPI	40H	;CHECK FOR WRONG KEYS IN
	JZ	L4+BIAS	;MAKE @ A CAP-P LIKE IT SHOULD BE
	CPI	5EH	;SEE IF ^
	JZ	L3+BIAS	;MAKE ^ A CAP-N
	CPI	5DH	;SEE IF ]
	JNZ	L5+BIAS	;NOPE:LEAVE THE REST ALONE
L3:	ANI	4FH	;FIX N AND M
	JMP	L5+BIAS	;KITTY FIXED
L4:	MVI	A,50H	;BACK TO P
L5:
	ENDIF
	
	IF SHLOCK
	PUSH 	PSW	;SAVE CHARACTER
	LDA	0E060H	;GET CTRL
	RAL		;
	JC	L8+BIAS	;SKIP IF CTRL NOT PRESSED
	POP	PSW	;GET THE CHARACTER
	CPI	2DH	;CHECK LOWER BOUND
	JC	L8+BIAS+1	;BELOW WHAT WE ARE LOOKING FOR
	CPI	3BH	;CHECK UPPER BOUND
	JNC	L8+BIAS+1	;ABOVE WHAT WE ARE LOOKING FOR
	CPI	30H	;TEST SHIFT LOCK
	JZ	L7+BIAS	;IT IS. JUMP

	;TRANSLATE AREA

	PUSH	H
	LXI	H,TABLE+BIAS	;BASE OF TRANSLATE TABLE
	SUI	2DH	;STRIP OF UNNEEDED ASCII
	ADD	L	;DO OFFSET
	MOV	L,A	;SAVE OFFSET
	JNC	L6+BIAS	;SEE IF CARRY INTO H
	INR	H	;ADD 1
L6:	MOV	A,M	;GET REPLACEMENT VALUE
	POP	H
	JMP	L8+BIAS+1	;FINALLY FINISHED

L7:	LDA	FLAG+BIAS	;
	CMA			;CHANGE FLAG
	STA	FLAG+BIAS	;PUT FLAG IN NEW STATE
	JMP	L1+BIAS		;GET THE NEXT CHARACTER

FLAG	DB	0		;STARTS OFF LOWER CASE

TABLE:	;CHARACTER TRANSLATION TABLE
	DB	5FH	;CTRL-= TO RUB(UNDERLINE)
	DB	7FH	;CTRL-. TO DLE
	DB	5CH	;CTRL-/ TO \
	DB	0	;SHIFT LOCK GETS INTERCEPTED
	DB	7CH	;CTRL-1 TO |
	DB	00H	;CTRL-2 TO NUL
	DB	7EH	;CTRL-3 TO 
	DB	7BH	;CTRL-4 TO {
	DB	7DH	;CTRL-5 TO }
	DB	5EH	;CTRL-6 TO ^
	DB	60H	;CTRL-7 TO `
	DB	5BH	;CTRL-8 TO [
	DB	5DH	;CTRL-9 TO ]
	DB	40H	;CTRL-: TO @

L8:	POP	PSW	;GET CHARACTER BACK
	ENDIF
	RET
LC2	EQU	$

                                                                                                                                                                                                                                                                