/*

**********
* APPEND *
**********

  A simple "ASCII" file appender.

  Commmand format:

	A>APPEND F1.XX F2.YY

  File F2.YY is "appended" IN PLACE to F1.XX. No backup of F1.XX is made
  nor is F2.YY deleted. This routine is a handy little hack for combining
  ascii lex files for spell11.

  P.A. Mongelluzzo (9/13/82)

*/

#include <a:bdscio.h>			/* the standard header */

#define	 CPM2X		TRUE		/* set to false for cp/m 1.4 */
#define	 BUFSECTS	64		/* 8k (aprx) buffer */

char	buf1[BUFSECTS * SECSIZ];	/* file 1 buffer */
char	buf2[BUFSECTS * SECSIZ];	/* file 2 buffer */
int	fd1, fd2;			/* file descriptors */
int	fs1, fs2;			/* file sizes */
int	nsects;				/* number of sectors last read */
int	chars;				/* count of chars in buffer */
int	i,j,k;				/* scratch integers */

main(argc,argv)				/* main entry */
char	**argv;				/* arg vector */

{

/*
   --> Check syntax.
*/

	if (argc != 3) {
	  puts("Usage: APPEND <file1> <file2> ; file 2 appends to file 1\r");
	  exit();
	}

/*
   --> Open both files...exit if either does not exist.
*/

	if ((fd1 = open(argv[1],2)) == ERROR) {
	  printf("%s - file not found.\r",argv[1]);
	  exit();
	}

	if ((fd2 = open(argv[2],2)) == ERROR) {
	  printf("%s - file not found.\r",argv[2]);
	  exit();
	}

/*
  --> Determine the size of both files (in sectors).
*/

	fs1 = fs2 = 0;

#if CPM2X
	fs1 = rfsize(argv[1]);
	fs2 = rfsize(argv[2]);
#else
	fs1 = sfsize(argv[1]);
	fs2 = sfsize(argv[2]);
#endif

/*
  --> Seek to the last sector of file 1 and search for the eof character
*/

	--fs1;
	if (seek(fd1, fs1, 0) == ERROR) {
	  puts("\nSeek error (file1).");
	  exit();
	}

	if (read(fd1, buf1, 1) == ERROR) {
	  puts("\nRead error (file1).");
	  exit();
	}

	for (i=0; i<128; i++) {
	  if (buf1[i] == CPMEOF)
	    break;
	}

/*
  --> Seek to the start of file2 and do the append
*/

	if (seek(fd2, 0, 0) == ERROR) {
	  puts("\nSeek error (file2).");
	  exit();
	}

	seek(fd1, fs1, 0);
	k = i;
	while (nsects = read(fd2, buf2, BUFSECTS)) {
	  chars = nsects * SECSIZ;
	  for (j=0; j<chars; j++) {
	    buf1[k] = buf2[j];
	    if (buf1[k] == CPMEOF) {
	      break;
	    }
	    k++;
	    if (k == BUFSECTS * SECSIZ) {
	      if(write(fd1, buf1, BUFSECTS) == ERROR) {
		puts("\nWrite error (file1).");
		exit();
	      }
	      k = 0;
	    }
	  }
	}

/*
  --> Take care of the last, perhaps partial, buffer.
*/

	if (k == 0) {
	  if (close(fd1) == ERROR) {
	    puts("\nClose error (file1).");
	  }
	  exit();
	}

	nsects = k/SECSIZ;
	if (nsects * SECSIZ < k) {
	  nsects++;
	}

	if (write(fd1, buf1, nsects) == ERROR) {
	  puts("\nWrite error (file1).");
	  exit();
	}
	
	if (close(fd1) == ERROR) {
	  puts("\nClose error (file1).");
	}
	exit();

}
                                                                                               