     title    'pl/i-80 bit manipulation enhancement subroutines'

;***************************************************************************
;
;    enhanced bit processing for pl/i-80 provided by nine
;    assembly language routines. all entry points treated as
;    pl/i-80 function calls with results returned in an immediate
;    fashion to simplify user interface to these routines.
;
;    entry points include:
;            1) Right rotate of bit(16) value
;            2) Left rotate of bit(16) value
;            3) Right shift of bit(16) value
;            4) Left shift of bit(16) value
;            5) Logical AND of two bit(16) values
;            6) Logical OR of two bit(16) values
;            7) Logical XOR of two bit(16) values
;            8) Bit to hex/ASCII conversion
;            9) Hex/ASCII to bit conversion
;
;    written by:
;            Michael J. Karas
;            Micro Resources
;            2468 Hansen Court
;            Simi Valley, California 93065
;            (805) 527-7922
;
;*****************************************************************************
; 
;general purpose subroutines used for entry parameter reference
;
;
;get byte entry parameter to register (C)
;
getp1:
	mov	e,m	;low address of parm
	inx	h
	mov	d,m	;high address of parm
	inx     h
	xchg		;parm ptr to (hl) & current
			;..next table ptr to (de)
	mov	c,m	;single parameter to (c)
	xchg		;restore (hl) table ptr for
	ret		;..next parameter fetch
;
;
;get word entry parameter to (BC)
;
getp2:
	call	getp1	;get low parameter byte in (C)
	inx	d	;bump parameter pointer
	                ; ..still valid from getp1
	ldax    d       ;get high parm byte value
	mov     b,a     ;put high to (B)
	ret     
;
;
;fetch parameter sequence bit(16) and bin fixed(7) masked to
;four placees to (DE) and (B) respectively
;
gbitcnt:
	call	getp2	;fetch our bit string
	push	b	;save
	call	getp1	;get count
	mvi	a,0fh	;mask to 16 counts
	ana	c
	mov	b,a	;count to (B)
	pop	d	;bit string to (DE)
	ret
;
;
;fetch parameter sequence bit(16) and bit(16) to
;(DE) and (BC) respectively
;
gbitbit:
	call	getp2	;fetch first bit string
	push	b	;save
	call	getp2	;get second bit value
	pop	d	;first parm to (BC)
	ret 
;
;
;***********************************************************************
;
; function number 1 : right rotate bit(16) value n places
;
         public rtrot
;
; entry,
;        bit(16) value string to be right rotated
;        bin fixed(7) value number of places to right
; returns,
;        right rotated bit(16) value as a function call
;
rtrot:
	call	gbitcnt	;fetch parameters
rtrotl:
	mov	a,e	;get lab of low to carry
	rrc
	mov	a,d	;rotate top byte
	rar		;..lsb of D to carry
	mov	d,a	;put high byte back
	mov	a,e	;rotate low byte
	rar		;..moving carry in
	mov	e,a 	
	dcr	b	;dec rotate count
	jnz	rtrotl	;? more to do
	xchg		;result to (hl) for return
	ret
;
;
;*********************************************************************
;
;  function number 2 : left rotate bit(16) value n places
;
         public lfrot
;
;  entry,
;        bit(16) value to be left rotated
;        bin fixed(7) value number of places to left
;  returns,
;        left rotated bit(16) value as a function call
lfrot:
	call	gbitcnt	;fetch parameters
lfrotl:
	mov	a,e	;get msb of low to carry
	rlc
	mov	a,d	;rotate top byte
	ral		;..msb of D to carry
	mov	d,a	;put high byte back
	mov	a,e	;rotate low byte
	ral		;..moving carry in
	mov	e,a	 
	dcr	b	;dec rotate count
	jnz	lfrotl	;? more to do
	xchg		;result to (hl) for return
	ret
;
;
;*********************************************************************
;
;  function number 3 : right shift bit(16) value n places
;
        public rtsft
;
;  entry,
;       bit(16) value string to be right shifted
;       bin fixed(7) value number of places to right
;  returns,
;       right shifted bit(16) value as a function call
;
rtsft:
	call	gbitcnt	;fetch parameters
rtshtl:
	ora	a	;clear carry for zero fill
	mov	a,d	;shift top byte
	rar		;..lsb of D to carry
	mov	d,a	;put high byte back
	mov	a,e	;shift low byte
	rar		;..moving carry in
	mov	e,a
	dcr	b	;dec shift count
	jnz	rtshtl	;? more to do
	xchg		;result to (hl) for return
	ret
;
;
;***************************************************************************
;
;  function number 4 : left shift bit(16) value n places
;
        public lfsft
;
;  entry,
;       bit(16) value to be left shifted
;       bin fixed(7) value number of places to left
;  returns,
;       left shifted bit(16) value as a function call
;
lfsft:
	call	gbitcnt	;fetch parameters
lfshtl:
	ora 	a	;clear carry for zero fill
	mov	a,e	;shift low byte
	ral		;..msb of E to carry
	mov	e,a	;put low byte back
	mov	a,d	;shift high byte
	ral		;..moving carry in
	mov	d,a	
	dcr	b	;dec rotate count
	jnz	lfshtl	;? more to do
	xchg		;result to (hl) for return
	ret
;
;
;*************************************************************************
;
;  function number 5 : bitwise and two bit(16) values
;
        public bitand
;
;  entry,
;       two bit(16) values to logically AND
;  returns,
;       result as bit(16) value like a function call
;
bitand:
	call	gbitbit	;fetch two parms
	mov	a,b	;do top two bytes
	ana	d
	mov	h,a
	mov	a,c	;now low two bytes
	ana	e
	mov	l,aa
	ret
;
;
;*************************************************************************
;
;  function number 6 : bitwise or two bit(16) values
;
        public bitor
; 
;  entry,
;       two bit(16) values to logically OR
;  returns,
;       result as bit(16) value like a function call
;
bitor:
	call	gbitbit	;fetch two parms
	mov	a,b	;do top two bytes
	ora	d
	mov	h,a
	mov	a,c	;now low two bytes
	ora	e
	mov	l,a
	ret
;
;
;************************************************************************

;
;
;  function number 7 : bitwise exclusive or of two bit(16) values
;
        public bitxor
;
;  entry,
;       two bit(16) values to logically XOR
;  returns,
;       result as bit(16) value like a function call
;
bitxor:
	call	gbitbit	;fetch two parms
	mov	a,b	;do top two bytes
	xra	d
	mov	h,a
	mov	a,c	;now low two bytes
	xra	e
	mov	l,a
	ret
;
;
;*************************************************************************
;
;  function number 8 : convert bit value to hex ascii
;
        public bitasc
;
;  entry,
;       bit(16) value whose upper four bits
;       are hex nibble converted to a hex ascii representation
;  returns,
;       resulting char(1) returned as a function call
;
bitasc:
	call	getp2	;get pit string to (BC)
	mov	a,b	;position high nibble
	rrc
	rrc
	rrc
	rrc
	ani	0fh	;low nibble only
	adi	090h	;use famous 6 byte conversion
	daa
	aci	040h	 
	daa
	pop	h	;get pli/80 return address
	push	psw	;char to stack
	inx	sp	;ignore flags
	mvi	a,1	;one char size
	push	h	;return address back to stack
	ret
;
;
;**************************************************************************
;
;  function number 9 : convert hex ascii to bit value
;
        public ascbit
;
;  entry,
;       char(1) ascii character value that is
;       converted to a bit(16) value with the upper four
;       bits corresponding to the hex/ascii character
;  returns,
;       bit(16) value as a function call
;
ascbit:
	call	getp1	;get character to (C)
	mov	a,c
	sui	'0'	;base at zero
	cpi	010	;need offset adjust?
	jc	ascl
	sui	07h
ascl:
	ani	0fh	;mask to four bits
	rlc		;move to upper nibble
	rlc
	rlc
	rlc
	mov	h,a
	mvi	1,0	;zero lower bits
	ret
;
	end
;
;
;+++...end of file plibits.asm
                                                                                                                                                                                                                                                                                                                                                                                                