	TITLE	'Dual Clock CLK-24 Subroutines'
; The following routines read the time & date from the DUAL CLK-24
; and are designed to be called from high-level languages
;
;	Port Equates for Clock Board
clock	EQU	068H		;addr of data register
control	EQU	069H		;add ress of control register

	public	?date		;leaves ascii date at ADATE
	public	?time		;leaves ascii time at ATIME
	public	adate		;ascii date field
	public	atime		;ascii time field
	public	hdate		;hex date field
	public	htime		;hex time field
	public	rddate		;read date (hex)
	public	rdtime		;read time (hex)

; Read date and convert to ascii char(13) string 'Day dd-Mon-yy'
;	Uses:	HL, DE - not restored

?date:	lxi	h,hdate		;Where to store date in hex
	call	rddate		;Read date

dow:	lxi	h,hdate+6	;point to day of week
	mov	a,m		;Day of week digit
	rlc			;*2
	rlc			;*4
	mov	c,a		;Get offset for ascii
	mvi	b,0		;.. day of week to BC
	lxi	h,weekday
	dad	b		;HL now points to proper day of week
	mvi	b,4
	lxi	d,adate		;Point to ascii storage region
	call	move		;Move day of week to adate

	lxi	h,hdate+4	;point to day10
	mov	a,m		;get day10 digit
	ani	03h		;mask leap year bit
	mov	m,a		;store it back
	lxi	d,day		;where to store days
	call	cpair		;convert days

m10:	lxi	h,hdate+2	;point to month10
	mov	a,m		;get month10 digit
	cpi	0		;check for zero- skip
	jz	m1
	rlc			;*2
	mov	b,a		;save 2*
	rlc			;*4
	rlc			;*8
	add	b		;Acc=10*m10

m1	inx	h		;point to month1 digit
	add	m		;add month1 digit to acc
	dcr	a		;offset=
	rlc			; 4*(month-1)
	rlc			;*4 cause each month has 4 chars
	mov	c,a
	mvi	b,0

	lxi	h,months
	dad	b
	mvi	b,4
;	lxi	d,mon		;DE still -> month field
	call	move

	lxi	h,hdate+0	;point to year
	call	cpair		;convert year
	ret
   
; Read time & convert to ascii char(8) string 'hh:mm:ss' at htime
;	Uses: HL, DE (not restored)

?time:	lxi	h,htime		;Where to store time in hex
	call	rdtime		;Read it
	lxi	d,atime		;Where to store time in ASCII
	mov	a,m		;Get hours10 digit (HL still points to it)
	ani	03H		;Mask AM/PM bit
	mov	m,a		;Store it back
	call	cpair		;Convert hours
	call	cpair		;Convert minutes
	call	cpair		;Convert seconds
	ret

cpair:	call	cdigit		;10s digit
	call	cdigit		; 1s digit
	inx	d		;skip delimeter
	ret

cdigit:	mov	a,m		;Get hex digit
	call	conv		;Convert it to ASCII
	xchg			;HL <- dest
	mov	m,a		;Store ascii digit
	xchg			;Restore HL
	inx	h		;bump htime ptr
	inx	d		;bump dest  ptr
	ret

;-----------------------------------------------------------
; rddate - Read and store the date
;	Entry:  HL = address to store the date (hex)
;	Exit:	HL restored / DE consumed

rddate:	push	h		;Save dest addr
	lxi	d,datecmd
	mvi	b,7		;7 digits to read
	call	rdclock		;Read them
	pop	h		;Restore starting dest addr
	ret

;------------------------------------------------------------
; rdtime - Read and store the time
;	Entry:  HL = address to store the time (hex)
;	Exit:	HL restored

rdtime:	push	h		;Save dest addr
	lxi	d,timecmd
	mvi	b,6		;6 time digits
	call	rdclock		;Read them
	mvi	a,40H		;Send clear code
	out	control		;to say done reading
	pop	h		;Restore starting dest addr
	ret
;
;-----------------------------------------------------------
; rdclock - read a set of digits from the CLK-24 board
;	Entry: B = number of digits to read
;	       HL-> destination
;	       DE-> string of command digits
;	Exit:  B = 0
;	       HL-> past last digit
rdclock:
	ldax	d	;Get command code to Acc
	call	digit	;read the digit
	mov	m,a	;store it
	inx	h	;bump destination pointer
	inx	d	;bump command pointer
	dcr	b
	jnz	rdclock
	ret

;---------------------------------------------------------------
; digit - read a digit from the CLK-24 board
;	Entry: ACC = clock control command for desired digit
;	Exit:  ACC = clock digit in ASCII
;		Returns with carry set if invalid digit (no board in system)

digit:	call	rdigit		;Read the digit
	cpi	0FH		; Check validity
;	jnc	nobrd		; Invalid if digit > 0FH
	ret			; return with digit in Acc

;nobrd:			;Arrive here if no CLK board in system
;	pop	h		;Adjust the stack
;	jmp	done		;Exit clock routine

; The only critical timing consideration when programming
; the CLK-24 in assembly language is to be sure that you 
; allow at least 6 microseconds between outputting to the
; control port and inputting a digit from the data port.
;Delays are adequate for 4 MHz Z80s.

;	Entry: Acc = clock control code (0..12) for desired digit

rdigit:	out	control		;Send clock control code to CLK board
	nop			;Waste..
	nop			; ..some
	nop			; ..time
	nop			; (6 microsec for Z80 @ 4MHz)
	in	clock		;Read the digit
	ret			; Return it in Acc


CONV:	ADI	'0'		;Convert Hex in Acc to Ascii
	CPI	'9'
	RM	
	RZ
	ADI	07H
	RET

;-----------------------------------------------------------
; move a string
;	Entry:	HL -> source
;		DE -> dest
;		B = count

move:	mov	a,m		;get a byte
	stax	d		;store it
	inx	h		;bump hl
	inx	d		;bump de
	dcr	b
	rz			;done if b=0
	jmp	move

	dseg
hdate:	db	'YYMMDDW'	;Storage for date (binary/hex) 
htime:	db	'HHMMSS'	;Storage for time (binary/hex) 

adate:	db	'Day '
day:	db	'dd-'
mon:	db	'Mon-'
yr:	db	'81 '
adlen	equ	$-adate		;length of ascii date field

atime:	db	'hh:'
	db	'mm:'
	db	'ss '
atlen	equ	$-atime		;length of ascii time field
adtln	equ	$-adate		;length of date-time field
	db	' $'

	dseg		;DATA AREA
datecmd:
;		Yr10	Yr1	Mon10	Mon1	Day10	Day1	Weekday
	db	12,	11,	10,	9,	8,	7,	6

timecmd:
;		Hr10	Hr1	Min10	Min1	Sec10	Sec1
	db	5,	4,	3,	2,	1,	0
weekday:
	db	'Sun ','Mon ','Tue ','Wed ','Thu ','Fri ','Sat '

months:	db	'Jan-','Feb-','Mar-','Apr-','May-','Jun-'
	db	'Jul-','Aug-','Sep-','Oct-','Nov-','Dec-'
	END
                                                                                                                                                                                                                                                                                                                                                                