10 REM		financial analysis by ratios
20 REM		variables:
30 REM		act(i)		short term assets, period i
40 REM		ax		total assets
50 REM		baf(i)		after-tax profits
60 REM		bb(i)		gross margin on sales
70 REM		bnb(i)		net income before taxes
80 REM		cp(i)		owners' equity
90 REM		db(i)		receivables
100 REM		dct(i)		current liabilities
110 REM		det(i)		total liabilities
120 REM		dlt(i)		long term liabilities
130 REM		ff(i)		operating expenses
140 REM		imm(i)		fixed assets
150 REM		ipt		income taxes
160 REM		n		number of years to analyze
170 REM		stk(i)		inventory
180 REM		ven(i)		total sales
190 REM		w(i)		transition array for graphs
200 REM		ra(i)->		arrays of ratios
210 REM		rj(i)		(see lines 1080 to 1220)
220 REM
230 PRINT : PRINT : PRINT
240 PRINT "financial ratio analysis"
250 PRINT "--------- ----- --------"
260 PRINT : PRINT : PRINT
270 REM
280 REM		input data
290 GOSUB 390
300 REM		calculate resulting accounting values
310 GOSUB 740
320 REM		calculate the ratios
330 GOSUB 840
340 REM		print the results
350 GOSUB 1000
360 REM		plot the graphs
370 GOSUB 1470
380 END
390 REM		input of data
400 INPUT "** number of years to analyze ";N
410 PRINT : PRINT
420 DIM ACT(N),STK(N),DB(N),IMM(N),DCT(N)
430 DIM DLT(N),CP(N),VEN(N),BB(N),FF(N)
440 DIM AX(N),DET(N),BNB(N),BAF(N)
450 DIM RA(N),RB(N),RC(N),RD(N),RE(N),RF(N)
460 DIM RG(N),RI(N),RJ(N)
470 FOR I = 1 TO N
480 PRINT "** input the data for year #";I
490 PRINT
500 PRINT "   assets:"
510 PRINT "   -------"
520 INPUT "   short term assets  ";ACT(I)
530 INPUT "   inventory          ";STK(I)
540 INPUT "   receivables        ";DB(I)
550 INPUT "   fixed assets       ";IMM(I)
560 PRINT : PRINT
570 PRINT "   liabilities:"
580 PRINT "   ------------"
590 INPUT "   current liabilities    ";DCT(I)
600 INPUT "   long-term liabilities  ";DLT(I)
610 INPUT "   owners' equity         ";CP(I)
620 PRINT : PRINT
630 PRINT "   sales data:"
640 PRINT "   ----- -----"
650 INPUT "   total sales            ";VEN(I)
660 INPUT "   gross margin on sales  ";BB(I)
670 INPUT "   operating expenses     ";FF(I)
680 PRINT : PRINT
690 NEXT I
700 PRINT
710 INPUT "   tax rate (%) on income ";IPT
720 PRINT : PRINT : PRINT
730 RETURN
740 REM		calculate resulting data
750 FOR I = 1 TO N
760 AX(I) = ACT(I) + IMM(I)
770 DET(I) = DCT(I) + DLT(I)
780 REM		net profit before taxes
790 BNB(I) = BB(I) - FF(I)
800 REM		profit after taxes
810 BAF(I) = BNB(I) - BNB(I) * (IPT / 100)
820 NEXT I
830 RETURN
840 REM		calculate the ratios
850 DEF FN R(X) = INT (100 * X + .5) / 100
860 DEF FN P(X) = INT (100 * X + .5)
870 FOR I = 1 TO N
880 RA(I) = FN R(ACT(I) / DCT(I))
890 RB(I) = FN R((ACT(I) - STK(I)) / DCT(I))
900 RC(I) = FN P(DET(I) / AX(I))
910 RD(I) = FN R((BB(I) + FF(I)) / FF(I))
920 RE(I) = FN R(VEN(I) / STK(I))
930 RF(I) = INT ((DB(I) / (VEN(I) / 360)) + .5)
940 RG(I) = FN R(VEN(I) / IMM(I))
950 RH(I) = FN R(VEN(I) / AX(I))
960 RI(I) = FN P(BAF(I) / VEN(I))
970 RJ(I) = FN P(BAF(I) / AX(I))
980 NEXT I
990 RETURN
1000 REM		string initializations
1010 GOSUB 1310
1020 REM		print results for last year.
1030 I = N
1040 Y = 28
1050 PRINT "principal ratios for the last year"
1060 PRINT "--------- ------ --- --- ---- ----"
1070 PRINT : PRINT
1080 PRINT "liquidity ratios"
1090 PRINT "--------- ------"
1100 PRINT RA$; TAB( Y);"= ";RA(I);" times"
1110 PRINT RB$; TAB( Y);"= ";RB(I);" times"
1120 PRINT
1130 PRINT "leverage ratios"
1140 PRINT "-------- ------"
1150 PRINT RC$; TAB( Y);"= ";RC(I);"%"
1160 PRINT RD$; TAB( Y);"= ";RD(I);" times"
1170 PRINT : PRINT "management ratios"
1180 PRINT "---------- ------"
1190 PRINT RE$; TAB( Y);"= ";RE(I);" times"
1200 PRINT RF$; TAB( Y);"= ";RF(I);" days"
1210 PRINT RG$; TAB( Y);"= ";RG(I);" times"
1220 PRINT RH$; TAB( Y);"= ";RH(I);" times"
1230 PRINT
1240 PRINT "profitability ratios"
1250 PRINT "------------- ------"
1260 PRINT RI$; TAB( Y);"= ";RI(I);"%"
1270 PRINT RJ$; TAB( Y);"= ";RJ(I);"%"
1280 PRINT
1290 PRINT : INPUT "continue ";C$
1300 RETURN
1310 REM	ratio names -- string initialization
1320 RA$ = "- general"
1330 RB$ = "- immediate"
1340 RC$ = "- debts to assets"
1350 RD$ = "- coverage of costs"
1360 RE$ = "- inventory turnover"
1370 RF$ = "- av. collection time"
1380 RG$ = "- fixed asset turnover"
1390 RH$ = "- totl asset turnover"
1400 RI$ = "- profit margin"
1410 RJ$ = "- r.o.i."
1420 R1$ = "- liquidity ratios"
1430 R2$ = "- leverage ratios"
1440 R3$ = "- mangmt ratios"
1450 R4$ = "- profitability ratios"
1460 RETURN
1470 REM	graphics subroutine
1480 IF N = 1 THEN 1800 : PRINT : PRINT : PRINT
1490 PRINT : PRINT : PRINT
1500 PRINT "graphic analysis of ratios"
1510 PRINT "------- -------- -- ------"
1520 PRINT R1$; TAB( Y);"type <1>": PRINT R2$; TAB( Y);"type <2>"
1530 PRINT R3$; TAB( Y);"type <3>": PRINT R4$; TAB( Y);"type <4>"
1540 PRINT "  no graphics"; TAB( Y);"type <5>";
1550 INPUT C9 : PRINT : PRINT : ON C9 GOTO 1560,1610,1660,1750,1800
1560 PRINT R1$;"  ";RA$ : F$ = " times"
1570 FOR I = 1 TO N : W(I) = RA(I) : NEXT I : GOSUB 1810
1580 PRINT R1$;"  ";RB$
1590 FOR I = 1 TO N : W(I) = RB(I) : NEXT I : GOSUB 1810
1600 GOTO 1490
1610 PRINT R2$;"  ";RC$ : F$ = "%"
1620 FOR I = 1 TO N : W(I) = RC(I) : NEXT I : GOSUB 1810
1630 PRINT R2$;" ";RD$ : F$ = " times"
1640 FOR I = 1 TO N : W(I) = RD(I) : NEXT I : GOSUB 1810
1650 GOTO 1490
1660 PRINT R3$;" ";RE$
1670 FOR I = 1 TO N : W(I) = RE(I) : NEXT I : GOSUB 1810
1680 PRINT R3$;" ";RF$ : F$ = " days"
1690 FOR I = 1 TO N : W(I) = RF(I) : NEXT I : GOSUB 1810
1700 PRINT R3$;" ";RG$ : F$ = " times"
1710 FOR I = 1 TO N : W(I) = RG(I) : NEXT I : GOSUB 1810
1720 PRINT R3$;" ";RH$
1730 FOR I = 1 TO N : W(I) = RH(I) : NEXT I : GOSUB 1810
1740 GOTO 1490
1750 PRINT R4$;" ";RI$ : F$ = "%"
1760 FOR I = 1 TO N : W(I) = RI(I) : NEXT I : GOSUB 1810
1770 PRINT R4$;" ";RJ$
1780 FOR I = 1 TO N : W(I) = RJ(I) : NEXT I : GOSUB 1810
1790 GOTO 1490
1800 RETURN
1810 REM	graphics output subroutine
1820 C = 0 : MI = W(1) : MAX = W(1)
1830 FOR I = 1 TO N : C = C + W(I)
1840 IF W(I) < MI THEN MI = W(I)
1850 IF W(I) > MAX THEN MAX = W(I)
1860 NEXT I
1870 AV = INT (100 * (C / N + .5)) / 100 : B = MAX + 10 : A = MI - 10
1880 PRINT "year" : PRINT "   i"
1890 FOR I = 1 TO N
1900 PRINT I; TAB( 4);"i"; TAB((W(I) - A) * (32 / (B - A)) + 6);"*"
1910 PRINT "   i": NEXT I
1920 PRINT TAB( 4) : FOR X = 1 TO 32 : PRINT "-"; : NEXT X : PRINT
1930 X = 0 : FOR I = A TO B STEP 10
1940 PRINT TAB( X * 32 * (10 / (B - A)) + 5); INT (I);
1950 X = X + 1 : NEXT I
1960 PRINT F$ : PRINT
1970 FOR I = 1 TO N : PRINT TAB( 5);I;"= ";W(I); : NEXT I : PRINT
1980 PRINT TAB( 5);"high=";MAX;" ";"low=";MI;" ";"average=";AV
1990 PRINT : PRINT : INPUT "continue  ";C$
2000 REM
2010 FOR T = 1 TO 15 : PRINT : NEXT T
2020 RETURN
I;" ";"average=";AV
1990 PRINT : PRINT : I                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                