;	
;	WSMODS.ASM
;
;===========================================================|
;							    |	
;	Published by the Portable Companion, 1982	    |			
;	Routines by Thom Hogan, Osborne Computer Corp.      |
;	Corrections from the original by Al Frazer	    |
;					 70045,441
;							    |	
;___________________________________________________________|
;
;	Definitions
;
TRUE	EQU	1
FALSE	EQU	NOT TRUE
;
SMOOTH	EQU	TRUE	;If TRUE, smooth scrolling implemented
HILITE	EQU	FALSE	;If TRUE, underlined video selected for hilite
WIDE	EQU	TRUE	;If TRUE, 128 character width, else 80
;
CURSOR	EQU	0EF5AH	;Location of cursor in BMRAM
IOUT	EQU	0106H	;Location of output routine in WordStar 2.26
ESCAPE	EQU	27	;ASCII code of <ESC>
SCREEN	EQU	0F000H	;Screen memory address
			;(not originally defined <AF>)
;
;	TERMINAL PATCH AREA
;
	ORG	0248H	;Origin of WordStar terminal patch area
HITE	DB	24	;24 lines on screen
	IF	WIDE
WID	DB	128	;128 columns on screen
	ENDIF
	IF	NOT WIDE
WID	DB	80	;80 columns on screen
	ENDIF

CLEAD1	DB	2,ESCAPE,'='	;Cursor positioning routine
	DB	0,0,0,0,0,0	;Room for expansion
CLEAD2	DB	0,0,0,0,0	;Function not used by Osborne 1
CTAIL	DB	0,0,0,0,0	;Function not used by Osborne 1
CB4FLG	DB	0		;Function nos used by Osborne 1
LINOFF	DB	32		;Line offset amount
COLOFF	DB	32		;Column offset amount
ASCUR	DB	0,0,0,0		;Function not used by Osborne 1

	IF	SMOOTH
UCRPOS	JMP	WCUR		;Get cursor position
	ENDIF
	IF	NOT SMOOTH
UCRPOS	DB	0,0,0C9H	;Not used of terminal emulated
	ENDIF

	DW	IOUT		;WordStar output routine
	DB	0,0,0,0		;Reserved bytes
ERAEOL	DB	2,ESCAPE,54H	;Erase to end of line sequence
	DB	0,0,0,0		;Room for expansion
LINEDEL	DB	2,ESCAPE,52H	;Delete line sequence
	DB	0,0,0,0		;Room for expansion
LININS	DB	2,ESCAPE,45H	;Insert line sequence
	DB	0,0,0,0,0,0	;Room for expansion
IVON	DB	2,ESCAPE,29H	;Highlighting ON sequence
	DB	0,0,0,0		;Room for expansion
IVOFF	DB	2,ESCAPE,28H	;Highlighting OFF sequence
	DB	0,0,0,0		;Room for expansion
TRMINI	DB	8,'O C C -1'
TRMUNI	DB	8,'O C C -1'
INISUB	JMP	ITERM		;Initialize terminal routine
UNISUB	JMP	XTERM		;End of session terminal routine
USELST	DB	1		;Enable character in last position to show
	DB	0,0,0		;Reserved bytes for expansion
DELCUS	DB	5		;Delay after cursor set
DELMIS	DB	3		;Delay after other functions
;
; The following section contains the primary code which implements
; smooth scrolling on the Osborne 1.  Be careful when modifying this 
; section.
;
	IF	SMOOTH
MEMAPV	DB	1		;Use memory-mapped video
MEMADR	DW	SCREEN		;Screen location
				;(originally DB <AF>)
	ENDIF
	IF	NOT SMOOTH
MEMAPV	DB	0		;Use terminal drivers
MEMADR	DB	0,0		;No memory address needed
	ENDIF

	IF	HILITE
HIBIV	DB	80H		;Use underline
	ENDIF
	IF	NOT HILITE
HIBIV	DB	00H		;No highlighting
	ENDIF
HIBCUR	DB	80H		;Cursor set on self
CRBLIV	DB	0FFH		;Blink cursor on self
ZAFCIN	DW	0		;Not needed for Osborne 1
RUBFXF	DB	0		;Not needed for Osborne 1
RFIXER	DB	0		;Not needed for Osborne 1

	IF	SMOOTH
UCNSTA	JMP	0E506H		;Get console status from BIOS
UCONI	JMP	INCON		;Get console input
UCONO	JMP	OUTCON		;Send console output
	ENDIF
	IF	NOT SMOOTH
UCNSTA	DB	0,0,0C9H		;No special status routine
UCONI	DB	0,0,0C9H		;No special input routine
UCONO	DB	0,0,0C9H		;No special output routine
	ENDIF
SWIN	DB	0C9H,0,0,0,0,0	;No special before video routine
SWOUT	DB	0C9H,0,0,0,0,0	;No special after video routine
DEL1	DB	3		;Short delay
DEL2	DB	9		;Medium-short delay
DEL3	DB	25		;Medium-long delay
DEL4	DB	64		;Long delay
;
;	SPECIAL ROUTINES FOR OSBORNE 1
;	Not part of MicroPro patch items
;
	ORG	02D6H		;Origin of special patch area
;
; Initialization of terminal routine
;
ITERM	MVI	A,26		;Clear screen code in A
	CALL	UCONO		;Send it
	RET			;Done
;
; Finalization of terminal routine
;
XTERM	RET			;Just get out
;
; Input from console routine
;
INCON	CALL	0E509H		;Get a character
;	MOV	A,C		;Put it in A where WordStar can use it
	NOP			;(previous instruction unnecessary <AF>)
	RET			;Done
;
; Output from console routine
;
OUTCON	MOV	C,A		;Get it in C where CP/M can use it
	JMP	0E50CH		;Send it and return directly
;
; Position cursor by brute force in BMRAM
;
WCUR	LXI	H,0F000H	;Put screen start in HL register
	DAD	D		;Add position of cursor in DE to HL
	SHLD	CURSOR		;Save new cursor position
	RET
;
; Special automatic scrolling routines
; These routines are coded in Z80 assembly language,
; so we'll just patch in the hex values at this point.
;
X1BB4	DB	0D9H,000H,000H,0AFH,018H,011H
X30D2	DB	0D9H,000H,000H,03AH,01EH,037H
	DB	0D6H,02AH,030H,001H,0AFH,0FEH
	DB	04CH,038H,002H,03EH,04CH,0C6H
	DB	020H,032H,019H,003H,021H,016H
	DB	003H,0CDH,01BH,003H,0D9H,000H
	DB	000H,0C3H,0BBH,01BH,01BH,053H
	DB	020H,020H,000H,07EH,0B7H,0C8H
	DB	023H,0E5H,0CDH,0E2H,002H,0E1H
	DB	018H,0F5H,000H,000H
;
; For those who must have the code that the above bytes of
; data represent, here it is:
;
;X1BB4	proc
;	EXX
;	XOR	A	;Reset bias
;	JR	:2
;
;X30D2	EXX
;	LD	A,371EH	;Get WordStar's column
;	SUB	52-10	;See if past 42
;	JRNC	:1	;if past 42
;	XOR	A	;Reset to far left
;:1	CMP	128-52
;	JRC	:2	;if way before right edge
;	LDK	A,128-52	
;:2	ADD	A,' '	;Position bias
;	STO	A,:X
;	LDK	HL,:S
;	CALL	OSTR	;Output screen positioning
;	EXX
;	JMP	1BBBH	;Back to WordStar
;:S:	DB	ESCAPE,'S'
;	DB	' '	;Y Position
;:X:	DB	' '	;X Position
;	DB	EOS	;End of sentence
;OSTR	LD	A,[HL]
;	OR	A
;	RZ		;if EOS
;	INC	HL
;	PUSH	HL
;	CALL	OUTCON  ;Output a byte
;	POP	HL
;	JR	OSTR	;Do until done
;
; This code will assemble with Sorcim's ACT I assembler
;
IF	SMOOTH
ORG	1BB4H	;Input prompt/command response in WordStar
CALL	X1BB4

ORG	30D2H	;Input data character
JMP	X30D2
ENDIF

END

ORG	1BB4H	;Input prompt/command response in WordStar
CALL	X1BB4

ORG	30D2