;-----------------------------------------------;
;						;
;	Z80 RESIDENT ASSEMBLER			;
;						;
;-----------------------------------------------;
;						;
;	(C) 1977  LEHMAN CONSULTING SERVICES	;
;						;
;	ALL RIGHTS RESERVED			;
;						;
;-----------------------------------------------;
;						;
;	OPCODE TABLE MODULE			;
;						;
;-----------------------------------------------;
;						;
;	REV 0	15-JULY-77	MGL		;
;	REV 1   20-OCT-77	MGL		;
;						;
;-----------------------------------------------;
;
;
	ORG	1F80H		;****** ADDRESS EQUATE ******
;
;
;	EJECT
;
;
;	EACH SYMBOL TABLE ENTRY IS OF VARYING LENGTH
;
;	THE FIRST BYTE CONTAINS THE LENGTH IN THE LOWER 4 BITS
;	AND FLAGS IN THE UPPER 4 BITS.
;
;	THIS LIMITS THE MAX LENGTH OF AN ENTRY TO 15 BYTES
;
;	FOLLOWING THE FLAG/LENGTH BYTE IS THE NAME WHICH MAY BE FROM
;	1 TO 11 BYTES IN LENGTH
;
;	FOLLOWING THE NAME ARE 2 BYTES OF VALUE (LO,HI)
;	AND 1 BYTE OF TYPE (USED IN OPCODES)
;
;
;	THE TABLE IS SCANNED SEQUENTIALLY AND IS ENDED BY A 0 BYTE
;
;
SYM	EQU	$
;
;
;
;	FLAG EQUATES
;
RNAME	EQU	20H	;REGISTER NAME FLAG
ULBL	EQU	40H	;USER LABEL FLAG
RPNAME	EQU	80H	;REGISTER PAIR NAME FLAG
;
;
;	EJECT
;
;
;	SYMBOL TABLE
;
;
	DW	SYMNXT		;SYMBEG
	DW	CONDS		;SYMCND
	DB	7,'EXX',0D9H,0,1
	DB	7,'LDI',0EDH,0A0H,1
	DB	8,'LDIR',0EDH,0B0H,1
	DB	7,'LDD',0EDH,0A8H,1
	DB	8,'LDDR',0EDH,0B8H,1
	DB	7,'CPI',0EDH,0A1H,1
	DB	8,'CPIR',0EDH,0B1H,1
	DB	7,'CPD',0EDH,0A9H,1
	DB	8,'CPDR',0EDH,0B9H,1
	DB	7,'DAA',27H,0,1
	DB	7,'CPL',2FH,0,1
	DB	7,'NEG',0EDH,040H,1
	DB	7,'CCF',03FH,0,1
	DB	7,'SCF',037H,0,1
	DB	7,'NOP',0,0,1
	DB	8,'HALT',76H,0,1
	DB	6,'DI',0F3H,0,1
	DB	6,'EI',0FBH,0,1
	DB	7,'IM0',0EDH,46H,1
	DB	7,'IM1',0EDH,56H,1
	DB	7,'IM2',0EDH,5EH,1
	DB	8,'RLCA',07H,0,1
	DB	7,'RLA',17H,0,1
	DB	8,'RRCA',0FH,0,1
	DB	7,'RRA',1FH,0,1
	DB	8,'RETI',0EDH,4DH,1
	DB	8,'RETN',0EDH,45H,1
	DB	7,'INI',0EDH,0A2H,1
	DB	8,'INIR',0EDH,0B2H,1
	DB	7,'IND',0EDH,0AAH,1
	DB	8,'INDR',0EDH,0BAH,1
	DB	8,'OUTI',0EDH,0A3H,1
	DB	8,'OTIR',0EDH,0B3H,1
	DB	8,'OUTD',0EDH,0ABH,1
	DB	8,'OTDR',0EDH,0BBH,1
	DB	6,'LD',0,0,8
	DB	7,'RLC',0,0,2
	DB	6,'RL',10H,0,2
	DB	7,'RRC',8,0,2
	DB	6,'RR',18H,0,2
	DB	7,'SLA',20H,0,2
	DB	7,'SRA',28H,0,2
	DB	7,'SRL',38H,0,2
	DB	7,'RLD',0EDH,06FH,1
	DB	7,'RRD',0EDH,067H,1
	DB	8,'PUSH',0C5H,0,9
	DB	7,'POP',0C1H,0,9
	DB	6,'EX',0EBH,0,10
	DB	7,'ADD',0,9,6
	DB	7,'ADC',8,4AH,6
	DB	7,'SBC',18H,42H,6
	DB	7,'SUB',10H,0,6
	DB	7,'AND',20H,0,6
	DB	6,'OR',30H,0,6
	DB	7,'XOR',28H,0,6
	DB	6,'CP',38H,0,6
	DB	7,'INC',04H,03H,13
	DB	7,'DEC',05H,0BH,13
	DB	7,'BIT',040H,0,12
	DB	7,'SET',0C0H,0,12
	DB	7,'RES',80H,0,12
	DB	6,'JP',0C3H,0,3
	DB	8,'CALL',0CDH,0,3
	DB	6,'JR',18H,0,4
	DB	8,'DJNZ',10H,0,4
	DB	7,'RET',0C9H,0,11
	DB	7,'RST',0C7H,0,5
	DB	6,'IN',0DBH,0,7
	DB	7,'OUT',0D3H,0,7
	DB	7,'EQU',1,0,14
	DB	8,'DEFS',2,0,14
	DB	8,'DEFB',3,0,14
	DB	8,'DEFW',4,0,14
	DB	7,'END',5,0,14
	DB	7,'ORG',6,0,14
	DB	9,'EJECT',7,0,14
	DB	7,'IBM',8,0,14	;IBM PSEUDO FOR 3270 (ICC) SCREEN FORMATTING
;
;	REGISTERS
;
	DB	5+RNAME,'A',7,0,0
	DB	5+RNAME,'B',0,0,0 
	DB	5+RNAME,'C',1,0,0
	DB	5+RNAME,'D',2,0,0
	DB	5+RNAME,'E',3,0,0
	DB	5+RNAME,'H',4,0,0
	DB	5+RNAME,'L',5,0,0
	DB	6+RPNAME,'HL',4,0,0
	DB	6+RPNAME,'BC',0,0,0
	DB	6+RPNAME,'DE',2,0,0
	DB	6+RPNAME,'SP',6,0,0
	DB	6+RPNAME,'IX',0FFH,0,0
	DB	6+RPNAME,'IY',0FEH,0,0
	DB	6,'AF',06H,0,0	;FOR PUSH/POP
CONDS	EQU	$
	DB	5,'Z',1,0,0
	DB	6,'NZ',0,0,0
	DB	5,'C',3,0,0
	DB	6,'NC',2,0,0
	DB	6,'PO',4,0,0
	DB	6,'PE',5,0,0
	DB	5,'P',6,0,0
	DB	5,'M',7,0,0
SYMNXT	EQU	$		;FIRST AVAILABLE SLOT
	DB	0
