	TITLE	'LOADER FOR RAMDRIV	12/27/82'
;
;***********************************************************
;
;	RAMLD - Loader program for RAMDRIV, a program
;		that allows extended memory to function
;		as a disk drive
;
;		COPYRIGHT 1982, by
;		Herbert B. Shore
;		Dept. of Physics
;		San Diego State University
;		San Diego, CA 92182
;		(619) 265-6159
;
;		Released to the public domain for
;		non-commercial use.
;
;***********************************************************
;
;  This file and file RAMDRIV.ASM are required to produce
;  the absolute file RAMDRIV.COM.  I assembled them  using
;  the Digital Research MAC assembler with the Z80 macro
;  library.  The following steps should produce a working
;  RAMDRIV.COM :
;
;  (1)  Modify EQU's in RAMDRIV.ASM following instructions
;	in that program.
;  (2)	Set RAMDRIV (in this file) equal to starting
;	address of main program.
;  (3)  Assemble both programs.
;  (4)  Look at file RAMLD.PRN and note the value of
;	ROFFST.  If you haven't modified this program it
;	will be 058DH.
;  (5)  Using DDT, load file RAMLD.HEX with no offset.
;  (6)  Then load RAMDRIV.HEX with an offset of ROFFST.
;  (7)  Exit DDT and do: SAVE 4 RAMDRIV.COM.
;
;
$*MACRO
MACLIB	Z80
RSIZE	EQU	4*256		;SIZE OF RAMDRIV PROG
RAMDRIV	EQU	0FC00H
BDOS	EQU	5
;
	ORG	100H
	LXI	D,SIGNON	;PRINT SIGNON MESSAGE
	MVI	C,9
	CALL	BDOS
	LHLD	1		;HAS BIOS BEEN MODIFIED YET?
	INX	H		;ADDRESS IN BIOS JUMP VECTOR.
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG			;WBOOT ADDR. --> HL
	LXI	D,RAMDRIV	
	ANA	A		;CLEAR CARRY
	DSBC	DE		;WBOOT - RAMDRIV
	JC	CONTIN		;IF CARRY, THEN WE ARE OK.
	LXI	D,NOWAY		;PRINT ERROR MESSAGE
	MVI	C,9
	CALL	BDOS
	JMP	0
;
SIGNON:	DB	'RAMDRIV loader.    Dec. 27, 1982'
	DB	0DH,0AH, '$'
NOWAY:	DB	'Cannot load RAMDRIV.', 0DH,0AH
	DB	'Cold boot system and try again.'
	DB	0DH,0AH, '$'
;
CONTIN:	LXI	H,START		;SOURCE ADDR.
	LXI	D,RAMDRIV	;DESTINATION
	LXI	B,RSIZE
	LDIR
	JMP	RAMDRIV
;
START:
ROFFST	EQU	START-RAMDRIV
	END
ART		;SOURCE ADDR.
	LXI	