{*****************************************************************************}
{                              Martin Stanley                                 }
{                           305 St George Street                              }
{                         Toronto, Ontario M5R-2R2                            }
{                               416 961-4778                                  }
{                                                                             }
{                                                                             }
{                 An implementation of matrix multiplication                  }
{                  using the standard array representation.                   }
{                                                                             }
{           Please report any interseting changes or bugs, etc.               }
{                                                                             }
{*****************************************************************************}
{                                                                             }
{            Copyright 1982 by Martin Stanley all rights reserved.            }
{                                                                             }
{Thi softwar i place i th publi domai fo publi use I i NOԠ t }
{b use i an wa fo financia (monetar o otherwise gai o profi }
{withou m expres writte permission Failur t obtai permissio i a }
{infringement of copyright.                                                  }
{                                                                             }
{*****************************************************************************}
 

                   {NOTE: array dimensions start on index 1}


program matrix1;

const
    m = 4;                      {A's row size, C's row size}
    n = 3;                      {B's row size, A's column size}
    p = 2;                      {B's column size, C's column size}
    tab = ' ';                  {spacing for graphic representation}
    width = 2;                  {print width of largest array dimension}
    testRuns = 20;              {# of runs of problem to obtain average time}
    outputFlag = true;          {true if graphic representation is desired}

var
    A: array [1..m, 1..n] of integer;   {First matrix}
    B: array [1..n, 1..p] of integer;   {Second matrix}
    C: array [1..m, 1..p] of integer;   {Output matrix}
    sum: integer;        {holds the partial and fianl result of each mult.}
    i: 1..m;                            {iteration variables}
    j: 1..p;             
    k: 1..n;
    nonZero: integer;                   {number of non-zero entries}

    loopCost: integer;                  {overhead cost}
    time: integer;                      {hold time values}
    time2: integer;

    test: 1..testRuns;                  {counter for test loop}

    dataA, dataB: text;         {input files for elements of A and B} 


    function clock:integer;             { you will have to make a function to}
                                        { read your clock. If you don't have a}
    begin                               { system clock, you will have to count}
       clock := 0                       { the basic units. This is probably }
    end;                                { more accurate anyway. }


 


 

    procedure initialize;

    var
        inp: integer;           {holds current value of element being read}

    begin {* initialize *}

        writeln('Initializing A');
        reset('testData.2', dataA);
        nonZero := 0;                           {initialize}

        for i := 1 to m do begin                {A's rows}
            if outputFlag then                  {if output desired}
                write('A[', i: width, ']', tab);{row #}
            for k := 1 to n do begin            {A's columns}
                read(dataA, inp);           {get element}
                A[i, k] := inp;                 {set value}
                if inp <> 0 then                {count non-zero elements}
                    nonZero := nonZero + 1;
                if outputFlag then 
                    write(A[i, k]: width, tab)  {write values}
            end;
            if outputFlag then 
                writeln
        end;
        writeln('Array A contains ', nonZero, ' non-zero elements');
        writeln;


        writeln('Initializing B');
        reset('testData.2', dataB);
        nonZero := 0;

        for k := 1 to n do begin                {B's rows}
            if outputFlag then 
                write('B[', k: width, ']', tab);
            for j := 1 to p do begin            {B's columns}
                read(dataB, inp);
                B[k, j] := inp;
                if inp <> 0 then 
                    nonZero := nonZero + 1;
                if outputFlag then 
                    write(B[k, j]: width, tab)
            end;
            if outputFlag then 
                writeln
        end;
        writeln('Array B contains ', nonZero, ' non-zero elements');
        writeln
    end;                                        {* initialize *}




begin {* main *}

    initialize;

                         {find overhead}
    loopCost := clock;          {initial time}
    for test := 1 to testRuns do;
             {empty loop}
    time := clock;              {time after loop}
    loopCost := time - loopCost;        {actual elapsed time}

    time := clock;              {reset 'timer'}
    writeln('The time at start is...', time);

    for test := 1 to testRuns do begin  {loop over problem}

        for i := 1 to m do begin        {each row of A}
            for j := 1 to p do begin    {each col of B}
                sum := 0;
                for k := 1 to n do begin        {find C[i,j]}
                    sum := A[i, k] * B[k, j] + sum
                end;
                C[i, j] := sum          {install each element}
            end
        end                     {one run}
    end; {testRuns}

    time2 := clock;
    time := (time2 - time - loopCost) div testRuns;

    writeln('The time at finish is...', time2);
    writeln('The number of runs was ', testRuns);
    writeln('The average time for each run was ...', time);
    writeln;

    if outputFlag then begin            {print matrix C}
        writeln('Matrix C is:');
        writeln;
        for i := 1 to m do begin
            write('C[', j: width, ']', tab);    {row #}
            for j := 1 to p do begin
                write(C[i, j]: width, tab)      {each value}
            end;         
            writeln
        end
    end
end.                            {* matrix1 *}
                                                                                                                                