/* filter to handle accents of the form <ESC><letter>

 * where ESC is a defined constant, and letter is a letter which

 * can be accented in Spanish (a, e, i, o, u for now).
 * N. B. these translations are the inverse of those in file
 * xt970 source - keep two files in synch *or else*.
 */
#include "stdio.h"
#define	ESCAPE	'@'
#define	ACENTO	22
#define	Enye	16
#define	ENYE	17
#define PREGUNTA 19
#define EXCLAMA	20
main(argc,argv)
int	argc;
char	*argv[];{
char 	c;
while ((c=getchar())!=EOF)
	if (c==ESCAPE)

         accescape(c);
         else putchar(c);
}
/* accescape - if escaped char is accent, print sequence, else
 * just print the character. Due to the vagaries of the typeball,
 * the following substitutions are made here:
 * <ESC><vocal>   -->  <vocal>\b^V
 * <ESC>n   -->  ^P
 * <ESC>N   -->  ^Q
 * <ESC>?   --> ^S
 * <ESC>!   --> ^T
 */
accescape(c)
char	c;{
char	d;
	if (!isaccent(d=getchar())){ /* <esc><non-accentable char> */

	putchar(c); putchar(d);
	}
	else {

	switch(d){
	case 'a': case 'e': case 'i': case 'o': case 'u':
	case 'A': case 'E': case 'I': case 'O': case 'U':
	putchar(d); putchar('\b'); putchar(ACENTO);	break;
	case 'n': putchar(Enye);	break;
	case 'N': putchar(ENYE);	break;
	case '?': putchar(PREGUNTA); break;
	case '!': putchar(EXCLAMA); break;
	default:	/* error, print nothing */ 
	}
	}
}
/* isaccent - see if char after escape is allowable as accented char */

isaccent(c)
char	c;{
return
	c=='a' || c=='e' || c=='i' || c=='o' || c=='u' ||
	c=='A' || c=='E' || c=='I' || c=='O' || c=='U' ||
	c=='n' || c=='N' ||
	c=='?' || c=='!' ;
}
