	title	'CCT.ASM	05/16/82'

;Used to combine multiple small files into one large file.

;command format:

;	CCT output [string] ]string[ = input1 , input2....

;;	blanks may be used before and after (but not
;;	within) the filenames for readability. The
;;	commas are also optional, except there must be
;;	something separating the filenames.

;;The input and output files may have the standard form
;;		drive:filename.ext
;;	where the drive may be A: to N: and is optional,
;;	and ext is the optional file extension.

;;The [string] is the optional prefix string, which will be
;;	put at the beginning of every line of the output file.
;;	The [ and ] are required punctuation, and the ] cannot
;;	be within the string, tho almost anything else can be.
;;	The surrounding brackets will not be included in the
;;	string. When present, the prefix string will always be
;;	the first characters of the output file, unless the
;;	output is completely empty.

;;The ]string[ is the optional suffix string, which will be
;;	put at the end of every line on the output file. The
;;	] and [ are required punctuation, and the [ cannot be
;;	within the string. The suffix string may be specified
;;	in the command line in front of the prefix string, as
;;	long as both are after the output filename and before
;;	the equal sign (=)

;;An input filename %N will give a CRLF (hex 0D 0A)

;;An * as a filename, such as A=* or A=B,*,C will switch
;;	to the console for input. All the standard line-
;;	-input editing functions are available, such as
;;	backspacing. Up to 254 characters may be input,
;;	and the input terminates with a null line or a
;;	EOF (Control-Z, hex 1A)

;;If the output file is omitted (no =), the console will
;;	be the destination

;; For example :

;;	CCT CCT.ASM		Types CCT.ASM

;;	CCT A = B FOO.ASM	Concatenates B and FOO.ASM giving A

;;	CCT A,C:B,C		Concatenates A, B (from the C drive),
;;				 and C with output to the console

;;	CCT A=*			Create file A from your console input

;;	CCT A = X.ASM,*		Copies X.ASM to A, followed by
;;				whatever you type in

;;	CCT NEW.ASM=OLD.ASM	Copies OLD.ASM to NEW.ASM
;;				NOTE:  only for ASCII files

;;	CCT X.ASM = Y %N Z	Concatenates Y, adds a CRLF, then Z
;;				 output going to X.ASM

;;	CCT %N %N %N %N		Sends four CRLFs to the console

;;	CCT COMMENT.ASM [; ] = COMMENT.DOC  Puts a ; and a blank at
;;				the beginning of every line in the
;;				.DOC file and puts the results in
;;				the COMMENT.ASM file

;;	CCT PIP.SUB [PIP C:=B:] = *  Puts "PIP C:=B:" in front of every
;;				line you type in - this could be sub-
;;				mitted to CP/M if a list of filenames
;;				on drive B: were typed in

;;Bugs or restrictions

;;	Ambiguous filenames are not allowed (no ? in filename)
;;		The files might not be concatenated in the order
;;		you wanted anyway.

;;	If the output file exists, it will be erased and replaced,
;;		so CCT A = A,B  will not do what you want

;;	A filename with nothing but an extension ( .ASM) is con-
;;		sidered an error

;;	It is possible to use a file called %N - just put a period
;;		after it, e.g. %N.

;;	Multiple commas get swallowed - A,,,B is wierd but OK.
;;		This might be useful in a submit file if a parameter
;;		is missing, such as   CCT $1=$2,$3,$4

;;	The program will stop when it hits a Control-Z (hex 1A), so
;;		using it to copy .COM files is not recommended.

;;	There will be only one Control-Z at the end, but there will
;;		always be one there, even if the input files do not
;;		have one, & that will be the only one in the file.

;;	When creating a file from console input, it is possible to
;;		choose whether there will be a CR-LF (hex 0D 0A) at
;;		the end. If you want it, stop with a null line. If
;;		you don't, stop by typing a Control-Z before hitting
;;		Return on the last line.

;;	Entering an ASCII NUL (hex 00, Control-@) can cause wierd
;;		problems anywhere in CP/M, and should be avoided.

;;	Entering CCT * will echo console input back to the console,
;;		but most systems will not see anything, because the
;;		output line will exactly overlay the input line.
;;		This command might be useful for Microshell, tho.

;;	The brackets [ and ] must be paired right, and may not appear
;;		in the output or any input filename.

;;	The %N is not changed into a CRLF within the prefix and suffix
;;		strings. In fact, I haven't found a way of getting
;;		a CRLF into the strings yet.

;;	If you want prefix or suffix strings on console output, you
;;		must put an = after the strings. Under any other con-
;;		dition, you cannot use an = if you want console out.
;;		E.g. CCT [>>>]=A and CCT A are legal, CCT =A is not

;;	It is adviseable to put spaces in between the output filename
;;		and the [ or ] if a prefix or suffix string is desired.
;;		In some versions of CP/M, if you are putting "funny"
;;		characters in the strings, it may be necessary to put a 
;;		. (period) before the strings start (and after the output
;;		filename) e.g.   CCT A . [^I.A::^I::??] = B

;;	The algorithm used for the prefix and suffix strings will in-
;;		tentionally not put the strings on the last line of
;;		the output file, if that line is empty. That is, if
;;		the end of the last file is CR LF EOF, the output file
;;		will also be that way.

;;	The algorithm used for line determination also treats the CR and
;;		LF as equivalent, and basically nul - that is, it doesn't
;;		care whether there is a CR, a CR-LF, an LF, or maybe CR-
;;		LF-CR-LF-LF, they're all the same.

;adapted from	'COMBINE.ASM'
;12/10/78 BY Ward Christensen

;Modified by Bob Van Valzah & Steve Ness on 1/9/79 to allow
;source files on any drive and remove comments preceded by blanks.

;Modified by Steve Ness on 12/20/79 to allow filetypes on source files.

;; 05/16/82 by Chuck Weingart, take out comment killer (above),
;;	add the %n inserter, rename to CCT to make a UNIX-like
;;	filter (the name CAT was already taken), add more error
;;	checks, allow console input, add prefix and suffix strings,
;;	and ignore blanks on command line.

TEST	EQU	0
K	EQU	1024	;1K
BLKSIZE	EQU	8*K	;OUTPUT FILE BLOCKSIZE
;;
;;
EOF	EQU	1AH	;;Control-Z
CR	EQU	0DH	;;Carriage Return
LF	EQU	0AH	;;Line Feed
;
;(FROM EQU7.LIB...)
MF	SET	0	;SHOW MOVE NOT REQUESTED
;
;DEFINE SOME MACROS TO MAKE THINGS EASIER
;
;DEFINE DATA MOVE MACRO
;
MOVE	MACRO	?F,?T,?L,?I
	IF	NOT NUL ?F
	LXI	H,?F
	ENDIF
	IF	NOT NUL ?T
	LXI	D,?T
	ENDIF
	IF	NOT NUL ?L
	LXI	B,?L
	ENDIF
	IF	NOT NUL ?I
	LOCAL	?B,?Z
	CALL	?Z
?B	DB	?I
?Z	POP	H	;GET TO
	LXI	B,?Z-?B
	ENDIF
	CALL	MOVER
MF	SET	-1	;;SHOW EXPANSION
	ENDM
;
;DEFINE CP/M MACRO - CPM FNC,PARM
;
CPM	MACRO	?F,?P
	PUSH	B
	PUSH	D
	PUSH	H
	IF	NOT NUL ?F
	MVI	C,?F
	ENDIF
	IF	NOT NUL ?P
	LXI	D,?P
	ENDIF
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	ENDM
;
	ORG	100H
;INIT LOCAL STACK
;
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
	lxi	h,80h
	mov	a,l	;;from /.asm
	add	m
	inr	a
	mov	l,a
	mvi	m,0	;zero the byte after the end of the command line.
;
;
;START OF PROGRAM EXECUTION
;
;MOVE THE COMMAND BUFFER
	MOVE	80H,HOLD,128 ;FROM,TO,LENGTH
;POSITION TO FIRST NAME TO COPY (FOLLOWS =)
	LXI	H,HOLD
	SHLD	NAMEADD	;;save in case of no file
SKIPEQ	INX	H
	MOV	A,M
	ORA	A	;;check if end of line
	JZ	CONSOL
	CPI	'['	;;look for boxes
	JZ	SKIPBRK
	CPI	']'
	JZ	S2IPBRK
	CPI	'='
	JNZ	SKIPEQ
	SHLD	NAMEADD	;SAVE POINTER
	LXI	H,FCB+1
	MOV	A,M
	MVI	B,11
QMLOOP
	CPI	'='	;;see if got equal in filename
	JZ	EQLOOP
	CPI	'?'	;;see if ambiguous
	JZ	QMFILE
	CPI	'['	;;kill the boxes, too
	JZ	EQLOOP
	CPI	']'
	JZ	EQLOOP
	INX	H	;;check next character
	MOV	A,M
	DCR	B	;;see if done
	JNZ	QMLOOP
;ERASE THE OUTPUT FILE
EQDONE
	LDA	FCB+1	;;see if error
	CPI	' '
	JZ	NOFILE2
	IF	NOT TEST
	CPM	ERASE,FCB
	CPM	MAKE,FCB
	INR	A
	JZ	NOROOM
	ENDIF
	LHLD	NAMEADD
	CALL	NEXTFL	;PRIME THINGS
	JC	NOFILE
LOOP	CALL	WRBYTE
	CALL	RDBYTE
	JNC	LOOP
;DONE -
	MVI	A,EOF
	CALL	WRBYTE
	LHLD	WRCOUNT
	LXI	D,128
	DAD	D	;FORCE LAST SECTOR
	SHLD	WRCOUNT	;..WRITE
	CALL	WRBUFS	;WRITE THE BUFFER
	CPM	CLOSE,FCB
	INR	A
	JNZ	EXIT
	CALL	ERXIT
	DB	'++CLOSE ERROR++$'
;
EQLOOP
	MVI	M,' '	;;gonna blank out rest of FCB
	INX	H
	DCR	B	;;see if done
	JNZ	EQLOOP
	JMP	EQDONE
;;
SKIPBRK
	SHLD	BRAKAD	;;save address
SKIPLUP
	INX	H	;;bump to next
	MOV	A,M
	ORA	A	;;check if end of line
	JZ	BADNAME
	SBI	']'	;;stop at bracket
	JNZ	SKIPLUP
	MOV	M,A	;;note for later use
	JMP	SKIPEQ
;;
S2IPBRK
	SHLD	B2AKAD	;;save address
S2IPLUP
	INX	H	;;bump to next
	MOV	A,M
	ORA	A	;;check if end of line
	JZ	BADNAME
	SBI	'['	;;stop at bracket
	JNZ	S2IPLUP
	MOV	M,A	;;note for later use
	JMP	SKIPEQ
;;
QMFILE
	CALL	ERXIT	;;
	DB	'++AMBIGUOUS FILE++$'
;
NOFILE
	LDA	PCTFLAG	;;see if just percents
	ORA	A
	JNZ	EXIT
NOFILE1
	CALL	ERXIT	;;nothing at all
	DB	'++MISSING FILE++$'
;;
;;
NOFILE2
	LHLD	BRAKAD	;;see if prefix or suffix strings
	MOV	A,H
	ORA	L
	LHLD	B2AKAD
	ORA	H
	ORA	L
	JZ	NOFILE1	;; = is OK if had strings
;;
CONSOL
	MVI	A,0C3H
	STA	CNFLAG
	LHLD	NAMEADD
	CALL	NEXTFL	;;set up loop
	JC	NOFILE
LOOPC	CALL	WRBYTE	;;now copy to console
	CALL	RDBYTE
	JNC	LOOPC	;;see if all done
	JMP	EXIT
;
;WRITE BYTE TO OUTPUT FILE
;
WRBYTE
	MOV	B,A	;;save the character
	CPI	EOF	;;see if end
	JZ	WRCRLF
	CPI	CR	;;look for CR or LF
	JZ	WRCRLF
	CPI	LF
	JZ	WRCRLF
	LDA	CRFLAG	;;now check if just had CR or LF
	ORA	A
	JZ	WRBYT
	XRA	A	;;now turn off CRLF
	STA	CRFLAG
	LHLD	BRAKAD	;;at beginning of line, put out prefix
	MOV	A,L
	ORA	H	;;see if prefix
	JZ	WRBYT
PREFLUP
	INX	H
	MOV	A,M	;;get a character
	ORA	A
	JZ	WRBYT	;;jump if end of prefix string
	PUSH	H
	PUSH	B
	MOV	B,A
	CALL	WRBYT	;;pump out character
	POP	B
	POP	H
	JMP	PREFLUP
WRCRLF
	LDA	CRFLAG	;;now check if just had CR or LF
	ORA	A
	JNZ	WRBYT
	CMA		;;now indicate CRLF
	STA	CRFLAG
	LHLD	B2AKAD	;;at end of line, put out suffix
	MOV	A,L
	ORA	H	;;see if suffix
	JZ	WRBYT
SUFFLUP
	INX	H
	MOV	A,M	;;get a character
	ORA	A
	JZ	WRBYT	;;jump if end of prefix string
	PUSH	H
	PUSH	B
	MOV	B,A
	CALL	WRBYT	;;pump out character
	POP	B
	POP	H
	JMP	SUFFLUP
;;
WRBYT
	LDA	CNFLAG
	ORA	A	;;if console output, go do it
	MOV	A,B
	JNZ	TYPE
	LHLD	WRBUFAD	;;disk i/o is buffered
	MOV	M,A
	INX	H	;;bump up to next character
	SHLD	WRBUFAD
;BUMP COUNT
	LHLD	WRCOUNT
	INX	H
	SHLD	WRCOUNT
;SEE IF TIME TO WRITE BUFFER
	DAD	H	;H=# SECTORS
	MOV	A,H
	CPI	BLKSIZE/128
	RNZ
;TIME TO WRITE THE OUTPUT BUFFER
;
WRBUFS	LXI	H,WRBUFF
	SHLD	WRBUFAD
	XCHG
	LHLD	WRCOUNT
	DAD	H	;H=# SECTORS
	MOV	B,H	;SAVE SECTOR COUNT
	MOV	A,B
	ORA	A	;0 SECTORS? (POSS AT EOF)
	JNZ	WRBFLP
	INR	B	;FUDGE IN PARTIAL SECTOR
WRBFLP	CPM	SETDMA
	CPM	WRITE,FCB
	ORA	A
	JNZ	WRERR
	LXI	H,80H
	DAD	D
	XCHG
	DCR	B
	JNZ	WRBFLP
	LXI	H,0
	SHLD	WRCOUNT
	RET
;
WRERR	CALL	ERXIT
	DB	'++WRITE ERROR++$'
;
;READ BYTE FROM INPUT FILE
;
RDBYTE	LHLD	RDBUFAD
	LDA	RDCOUNT	;GET CHAR COUNT
	ORA	A	;TIME TO READ?
	JP	NOREAD
;HAVE TO READ
	CPM	SETDMA,RDBUFF
	CPM	READ,RDFCB
	ORA	A
	JNZ	NEXTFL	;;if disk EOF, go get next file
	CPM	SETDMA,80H
	LXI	H,RDBUFF
	MVI	A,0
NOREAD	INR	A
	STA	RDCOUNT	;SAVE CHAR COUNT
	MOV	A,M	;GET CHAR
	INX	H
	SHLD	RDBUFAD
	CPI	EOF	;EOF?
	JZ	NEXTFL
	ORA	A	;CARRY OFF SHOWN NOT EOF
	RET
;
;GOT EOF - GET NEXT FILE
NEXTFL	LHLD	NAMEADD	;GET NAME POINTER
	MOV	A,M	;GET DELIMITER
	ORA	A
	STC
	RZ		;RET IF ALL DONE
MOVEX
	INX	H	;SKIP DELIMITER
	MOV	A,M
	CPI	' '	;;gonna skip by blanks
	JZ	MOVEX
	CPI	','	;;   and commas
	JZ	MOVEX
	ORA	A
	STC		;;return if nothing but blanks
	RZ
	LXI	D,RDFCB ;POINT TO NAME
	xra	a	;prepare to use default drive
	stax	d
	STA	PRFLAG	;;zero out period flag
	inx	d
	PUSH	D
;BLANK THE FCB
	MVI	A,' '
	MVI	B,11
BLANK	STAX	D
	INX	D
	DCR	B
	JNZ	BLANK
	POP	D
;
	inx	h	;look ahead for colon, indicating drive
	mov	a,m
	dcx	h	;backup j.i.c. not there
	cpi	':'	;was a drive specified?
	jnz	moven	;nope - just scan off file name
	mov	a,m	;yup - insert drive name into fcb
	sui	'A'-1
	JC	MOVEN	;;skip bad drive name
	CPI	16	;;and make sure valid
	JNC	BADNAME
	sta	rdfcb
	inx	h	;move source pointer over drive spec.
	inx	h
MOVEN	MOV	A,M
	CPI	':'	;;see if extraneous colon
	JZ	BADNAME
	CPI	'?'	;;dont allow ambiguity
	JZ	QMFILE
	CPI	','
	JZ	MOVED
	CPI	' '	;;stop at comma or blank
	JZ	MOVED
	cpi	'.'
	jz	movft
	ORA	A	;ZERO @ END?
	JZ	MOVEZ
	CPI	'['	;;no bad filenames
	JZ	BADNAME
	CPI	']'
	JZ	BADNAME
	STAX	D
	MVI	A,FCBEXT ;;is it past FCB ?
	CP	E
	JNC	BADNAME
	INX	H
	INX	D
	JMP	MOVEN
movft
	LDA	PRFLAG	;;check if already got period
	ORA	A
	JNZ	BADNAME
	CMA
	STA	PRFLAG	;;indicate found period
	inx	h
	lxi	d,rdfcb+9	;address filetype of read block
	jmp	moven
;
MOVEZ
	SHLD	NAMEADD	;SAVE NAME LIST ADDR
	LDA	RDFCB+1
	CPI	' '	;;look at file name
	STC
	RZ
;ALL DONE MOVING
MOVED	SHLD	NAMEADD	;SAVE NAME LIST ADDR
	LDA	RDFCB
	ORA	A	;;no drive on %N
	JNZ	NOCENT
	LDA	RDFCB+1	;;see if no file
	CPI	' '
	JZ	NOFILE
	CPI	'*'
	JZ	GOTBLNK
	CPI	'%'	;;check for per cent
	JNZ	NOCENT
	LDA	RDFCB+2
	CPI	'N'	;;check for N after percent
	JNZ	NOCENT
	LDA	RDFCB+3
	CPI	' '	;;check for anything else
	JNZ	NOCENT
	LDA	PRFLAG
	ORA	A
	JNZ	NOCENT
	MVI	A,CR	;; CR
	STA	PCTFLAG
	CALL	WRBYTE
	MVI	A,LF	;; LF
	CALL	WRBYTE
	JMP	NEXTFL	;;now go skip by filename
NOCENT
	XRA	A
	STA	RDEXT	;ZERO EXTENT
	STA	RDRNO	;ZERO RECORD #
	CPM	SETDMA,RDBUFF
	CPM	OPEN,RDFCB
	INR	A
	JZ	OPENERR
	MVI	A,80H	;SHOW TIME TO READ
	STA	RDCOUNT
	CPM	SETDMA,80H
	JMP	RDBYTE
;;
GOTBLNK
	STA	PCTFLAG	;;deactivate error message
	LDA	PRFLAG
	ORA	A	;;see if bad news
	JNZ	BADNAME
GOTLIN
	CPM	CONIN,INAREA
	LXI	H,INAREA+1 ;;get character count
	MOV	A,M
	ORA	A	;;see if no line
	JZ	NEXTFL
	MOV	B,A	;;initialize loop
	INR	B
GOTLUP
	DCR	B	;;see if end of line
	JZ	GOTEND
	INX	H	;;get next character
	MOV	A,M
	ORA	A	;;stop if NUL
	JZ	NEXTFL
	CPI	EOF	;;see of EOF
	JZ	NEXTFL
	PUSH	B
	PUSH	H
	CALL	WRBYTE	;;pop out character
	POP	H
	POP	B
	JMP	GOTLUP	;;no go get another
GOTEND
	MVI	A,CR	;;put out CR
	CALL	WRBYTE
	MVI	A,LF	;;put out LF
	CALL	WRBYTE
	JMP	GOTLIN	;;go get another line
;;
OPENERR	LXI	H,RDFCB+1
	MVI	B,11
NAMELP	MOV	A,M
	CALL	TYPE
	INX	H
	DCR	B
	JNZ	NAMELP
	CALL	ERXIT
	DB	': ++OPEN FAILED++$'
;;
;;
BADNAME
	LXI	H,RDFCB+1
	MVI	B,11
NAMEZZ	MOV	A,M
	CALL	TYPE
	INX	H
	DCR	B
	JNZ	NAMEZZ
	CALL	ERXIT
	DB	'++INVALID FILENAME++$'
;
;
NOROOM	CALL	ERXIT
	DB	'++NO ROOM ON OUTPUT DISK$'
;
TYPE	MOV	E,A
	CPM	WRCON
	RET
;
;FOLLOWING FROM 'EQU7.LIB'---->
;
;MOVE SUBROUTINE
;
	IF	MF	;MACRO EXPANSION FLAG SET?
MOVER	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	MOVER
	RET
	ENDIF
;
;
;EXIT WITH ERROR MESSAGE
MSGEXIT	EQU	$	;EXIT W/"INFORMATIONAL" MSG
ERXIT	POP	D	;GET MSG
	MVI	C,PRINT
	CALL	BDOS
;EXIT, RESTORING STACK AND RETURN
EXIT	LHLD	STACK
	SPHL
	RET		;TO CCP
;;
;;
BRAKAD
	DW	0	;;start of prefix string
B2AKAD
	DW	0	;;start of suffix string
PCTFLAG
	DB	0	;;flag to indicate percent
PRFLAG
	DB	0	;;flag to indicate period
CNFLAG
	DB	0	;;flag indicating console
CRFLAG
	DB	1	;;flag indicating CR or LF
WRBUFAD	DW	WRBUFF	;OUTPUT BUFFER ADDR
WRCOUNT	DW	0	;BYTE COUNTER
RDBUFAD	DW	RDBUFF
RDDRV	DB	0	;DRIVE NAME TO READ FROM
RDFCB	DB	0,'           '
RDEXT	DB	0
	DS	19
RDRNO	DB	0
RDCOUNT	DB	80H	;CHARACTER COUNT IN BUFF
;;
;;CONSOLE INPUT LINE BUFFER
INAREA	DB	254
	DS	255
;;
;;	Only unitialized RAM after this 
;;
	DS	40H	;STACK AREA
STACK	DS	2
;;
;POINTER TO LIST OF FILENAMES
NAMEADD	DS	2
;;
;COPY OF INPUT COMMAND BUFFER (FROM 80H)
HOLD	DS	128
;;
;OUTPUT DISK BUFFER
	ORG	($+255) AND 0FF00H ;TO PAGE
RDBUFF	DS	128
WRBUFF	DS	BLKSIZE
;;
;BDOS/CBIOS EQUATES (VERSION 7)	
RDCON	EQU	1
WRCON	EQU	2
PRINT	EQU	9
CONIN	EQU	10
CONST	EQU	11
OPEN	EQU	15
CLOSE	EQU	16
SRCHF	EQU	17
SRCHN	EQU	18
ERASE	EQU	19
READ	EQU	20
WRITE	EQU	21
MAKE	EQU	22
REN	EQU	23
SETDMA	EQU	26
BDOS	EQU	5
FCB	EQU	5CH 
FCB2	EQU	6CH
FCBEXT	EQU	FCB+12
FCBRNO	EQU	FCB+32
	END
