

 /*  **** CTRIG.C *****
A group of programs in C, using the BDS-C floating point package,
as modified by L. C. Calhoun called FLOATXT, which compute some
commonly used transcendental functions - to wit*
	sine, cosine, tangent and arctangent
	convert degrees to radians, convert radians to degrees
These functions are discussed in detail in CTRIG.DOC

L. C. Calhoun
257 South Broadway
Lebanon, Ohio 45036   513 932 4541/433 7510

 *** revision 13 July 1981 to 1) refine precision of constants,
 especially pi related values  2) to utilize string constants
 as pseudo static numeric constants.  THIS WILL ONLY WORK WITH
 BDS C V 1.44 (and hopefully later).
 3) to add ARCTAN2() function to identify quadrant

  */

/* simple ones first converting degrees - radians */

char *degtorad(rad,deg) /*obvious arguments in 5 char fp */
char *rad, *deg;
{
	char *fpmult(),*radindeg;
	radindeg = "\71\36\175\107\373";
	fpmult(rad,deg,radindeg);
	return (rad);
}

char *radtodeg(deg,rad) /* 5 char fp arguments */
char *deg, *rad;
{
	char *fpmult(), *deginrad;
	deginrad = "\12\162\227\162\6";
	fpmult(deg,rad,deginrad);
	return (deg);
}

/* service function sinev which evaluates when range of angle
reduced to plus or minus pi/2 (90 deg) */

char *sinev(result,angle)

char *result, angle[5];
{
	char *fpmult(),x[5],xsq[5];
	char *coef[5],termreslt[5];
	char *fpadd(),*fpasg();
	int index;

	/*  use the exponent part of the floating point
	    to check for threat of underflow  use small
	    angle approximation if appropriate  */
	if ( (angle[4] > 128) && (angle[4] < 226) )
	   {fpasg(result,angle);	   return (result);
	  }   /* solution to fpmult underflow problem */

/* series coef are 1., -.1666666, .008333026, -.0001980742,
	.000002601887  determined from coefset program */
	coef[0] = "\0\0\0\100\1";
	coef[1] = "\157\252\252\252\376";
	coef[2] = "\271\242\103\104\372";
	coef[3] = "\320\352\46\230\364";
	coef[4] = "\246\15\116\127\356";
	fpasg(x,angle);
	fpmult(xsq,x,x);
	setmem(result,5,0);
 /* to this point the coef have been initialized, the angle
    copied to x, x squared computed, and the result initialized */

/* now to do the polynomial approximation */
	index = 0;
	while ( (index <= 4) && ( (x[4] > 194) || (x[4] < 64) ) )
	/* use index for loop, and exponent of x to avoid underflow
	   problems */
	{fpmult(termreslt,coef[index],x);
	fpadd(result,result,termreslt);
	 index++;
	 fpmult(x,x,xsq);
	}
	return (result);
}

 /* here is sine(result,angle) with angle in radians */

char *sine(result,angle)

char *result, *angle;
{
	char *fpmult(),*twopi,*halfpi;
	char *mtwopi,*mhalfpi,*fpasg(),*fpchs();
	char *pi,*sinev(),*fpadd();
	char y[5],*fpsub();
	int fpcomp(), compar;
	int signsine;
 /* some initialization required here */
	signsine = 1;
	twopi	= "\171\356\207\144\3";
	halfpi	= "\171\356\207\144\1";
	pi	= "\171\356\207\144\2";
	mtwopi	= "\207\21\170\233\3";
	mhalfpi	= "\207\21\170\233\1";
	fpasg(y,angle);
	while (fpcomp(y,twopi) >= 0)
	   {fpsub(y,y,twopi);
	   }
	while (fpcomp(y,mtwopi)<= 0)
	   {fpadd(y,y,twopi);
	   }
	if(fpcomp(y,halfpi) > 0)
	   {signsine *=-1; fpsub (y,y,pi);
	   }
	if(fpcomp(y,mhalfpi)<  0)
	   {signsine *=-1; fpadd (y,y,pi);
	   }
	sinev(result,y);
	if (signsine > 0) return (result);
 /* minus so need to change sign */
	else return ( fpchs(result,result) );
}

 /* cosine(result,angle) with angle in radians  - uses sine */

char *cosine(result,angle)

char *result, *angle;
{
	char *sine(),*fpsub(),*halfpi,y[5];
	halfpi = "\171\356\207\144\1";
	fpsub(y,halfpi,angle);
	sine(result,y);
	return (result);
}

/* tangent(result,angle) with angle in radians, returns very 
large number for divide by zero condition */

char *tangent(result,angle)
char *result, angle[5];
{
	char *sine(), *cosine(), *fpdiv(), zero[5];
	char sresult[5], cresult[5], intres[5], big[5];
	char *fpmult(), *fpmag();

	sine(sresult,angle);
	cosine(cresult,angle);
	/* check magnitude of denominator :*/
	/* check magnitude of denominator using exponent */
	if ( (cresult[4] > 128) && (cresult[4] < 132) )
	   {initb(big,"30,207,228,127,128"); /*big number */
	    if ( sresult[3] > 127 ) /*use mantissa sign */
	       return ( fpchs(result,big) );
	    else return ( fpasg(result,big) );
	   }
	/* check for small angle, use small angle approx to
	   avoid underflow */
	if ( (angle[4] < 226) && (angle[4] > 128) )
	   return ( fpasg(result,angle) );
	else
	   return ( fpdiv(result,sresult,cresult) );
}

/* atanev(result,x) evaluates arctangent for 0 <= x < infinity,
	result in radians */

char *atanev(result,x)

char  result[5], x[5];
{
	char *coef[8],*piover4,y[5];
	int index;
	char *fpadd(),*fpmult(),*atof(),ysq[5],*one;
	char yterm[5],termreslt[5],*fpasg();

	piover4 = "\171\356\207\144\0";
	one = "\0\0\0\100\1";

	/* small angle approximation */
	if ( (x[4] > 128) && (x[4] < 226) )
	/* use fp exponent to check size, use small angle */
	 return ( fpasg(result,x) );
	else
	fpasg(result,piover4);

	/* check for argument near one */
	fpsub(yterm,x,one);
	/* if it is close to one, as checked by exponent,
	   return the result pi/4  */
	if ( (yterm[4] > 128) && (yterm[4] < 243) )
	   return (result);


	coef[0] = "\270\376\377\177\0";
	coef[1] = "\277\357\254\252\377";
	coef[2] = "\106\126\40\146\376";
	coef[3] = "\146\313\311\270\376";
	coef[4] = "\34\360\273\142\375";
	coef[5] = "\206\30\177\215\374";
	coef[6] = "\154\54\213\131\373";
	coef[7] = "\67\12\224\275\371";

	fpadd(termreslt,x,one);
	fpdiv(y,yterm,termreslt);

	fpmult(ysq,y,y);
/* do poly evaluation */
	index = 0;
	/* poly evaluation checked by index limit, and check of
	variables for under/over flow */
	while ( (index <= 7) && ( (y[4]<100) || (y[4]>140) ) )
	 {fpmult(termreslt,coef[index],y);
	  fpadd(result,result,termreslt);
	  index++;
	  fpmult(y,y,ysq);
	 }

	return (result);
}

/* arctan(result,angle) is floating point arctangent evaluation */

char *arctan(result,x)
char result[5], x[5];

{
	char *atanev(),*fpasg(),y[5];
	char *fpchs(),*halfpi;
	int index;
	halfpi = "\171\356\207\144\1";
	/* check exponent for very large argument */
	if ( (x[4] > 100) && (x[4] <= 128) )
	   {
	    fpasg(result,halfpi);
	   }
	else  /* go through evaluation */
	  {fpmag(y,x);
	   atanev(result,y);
	  }

	if ( x[3] > 127 )
	  {return ( fpchs(result,result) );}
	else return (result);
}


char *arctan2 (result, quadrant, opside, adjside)

char result[5], opside[5], adjside[5];
int *quadrant;

{
	char x[5], *fpmag(), *fpchs(); *arctan();
	int opsign, adjsign;
	char *zero, *halfpi;

	halfpi = "\171\356\207\144\1";

	zero = "\0\0\0\0\0";

	opsign = fpcomp(opside,zero);
	adjsign = fpcomp(adjside,zero);

	if((adjsign == 0) && (opsign == 0))
	   {*quadrant = 0;
	    fpasg(result,zero);
	    return(result);
	   }

	if(((adjside[4] >128) && (adjside[4] < 226)) || (adjsign == 0))
	   fpasg(result,halfpi);
	else
	   {fpdiv(x,opside,adjside);
	    fpmag(x,x);
	    arctan(result,x);
	   }

	if((adjsign == 0) && (opsign >  0))
	   {*quadrant = 1;
	    return(result);
	   }
	if((adjsign == 0) && (opsign <  0))
	   {*quadrant = 4;
	    fpchs(result,result);
	    return(result);
	   }
	if((adjsign >  0) && (opsign == 0))
	   {*quadrant = 1;
	    return(result);
	   }
	if((adjsign < 0 ) && (opsign == 0))
	   {*quadrant = 2;
	    fpchs(result,result);
	    return(result);
	   }
	if((adjsign > 0) && (opsign > 0))
	   {*quadrant = 1;
	    return(result);
	   }
	if((adjsign > 0) && (opsign < 0))
	   {*quadrant = 4;
	    fpchs(result,result);
	    return(result);
	   }
	if((adjsign < 0) && (opsign > 0))
	   {*quadrant = 2;
	    fpchs(result,result);
	    return(result);
	   }
	if((adjsign < 0) && (opsign < 0))
	   {*quadrant = 3;
	    return (result);
	   }
}
