#include "bdscio.h"
/*
	"Hexdif"
	Copyright (C) 1980 James E. Korenthal

	Modified November 18, 1980 by Paul J. Gans to
	display character equivalents on mismatch.

	command format: A>hexdif file1 file2 
		    or: A>hexdif file1 file2 newfile

	This program finds differences between file1
	and file2.  The differences are printed, and
	also sent to newfile (if specified).
*/

int newfile, newbuf[BUFSIZ];
char hexdig[16];

main(argc,argv)
char **argv;
{
	int byte, c1, c2;
	int file1,file2;
	char buf1[BUFSIZ], buf2[BUFSIZ];

	movmem("0123456789ABCDEF",hexdig,16);

	newfile = 0;
	switch(argc) {
	   case 4:		newfile = fcreat(argv[3],newbuf);
	   case 3:		file1 = fopen(argv[1],buf1);
				file2 = fopen(argv[2],buf2);
				break;
	   default:		printf("usage: hexdif file1 file2\n");
				printf("   or: hexdif file1 file2 newfile\n");
				exit();
	}
	if (file1 == -1 || file2 == -1 || newfile == -1) {
		printf("Can't open file(s)\n");
		exit();
	}
	plops("File Compare - Copyright (C) 1980 James E. Korenthal\n");
	plops("\tAddress\t"); plops(argv[1]);
	plops(" -- "); plops(argv[2]); plopc('\n');

	byte = 0x0100;
	while (1) {
		c1 = getc(buf1); c2 = getc(buf2);
		if (c1 == -1 && c2 == -1) break;
		if (c1 == -1) {
			premend(argv[1],argv[2],byte,c2);
			break;
		}
		if (c2 == -1) {
			premend(argv[2],argv[1],byte,c1);
			break;
		}
		if (c1 != c2) {
			plops("\t  "); ploph(byte>>8); ploph(byte);
			plops("\t "); ploph(c1); plops(" [");
				plopc2(c1); plops("]");
			plops("\t     "); ploph(c2); plops(" [");
				plopc2(c2); plops("]\n");
		}
		byte++;
	}
	plops("End of file compare.\n");
	if (newfile) fflush(newbuf);
	close(buf1); close(buf2);
}

plopc1(c)
char c;
{
	putchar(c);
	if (newfile) {
		if (putc(c,newbuf) < 0) {
			printf("\n\thexdif: disk write error.");
			exit();
		}
	}
}

plopc2(c)
char c;
{
	c&=0x7f;
	if (c<0x20) c=0x20;
	plopc1(c);
}

plopc(c)
char c;
{
	if (c == '\n') plopc1('\r');
	plopc1(c);
}

plops(s)
char *s;
{
	while (*s != 0) plopc(*s++);
}

ploph(n)
int n;
{
	plopc(hexdig[(n >> 4) & 0xf]);
	plopc(hexdig[n & 0xf]);
}

premend(f1,f2,b,c)
char *f1, *f2;
int b, c;
{
	plops("Premature end of file: "); plops(f1); plopc('\n');
	plops("Next byte of "); plops(f2);
	plops(" (address "); ploph(b >> 8); ploph(b);
	plops(") is "); ploph(c); plopc('\n');
}


/**************