#define VERSION "Multiple File Printer, Version 2.0, March 1982."
#define COPYRIGHT "Copyright (C) 1982, by Herb Schulz. All rights reserved."
/*	
 *	This program is released into the public domain and may be used
 *	for any non-commercial purpose.
 *
 * history:
 *	Version 1.4: January, 1982.
 *			First version released to public domain.
 *	Version 2.0: March, 1982.
 *			i)Added multiple copy ability.
 *		       ii)Changed parameter designation -2 & -1 to -t & -s.
 *		      iii)Fixed bug that didn't find match on afn ending
 *				with a '.'.
 *
 * Please send any information about bugs, etc. to
 *
 *				  Herb Schulz
 *			 6008 Forest View Rd., Apt 3C
 *			       Lisle, Il. 60532.
 *
 */
#include <a:bdscio.h>

/*
 * Comment out the following #define if you don't use Uafn's
 */
#define HASUAFN

/*
 * Defines for printers with more than one print width. To set
 * mfp up to use the alternate mode for printing "un-comment"
 * the HASALT define, enter the strings necessary to go into the
 * alternate width and normal width modes for your printer in to the
 * appropriate defines and also the number of characters per line
 * for each of the two print modes. Some common width values 
 * (approximate - assuming 8.5" wide paper [printing width] with 
 * 1/4" borders) are
 *
 *		       5   char/in =  40 char/line
 *	              10       "   =  80     "
 *		      12       "   =  96     "
 *		      16.5     "   = 132     "
 *		      17       "   = 136     "     .
 *
 * If your printer has only one print width leave the HASALT define
 * commented out and make sure the value of the NORMWIDTH define is
 * correct for your printer.
 */

/*
#define HASALT
*/

#define CONFIGFOR "tty"	/* name of printer for which mfp is configured - used if HASALT is set */
#define ALTWIDTH 96	/* width of alternate pitch in chars/line */
#define NORMWIDTH 80	/* width of normal pitch in chars/line - also if you have no alt width */
#define ALT ""	 	/* string to go into alternate pitch */
#define NORM ""		/* string to go into normal pitch */

/* other user changeable defines */
#define PARMPREFIX '-'	/* prefix to parameter list */
#define LPP 62		/* lines per page */
#define TAB 8		/* tab stops every 8 char */
#define SAFETY 0	/* safety factor: to prevent auto-wrap by the printer */

/* These defines should be left alone */
#define LST 2		/* sending output to LST: device */
#define FF '\014'	/* form feed character */
#define DEFHDR 2	/* default number of lines in header + 1 blank */

/* "external" variables */
struct _buf inbuf;	/* input buffer */
char *p,		/* pointer to argument list - or - file name */
     date[MAXLINE],	/* buffer to hold present date (other stuff also) */
     hdr[MAXLINE];	/* buffer to hold possible second header line */
int  cc,		/* character counter */
     lc,		/* line counter */
     pgc,		/* page counter */
     ncopy,		/* number of copies */
     lcoffset,		/* number of lines in header (DEFHDR or DEFHDR+1) */
     hdrflg,		/* second header line flag */
     altflg;		/* alternate mode flag */

/*
 * This is the actual file lister program. The main(), found towards the
 * end of this file, is the argument expander. By doing things in this 
 * way it is relatively easy to delete the wild card features of the 
 * program: mainp() expects ONLY ufn's and parameter lists and can't 
 * cope with wild cards.
 */
mainp(argc, argv)
int argc;
char **argv;
{
	int nc;		/* copy counter */
     
	/* set defaults */
	altflg = hdrflg = FALSE; 
	ncopy = 1;

	/* let 'em have instructions */
	if (argc < 2)
		usage();

	/* get date */
	puts("\nEnter today's date (Month/Day/Year): ");
	gets(date); /* NOTE: this will be in the header for ALL files! */

	puts("\nPress any key when your printer is ready: ");
	getchar();
	puts("\nPressing any key suspends printing.\n");

#ifdef HASALT
	fputs(NORM, LST); /* initialize printer to normal mode */
#endif

	while (--argc) {
		
		p = *(++argv);

		if (*p == PARMPREFIX) {
			xparm(p);
			continue;
		}

		/* have a file name */
		if (fopen(p, inbuf) == ERROR) {
			printf("\nCannot open %s.\n", p);
			continue;
		}

		printf("\nPrinting %s ", p);
#ifdef HASALT
		printf(": %d char/line ", altflg ? ALTWIDTH : NORMWIDTH);
#endif
		if (ncopy > 1)
			printf(": %d copies ", ncopy);

		if (*(p + 1) == ':')
			p += 2; /* now delete disk directive */

		lcoffset = DEFHDR;
		if (hdrflg) {
			puts("\nSecond header line (<cr> alone deletes second line):\n");
			gets(hdr);
			if (*hdr)
				++lcoffset;
		}

		for (nc = 1; nc <= ncopy; ++nc) {

			if (ncopy > 1)
				printf("\n\t\t\tcopy %d", nc);

			if (!pfile(argc)) /* user killed printing of file */
				break;

			if (nc < ncopy) {  /* reset the file pointer */
				seek(inbuf._fd, 0, 0);
				inbuf._nleft = 0;
			}
		}
		fclose(inbuf);

	} /* while (--argc) */

#ifdef HASALT
	if (altflg)
		fputs(NORM, LST);
#endif

} /* mainp() */

/* Expand the parameter list */
xparm(parmp)
char *parmp;
{
	while (*(++parmp)) 
		switch (tolower(*parmp)) {
#ifdef HASALT
		case 'a':
			altflg = TRUE;
			break;

		case 'n':
			altflg = FALSE;
			fputs(NORM, LST);
			break;
#endif
		case 'm':
			ncopy = 0;
			while (isdigit(*++parmp))
				ncopy = 10 * ncopy + *parmp - '0';
			--parmp;
			if (!ncopy)
				++ncopy;
			break;

		case 't':
			hdrflg = TRUE;
			break;

		case 's':
			hdrflg = FALSE;
			break;

		default:
			printf("\n-%c isn't an available option", tolower(*parmp));
		} /* switch */
}

/* Print the file out. Returns FALSE if printing killed. */
int pfile(argc)
int argc;
{
	char ch,		/* single char from buffer */
	     nextc;		/* look ahead char for line overflow */

	cc = pgc = lc = 0;
	while ((ch = getc(inbuf)) != EOF && (ch &= '\177') != CPMEOF) {

		if (kbhit()) {
			getchar(); /* empty buffer */
			puts("\nPrinting halted (^C exits, <ESC> skips, anything else continues): ");
			if (getchar() == '\033') {
				if (argc > 1) {
					puts("\nGet the printer ready and press any key: ");
					getchar();
				}
				return (FALSE);
			}
		}

		if (!lc) /* put in header */
			prhdr();

		switch (ch) {

		case '\r':
			break; /* '\r' generated when '\n' encountered */

		case '\n':
			cc = 0;
			crlf();
			break;

		case '\t':
			do {
				putc(' ', LST);
#ifdef HASALT
				if (!(++cc % (altflg ? (ALTWIDTH - SAFETY) : (NORMWIDTH - SAFETY)))) {
#else
				if (!(++cc % (NORMWIDTH - SAFETY))) {
#endif
					nextc = getc(inbuf);
					if(!(!(cc % TAB) && eol(nextc)) && !crlf()) 
						prhdr();
					ungetc(nextc, inbuf);
				}
			} while (cc % TAB);
			break;

		default:
			putc(ch, LST);
#ifdef HASALT
			if (!(++cc % (altflg ? (ALTWIDTH - SAFETY) : (NORMWIDTH - SAFETY)))) {
#else
			if (!(++cc % (NORMWIDTH - SAFETY))) {
#endif
				nextc = getc(inbuf);
				if (!eol(nextc))
					crlf();
				ungetc(nextc, inbuf);
			}

		} /* switch (ch) */

	} /* while ((ch ...) */
	
	if (lc)
		putc(FF, LST);
	
	return (TRUE);
}

/* Sends a '\r', and either a FF if at the bottom of the page or a '\n'.
 * Returns new value of lc.
 */
int crlf()
{
	++lc;
	putc('\r', LST); /* putc(.., LST) doesn't auto send '\r' with '\n' */
	if (lc %= (LPP - lcoffset))
		putc('\n', LST);
	else
		putc(FF, LST);
	return(lc);
}

/* 
 * print a header on the top of each page and increment 
 * the line and page counts.
 */
prhdr()
{
#ifdef HASALT
	if (altflg)
		fputs(NORM, LST);
#endif

	++lc;
	fprintf(LST, "%s        %s        Page %d\n", p, date, ++pgc);
	if (lcoffset != DEFHDR) /* second header present */
		fprintf(LST, "%s\n", hdr);
	putc('\n', LST);

#ifdef HASALT
	if (altflg)
		fputs(ALT, LST);
#endif
}

int eol(ch)
char ch;
{
	return(ch == EOF || (ch &= '\177') == CPMEOF || ch == '\r' || ch == '\n');
}

usage()
{
	printf("\n%s\n%s\n", VERSION, COPYRIGHT);
#ifdef HASALT
	printf("Configured for %s\n", CONFIGFOR);
#endif
	puts("\nusage: mfp {[-");
#ifdef HASALT
	puts("an");
#endif
	puts("tsmx] ");
#ifdef HASUAFN
	puts("Uafn | ");
#endif
	puts("ufn}\n");
#ifdef HASUAFN
	puts("\nWhere Uafn is UNIX style ambiguous file name, ufn");
	puts("\nis an unambiguous file name and the possible");
#else
	puts("\nWhere ufn is an unabiguous file name and the possible");
#endif
	puts("\nparameters (any combination of one or more may");
	puts("\nbe used - read left to right) are\n");
#ifdef HASALT
	printf("\n\t-a = print using %d characters/line", ALTWIDTH);
	printf("\n\t-n = print using %d characters/line (default)", NORMWIDTH);
#endif
	puts("\n\t-t = prompt for a second header line");
	puts("\n\t-s = reset to single line header (default)");
	puts("\n\t\b-mx = print x copies [-m1 or -m resets] (default x = 1)");
	puts("\n\n { ... } = 1 or more, [ ... ] = optional\n");
	puts("\nAll parameters stay in effect until the next");
	puts("\nparameter list is encountered. Even then, only");
	puts("\nthe specified parameters change.");
	exit();
}

/* Comment all of the rest of this program out if you don't want to use wild cards */

/* BIOS calls and related defines */
#define SELDSK 9
#define MAXDSKN 16

/* BDOS calls and related defines */
#define SRCH1 17
#define SRCHN 18
#define CURDSK 25
#define NOMORE 255

/* Other defines */
#define FCBSIZ 36
#define DIRNTRYSZ 32
#define BUFBASE 0x80
#define DSKSIZ 3	/* # chars in disk designator (D:\0) */
#define UFNSIZ 15	/* max # chars in File Name (D:FFFFFFFF.EEE\0) */

/* Change these if necessary */
#define MAXARG 100

/* main() is just frnd13.c with the unused dio references deleted */
main(argc, argv)
int argc;
char **argv;
{
	char *alloc(), 		/* uses memory allocation */
	     afcb[FCBSIZ], 	/* fcb for getting directory */
	     *argxv[MAXARG], 	/* new argument vector */
	     dsk[DSKSIZ],	/* for disk designator */
	     fname[UFNSIZ], 	/* store ufn here for compare */
	     maxdisk;		/* highest disk present */
	int  offset, 		/* offset in default buffer to dir entry */
	     argxc, 		/* new argument counter */
	     finper,		/* TRUE if Uafn ends with a '.' */
	     i; 		/* general counter */
	unsigned _biosh();	/* bios call returning HL instead of A */	

	/* initialization */
	_allocp = NULL;     /* mandatory initialization for mem. allocation */
	argxv[0] = argv[0]; /* always at least ...*/
	argxc = 1;	    /*  ... one parameter  */

	/* get highest disk present */
	offset = bdos(CURDSK, 0); /* Get Logged in Disk */
	for (i = 0; (i < MAXDSKN) && _biosh(SELDSK, i); ++i)
		; /* keep cycling until NULL pointer to dpb */
	maxdisk = 'A' + i - 1; /* overcount by 1 */
	_biosh(SELDSK, offset); /* restore old Logged in disk for Default */

	if (argc >= 2)
		puts("Processing:");
	
	for (i=1; i < argc; ++i) {

		printf("\n\t%s", argv[i]);

		if (*argv[i] == PARMPREFIX) { /* param list is taken straight */
			argxv[argxc++] = argv[i];
			if (argc >= MAXARG)
				goto oops; /* print message & break out */
			continue;
		}

		/* Must be ufn or UNIX afn to get here */

		/* Test for legal disk designator */
		if (argv[i][1] == ':') {
			sprintf(dsk, "%c:", *argv[i]);
			if ((*dsk < 'A') || (*dsk > maxdisk)) {
				puts(": Illegal disk reference");
				continue;
			}
		}
		else
			*dsk = '\0';

		if (_ufn(argv[i])) {
			argxv[argxc++] = argv[i];
			if (argxc >= MAXARG) 
				goto oops; /* print message & break out */
			continue;
		}
					
		/* UNIX afn to get here */

		finper = amatch("*.", argv[i]); /* does it end in a '.' */

		/* set disk and set up fcb */
		strcpy(fname, dsk);
		setfcb(afcb, strcat(fname, "????????.???"));
			
		if ((offset = bdos(SRCH1, afcb)) == NOMORE) {
			puts(": Empty directory");
			continue;
		}
		do {
			strcpy(fname, dsk);
			_getfname(fname, offset);
			if (finper && !amatch("*.*", fname))
				strcat(fname, ".");
			if (amatch(argv[i], fname)) {
				if ((argxv[argxc] = alloc(strlen(fname) + 1)) == NULL) { /* + 1 needed for '\0' */
					puts("\nOut of memory\007\n");
					exit();
				}
				strcpy(argxv[argxc++], fname);
				if (argxc >= MAXARG) {
	oops:				printf("\nToo many arguments.\n\tpassing first %d args.\n", MAXARG);
					break;
				}
				printf("\n\t\t%s ", fname);
			}
		}
		while ((offset = bdos(SRCHN, afcb)) != NOMORE);
	}
	if (argxc >= 2)
		putchar('\n');
	mainp(argxc, argxv);

}

/* returns TRUE if fname is unambiguous (in the UNIX sense) */
int _ufn(fname)
char *fname;
{
	return(!amatch("*[*?[]*", fname)); /* I cheat a bit here */
}

/* concatenates the file name from the directory in the 
 * default buffer to the end of fname. Returns pointer to fname.
 */
int _getfname(fname, offset)
char *fname;
int offset; /* DIRNTRYSZ byte offset in sector buffer */
{
	char *chp, *temp;
	int i;

	temp = fname;
	for (; *fname; ++fname)
		; /* get to end of of fname - may already have "D:" */

	chp = offset * DIRNTRYSZ + BUFBASE + 1;
	for (i = 1; (i <= 8) && !isspace(*chp); ++i)
		*fname++ = *chp++;

	chp = offset * DIRNTRYSZ + BUFBASE + 9;
	if (!isspace(*chp)) { /* if there is an extension */
		*fname++ = '.'; /* put in '.' */
		for (i = 1; (i <= 3) && !isspace(*chp & '\177'); ++i)
			*fname++ = *chp++ & '\177'; /* get extension high bit off */
	}
	*fname = '\0'; /* terminate it */
	return(temp);
}

/* does bios call n with BC set to c. Returns HL. */
unsigned _biosh(n, c)
int n, c;
{
	int *ip;

	ip = BASE + 1;
	return(call(*ip + 3 * (n - 1), 0, 0, c, 0));
}
