/*>>> ALIENS.C	5/30/82	JCM <<<*/
/*
 * Aliens -- an animated video game
 *      the original version is from 
 *      Fall 1979                       Cambridge               Jude Miller
 *
 * Score keeping modified by Rob Cohen, BTL, June 1980.
 *
 * Concept of levels introduced, bugs fixed, point penalties added
 * by Alex Podlecki, WECo, 81-82.
 *
 * Adapted for BDS C (V1.44 or later) by Jeff Martin
 *			Naperville, Il		May 30, 1982
 *
 * Console I/O rewritten to use BIOS calls instead of CIO
 * direct port I/O.  Also added joy stick routines which are
 * commented out in the standard version.  See ALIENS11.DOC for
 * customization instructions.
 *           June 7, 1982           Don Wilkes, K4ZYP
 *
 *	As distributed, this program is set up for the H19 terminal.
 *
 *	To compile:
 *		CC1 ALIENS.C
 *	To link:
 *		CLINK ALIENS 
 *	or,
 *		L2 ALIENS
 *
 *	Then patch the com file for your console customization.
 */

#include <a:bdscio.h>

/* defines */

#define LEFT ','
#define LLEFT 'z'
#define RIGHT '/'
#define LRIGHT 'c'
#define HALT '.'
#define LHALT 'x'
#define FIRE ' '
#define DELETE '\177'
#define ABORT '\34'
#define QUIT 'q'
#define PAUSE '\23'
#define QQUIT '\3'
#define GAME1 '1'
#define GAME2 '2'
#define GAME3 '3'
#define GAME4 '4'
#define GAME5 '5'
#define GAME6 '6'
#define BOMB_MAX 10
#define BOMB_ROW 20
#define MINCOL 1
#define OVERUN 10
#define DEATH 25

/* global variables */

char cursadr[10];	/* cursor addressing string */
char curson[10];	/* cursor on string */
char cursoff[10];	/* cursoff string */
char clrscrn[10];	/* clear screen string */
char rowadd;		/* number to add to row */
char coladd;		/* number to add to col. */
char rowpos;
char colpos;
char key;
int scores,bases,game;
int i,j,danger,max_danger;
int flip,flop,left,al_num,b;
int al_cnt, bmb_cnt, bmb_max, spread;
int slow;
int level;
int barrinit[4][81];
int barr[4][81];
char command;
char name[9][15];
char posnstr[10];
char message[100];
struct
{
	int row;
	int col;
}
al[55];
struct {
	int row;
	int col;
	int vel;
} bas;
struct {
	int row;
	int col;
} bem;
struct {
	int row;
	int col;
}bmb[BOMB_MAX];
struct {
	int val;
	int col;
	int vel;
}shp;

/*
 * main -- scheduler and main entry point for aliens
 */

main(argc,argv)
int argc;
char *argv[];

{
	level = 0;
	if (argc > 1) {
		if (!isdigit(argv[1][0]))
			usage();
		level = argv[1][0] - '0';
	}
	main1();
}

/*	main program loop and replay entry point */

main1()
{
	srand(0);  /* start rand randomly */
	init();
	while (1)
	{
		tabl();
		while (1)
		{
			poll();
			beam();
			beam();
			beam();
			base();
			bomb();
			ship();
			if ( game != 4 )
				alien();
			if ( game == 2 )
				alien();
			alien();
			if ((al_cnt == 0) && (bmb_cnt == 0))
				break;
		}
		gauntlet();
	}
}
replay()
{	pos(23,0);
	main1();}

/*
 * usage -- error message for incorrect usage
 */

usage()
{
	puts("Usage: aliens <digit>\r\n");
	puts("\t<digit> is the level of difficulty from 0 to 9\r\n");
	puts("\tlevel 0 is the easiest and is the default\r\n");
	exit(1);
}

/*
 * init -- does global initialization
 */

init()
{

	scores = 0;
	bmb_cnt = 0;
	slow = 0;
	initw(barrinit[0], "0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0");
	initw(barrinit[1], "0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0");
	initw(barrinit[2], "0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0");
	initw(barrinit[3], "0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0");
	strcpy(name[0], "rookie");
	strcpy(name[1], "earthling");
	strcpy(name[2], "space cadet");
	strcpy(name[3],	"yeoman");
	strcpy(name[4],	"lieutenant");
	strcpy(name[5],	"commander");
	strcpy(name[6],	"captain");
	strcpy(name[7],	"admiral");
	strcpy(name[8],	"master assassin");

	/* do terminal dependent initialization */

	initpos();
	puts(cursoff);

	/* new game starts here */

	game = 0;
	instruct();
	while (game==0)
		poll();
	scores = 0;
	bases = 3;
	max_danger = 22;
	return;
}

/*
 * instructions -- print out instructions
 */

instruct()
{
	clr();
	pos(0,0);
	puts("Attention: Alien invasion in progress!\r\n\n");
	puts("        Type:   <,>     to move the laser base left\r\n");
	puts("                <z>     as above, for lefties\r\n");
	puts("                <.>     to halt the laser base\r\n");
	puts("                <x>     for lefties\r\n");
	puts("                </>     to move the laser base right\r\n");
	puts("                <c>     for lefties\r\n");
	puts("                <space> to fire a laser beam\r\n\n");
	puts("                <1>     to play \"Bloodbath\"\r\n");
	puts("                <2>     to play \"We come in peace\"\r\n");
	puts("                <3>     to play \"The Aliens strike back\"\r\n");
	puts("                <4>     to play \"Invisible Alien Weasels\"\r\n");
	puts("                <5>     to play \"Klinker\"\r\n");
	puts("                <6>     to play \"The Black Hole\"\r\n");
	puts("                <q>     to quit\r\n\n");
}

/*
 * tabl -- tableau draws the starting game tableau.
 */

tabl()
{
	clr();
	pos(0,0);
	sprintf(message,"Level:%2d ",level);
	puts(message);
	sprintf(message,"Score: %-5d ",scores);
	puts(message);
	switch (game) {
	case 1:
		puts("               B L O O D B A T H             ");
		break;
	case 2:
		puts("        W E  C O M E  I N  P E A C E !       ");
		break;
	case 3:
		puts("T H E   A L I E N S   S T R I K E   B A C K !");
		break;
	case 4:
		puts("I N V I S I B L E  A L I E N  W E A S E L S !");
		break;
	case 5:
		puts("              K L I N K E R                  ");
		break;
	case 6:
		puts("     T H E   B L A C K   H O L E !          ");
		break;
	}
	pos(0,70);
	if ( game >= 3 )
		sprintf(message,"Bases: %d",bases);
		puts(message);

	/* initialize alien co-ords, display */

	al_cnt = 55;
	danger = level + 11;
	if ( danger > max_danger )
		danger = max_danger;
	bmb_max = level + 5;
	if ( bmb_max > BOMB_MAX )
		bmb_max = BOMB_MAX;
	spread = level/2;
	for (j=0;j<=4;j++) {
		pos(danger-(2*j),0);
		for (i=0;i<=10;i++) {
			ds_obj(((i+j)&1)+(2*(j/2)));
			puts(" ");
			al[(11*j)+i].row = danger - (2*j);
			al[(11*j)+i].col = (6*i);
		}
	}
	al_num = 54;
	flip = 0;
	flop = 0;
	left = 0;

	/* initialize laser base position and velocity */

	bas.row = 23;
	bas.col = 72;
	if ( rand() < 10000 )
		bas.col = 1;
	bas.vel = 0;
	bem.row = 0;
	if ( game < 6 ) {
		pos(bas.row,bas.col);
		ds_obj(7);
	}

	/* initialize bomb arrays (row = 0 implies empty) */

	for (i=0;i<bmb_max;i++)
		bmb[i].row = 0;
	b = 0;
	bmb_cnt = 0;

	/* initialize barricades */

	for (i=0;i<=3;i++) {
		pos(i+19,0);
		for (j=0;j<80;j++) 
			if (barr[i][j]=barrinit[i][j])
				ds_obj(8);
			else
				puts(" ");
	}

	/* initialize mystery ships */

	shp.vel = 0;
	return;
}

/*
 * poll -- read input characters and set global flags
 */

poll()
{

	if (game==1) {
		if (bas.col>=(72-level))
			bas.vel = -1;
		if (bas.col<=1)
			bas.vel = 1;
	}
	if (!kbhit())
		return;
	command = getchar();
	switch (command & 0177) {       /* do case char */
	case LLEFT:
	case LEFT:
		if (game==1)
			break;
		bas.vel = -1;
		break;
	case LRIGHT:
	case RIGHT:
		if (game==1)
			break;
		bas.vel = 1;
		break;
	case LHALT:
	case HALT:
		if (game==1)
			break;
		bas.vel = 0;
		break;
	case FIRE:
		if (bem.row==0)
			bem.row = 22;
		break;
	case DELETE:
	case ABORT:
	case QUIT:
	case QQUIT:
		over();
		break;
	case GAME1:
		if (game!=0)
			break;
		game = 1;
		break;
	case GAME2:
		if (game!=0)
			break;
		game = 2;
		break;
	case GAME3:
		if (game!=0)
			break;
		game = 3;
		break;
	case GAME4:
		if (game!=0)
			break;
		game = 4;
		break;
	case GAME5:
		if (game!=0)
			break;
		game = 5;
		break;
	case GAME6:
		if (game!=0)
			break;
		game = 6;
		break;
	}
}


/*
 * clr -- issues an escape sequence to clear the display
 */

clr()
{
	puts(clrscrn);
}

/*
 * ds_obj -- display an object
 */

ds_obj(class)
int class;
{
	if ((game>=4)&&(class>=0)&&(class<=5))
		class = 6;
	switch (class) {
	case 0:
		puts(" OXO ");
		break;
	case 1:
		puts(" XOX ");
		break;
	case 2:
		puts(" \\o/ ");
		break;
	case 3:
		puts(" /o\\ ");
		break;
	case 4:
		puts(" \"M\" ");
			break;
	case 5:
		puts(" wMw ");
		break;
	case 6:
		puts("     ");
		break;
	case 7:
		puts(" xx|xx ");
		break;
	case 8:
		if ( game >= 5 ) break;
		puts("#");
		break;
	}
}

/*
 * base -- move the laser base left or right
 */

base()
{
	if ( bas.vel == 0 )
		return;
	bas.col += bas.vel;
	if ( bas.col < 1 ) {
		bas.col = 1;
		bas.vel = 0;
	}
	else if ( bas.col > 72 ) {
		bas.col = 72;
		bas.vel = 0;
	}
	if ( game < 6 ) {
		pos(bas.row,bas.col);
		ds_obj(7);
	}
}

/*
 * beam -- activate or advance the laser beam if required
 */

beam()
{
	int points;

	/* display beam */

	switch (bem.row) {
	case 23:
	case 0:
		pos(21,bem.col); /* Kill some time */
		puts("");
		pos(21,bem.col); /* Kill some time */
		puts("");
		pos(21,bem.col); /* Kill some time */
		puts("");
		return;		
	case 22:
		bem.col = bas.col + 3;
		pos(22,bem.col);
		puts("|");
		break;
	default:
		pos(bem.row,bem.col);
		puts("|");
		pos(bem.row+1,bem.col);
		puts(" ");
		break;
	}

	/* check for contact with an alien */

	for (i=0;i<55;i++) {
		if ((al[i].row==bem.row)&&((al[i].col+1)<=bem.col)
			&&((al[i].col+3)>=bem.col)) {

			/* contact! */

			points = 1 + (i/22) + (level*(i/11));
			if (game != 1)
				points = points - slow;
			if (points <= 1)
				points = 1;
			scores += points;
			scoreit();
			pos(bem.row+1,bem.col);
			puts(" ");
			if (game >= 4)
				puts("\07");
			pos(al[i].row,al[i].col);
			ds_obj(6);      /* erase beam and alien */
			bem.row=0;
			al[i].row=0;    /* clear beam and alien state */
			al_cnt--;
			return;
		}
	}

	/* check for contact with a bomb */

	for (i=0;i<bmb_max;i++) {
		if ((bem.row==bmb[i].row)&&(bem.col==bmb[i].col)) {
			pos(bem.row,bem.col);
			puts(" ");
			pos(bem.row+1,bem.col);
			puts(" ");
			bem.row = 0;
			bmb_cnt--;
			bmb[i].row = 0;
			return;
		}
	}

	/* check for contact with a barricade */

	if ((bem.row>=19)&&(bem.row<=22)&&(barr[bem.row-19][bem.col]))
	{
		pos(bem.row,bem.col);
		if ( game == 2 )
			ds_obj(8);
		else {
			barr[bem.row-19][bem.col] = 0;
			puts(" ");
		}
		if ( bem.row != 22 )
			pos(bem.row+1,bem.col);
			puts(" ");
		bem.row = 0;
		return;
	}

	/* check for contact with a mystery ship */

	if ((shp.vel!=0)&&(bem.row==1)&&(bem.col>(i=shp.col-shp.vel))
		&&(bem.col<i+7)) {

		/* contact! */

		pos(1,i);
		puts(" <BOOM!> \07");
		pos(1,i);
		puts("        ");    /* erase ship */
		shp.vel = 0;
		scores += shp.val/3;
		scoreit();
		pos(2,bem.col);
		puts(" ");
		bem.row = 0;
		return;
	}

	/* check for air ball */

	if ((--bem.row)==0) {
		pos(1,bem.col);
		puts(" ");
		pos(2,bem.col);
		puts(" ");
		scores -= (level + 1);
		scoreit();
	}
	return;
}

/*
 * bomb -- advance all active bombs
 */

bomb()
{

	for ( b=0; b<bmb_max; b++) {
		if ( bmb_cnt == 0 )
			return;
		if ( bmb[b].row == 0 )
			continue;

		/* advance bomb, check for hit and display */

		bmb[b].row++;
		if (bmb[b].row==23) {
			pos(bmb[b].row-1,bmb[b].col);
			puts(" ");
			bmb[b].row = 0;
			if ((bmb[b].col>bas.col)&&
				(bmb[b].col<=(bas.col+5))) {

				/* the base is hit! */

				if ( game > 5 ) {
					pos(bas.row,bas.col);
					ds_obj(7);
				}
				bases--;
				pos(0,70);
				sprintf(message,"Bases: %d",bases);
				puts(message);
				scores -= DEATH;
				scoreit();
				if (bases==0) {
					replay(); /* game is over */
				}
				sleep(20);
				pos(23,bas.col);
				puts("       ");
				bas.col = 72;
				if ( rand() < 13000 )
					bas.col = 1;
				if ( game < 6 ) {
					pos(23,bas.col);
					ds_obj(7);
				}
			}
			continue;
		}
		if((bmb[b].row>=19)&&(bmb[b].row<23)
			&&(barr[bmb[b].row-19][bmb[b].col])) {

			/* the bomb has hit a barricade */

			pos(bmb[b].row-1,bmb[b].col);
			puts(" ");
			pos(bmb[b].row,bmb[b].col);
			puts(" ");
			barr[bmb[b].row-19][bmb[b].col] = 0;
			bmb[b].row = 0;
			bmb_cnt--;
			continue;
		}
		pos(bmb[b].row-1,bmb[b].col);
		puts(" ");
		if (bmb[b].row==23) {
			bmb_cnt--;
			bmb[b].row = 0;
		}
		else
			pos(bmb[b].row,bmb[b].col);
			puts("*");
	}
}

/*
 * ship -- create or advance a mystery ship if desired
 */

ship()
{
	int vs_cols;

	vs_cols = 80;
	if (shp.vel==0) {
		if ((i=rand())<96) {
			/* create a mystery ship */
			if (i<48) {
				shp.vel = 1;
				shp.col = MINCOL;
			}
			else {
				shp.vel = -1;
				shp.col = vs_cols - 8;
			}
			shp.val=90;
		}
	}
	else {

		/* update existing mystery ship */

		pos(1,shp.col);
		if (game<=3)   sprintf(message,"  <=%d=>  ",shp.val/3);
				puts(message);
		shp.val--;
		shp.col += shp.vel;
		if (((i=shp.col)>(vs_cols-8))||(i<MINCOL)) {

			/* remove ship */

			pos(1,shp.col-shp.vel);
			puts("        ");
			shp.vel = 0;
		}
	}
}

/*
 * alien -- advance the next alien
 */

alien()
{
	while (1) {
		if ((al_num = al_num + 1) >= 55) {
			if (al_cnt==0)
				return; /* check if done */
			flop = 0;
			if (flip) {
				left = 1 - left;
				flop = 1;
				flip = 0;
			}
			al_num = 0;
		}
		if ((i = al[al_num].row)>0)
			break;
	}
	if (i>=23) {

		/* game over, aliens have overrun base */

		scores -= OVERUN;
		scoreit();
		replay();
	}

	if (left)
		al[al_num].col--;
	else
		al[al_num].col++;
	if (((j = al[al_num].col)==0)||(j>=(75-slow-((3*level)/2))))
		flip = 1;
	pos(i,j);
	if (flop) {
		ds_obj(6);
		i = ++al[al_num].row;
		pos(i,j);
	}
	ds_obj(((j+(i/2))&1) + (2*(al_num/22)));

	/* check for contact with a barricade */

	if ((al[al_num].row>=19)&&(al[al_num].row<23)) {
		j=al[al_num].col;
		for (i=3;(i>=-1)&&(j+i>=0);i--)
			barr[al[al_num].row-19][al[al_num].col+i] = 0;
	}

	/* check for bomb release */

	if ((game==1)||(game==2))
		return;
	for (i=al_num-11;i>=0;i -= 11) {
		if (al[i].row!=0)
			return;
	}
	if ( (al[al_num].col >= (bas.col-spread) ) &&
	     (al[al_num].col <  (bas.col+3+spread) ) &&
	   (al[al_num].row<=BOMB_ROW)) {
		for (i=0;i<bmb_max;i++) {
			if (bmb[i].row==0) {
				bmb[i].row = al[al_num].row;
				bmb[i].col = al[al_num].col + 2;
				bmb_cnt++;
				break;
			}
		}
	}
}

/*
 * scoreit -- print current point total
 */

scoreit()
{
	pos(0,16);
	sprintf(message,"%d  ",scores);
	puts(message);
	return;
}

/*
 * gauntlet -- challenge player to tougher game
 */

gauntlet()
{

	clr();
	pos(10,10);
	sprintf(message,"Congratulations %s ",((level > 8) ? name[8] : name[level] ));
	puts(message);
	sprintf(message,"- you have won at level %d",level++);
	puts(message);
	pos(12,10);
	sprintf(message,"Now let's see how good you are at level %d",level);
	puts(message);
	sleep(50);
}

/*
 * over -- game over processing
 */

over()
{
	int savgam;

	/* display the barricades if they were invisible */

	if ( game >= 5 ) {
		savgam = game;
		game = 3;
		for ( i=0; i<=3; i++) {
			pos(i+19,0);
			for ( j=0; j<80; j++)
				if ( barr[i][j] == 1 )
					ds_obj(8);
				else
					 puts(" ");
		}
		game = savgam;
	}
		
	/* display the aliens if they were invisible */

	if (game>=4) {
		savgam = game;
		game = 3;       /* remove the cloak of invisibility */
		for (i=0;i<55;i++)   if (al[i].row!=0) {
			pos(al[i].row,al[i].col);
			ds_obj(((al[i].col+(al[i].row/2))&1) + (2*(i/22)));
		}
		game = savgam;
		sleep(50);
	}
	pos(22,0);
	puts(curson);
	exit();
}

/*	put string routine to replace the library routine */

puts(str)
char str[];
{
	int ii;
	ii=0;
	while(str[ii]){putchar(str[ii]);
	              ii++;}
}
 
/*
 * initpos -- This function is called at initialization time to set up
 *	the fixed part of the cursor positioning string.
 */

initpos()
{
	for (i=0;i<10;i++) { posnstr[i]=cursadr[i];
		if(posnstr[i]==0xFF) rowpos=i;
		if(posnstr[i]==0xFE) colpos=i;
		}
}

/*
 * pos -- positions cursor to a display position.  Row 0 is top-of-screen
 *      row 23 is bottom-of-screen.  The leftmost column is 0; the rightmost
 *      is 79.
 */

pos(row,col)
int row,col;
{
	posnstr[rowpos]=row+rowadd;
	posnstr[colpos]=col+coladd;
	puts(posnstr);
}

putchar(c) { return bios(4,c);}


getchar()
{
return(key);
}

kbhit()
{
if (bios(2) != 0) {key = bios(3);
                    return(1);}

/*	Joystick routines */

/*	commented out for standard version
key= ~inp(9);
if(key & 0x04){key= 0x2C;
                return(1);}
if(key & 0x08){key= 0x2F;
                return(1);}
if(key & 0x01){key= 0x6B;
                return(1);}
if(key & 0x02){key= 0x2E;
                return(1);}
if(key & 0x20) return (1);
*/
return(0);
}

