
;
;MBOOTOS.ASM
;
;streamlined version of MBOOT.ASM ver 3.0
;to run on OSBORNE 1 using memory-mappped
;I/O subroutines. 
;10/23/81  Jack Rubin
;
;CP/M - CP/M file transfer program (receive-only)
;
;This program is intended for use as a way to
;initially transfer MODEM.COM or MODEM.ASM to
;a new user.  It is configured for an external
;modem connected to the Osborne RS232 peripheral
;port. Be sure cable pins 2 and 3 are switched at
;the computer end (see OCC manual, chapter 8).
;
;A simple terminal routine at start of program allows
;user to communicate with a remote system prior to
;receiving a file to make it possible to down-load
;a file without intervention on the part of the host
;system's operator.
;
;COMMANDS:  MBOOT FILENAME.FILETYPE
; or  MBOOT A:FILENAME.FILETYPE
; or  MBOOT B:FILENAME.FILETYPE
;
;The program will operate as a dumb terminal until
;an 'ESC' key is typed (ctrl-[).  It then branches
;to the receive routine.  The user may also exit
;to CP/M without opening the receive file by typing
;ctrl-E from the terminal.  File transfer is via
;XMODEM protocol.
;
;NOTE: Comments for the source code and tabs have been
;removed to make this file easier to transport from one
;system to another. 
;
FALSE EQU 0
TRUE  EQU NOT FALSE
;
BASE EQU 0
;
EXITCHR EQU 05H ;CTL-E TO EXIT TERM MODE TO CP/M
ESC     EQU 1BH ;ESCAPE TO EXIT TERM MODE TO FILE RCVE
;
MODCTLP EQU 2A00H ;PUT YOUR MODEM CONTROL PORT HERE
MODSNDB EQU     2 ;YOUR BIT TO TEST FOR SEND
MODSNDR EQU     2 ;YOUR VALUE WHEN READY
MODRCVB EQU     1 ;YOUR BIT TO TEST FOR RECEIVE
MODRCVR EQU     1 ;YOUR VALUE WHEN READY
MODDATP EQU 2A01H ;YOUR MODEM DATA PORT
;
ERRLIM EQU 10
;
SOH EQU 1
EOT EQU 4
ACK EQU 6
NAK EQU 15H
CAN EQU 18H
LF  EQU 10
CR  EQU 13
; 
BDOS EQU BASE+5
FCB  EQU BASE+5CH
;
 ORG BASE+100H
;
 LXI H,(DBUF)
 LXI D,4000H
 CALL MOVE128
 LXI H,0
 DAD SP
 SHLD STACK
 LXI SP,STACK
 CALL INITADR
 CALL ILPRT
 DB 'MBOOTOS as of 10/23/81',CR,LF,0
 LDA FCB+1
 CPI ' '
 JNZ TERMI
 CALL ILPRT
 DB '++NO FILE NAME SPECIFIED++',CR,LF,0
 JMP EXIT
;
TERMI CALL INITMOD
 CALL SIN
 CALL SIN
 CALL ILPRT
 DB CR,LF,'TERMINAL MODE',CR,LF
 DB 'BE SURE TO SETUP CORRECT BAUD RATE!!',CR,LF
 DB 'CTL-E exits to CP/M, ESC starts file transfer'
 DB CR,LF,0
;
TERM CALL STAT
 JZ TERML
 CALL KEYIN
 CPI EXITCHR
 JZ EXIT
 CPI ESC
 JZ RCVFIL
 CALL SOUT
;
TERML CALL SSTAT
;
 ANI MODRCVB
 CPI MODRCVR
 JNZ TERM
 CALL SIN
 ANI 7FH
 CALL TYPE
 JMP TERM
;
RCVFIL CALL ERASFIL
 CALL MAKEFIL
 CALL ILPRT
 DB 'FILE OPEN, READY TO RECEIVE',CR,LF,0
;
RCVLP CALL RCVSECT
 JC RCVEOT
 CALL WRSECT
 CALL INCRSNO
 CALL SENDACK
 JMP RCVLP
;
RCVEOT CALL WRBLOCK
 CALL SENDACK
 CALL CLOSFIL
 CALL ERXIT
 DB CR,LF,'TRANSFER COMPLETE$' 
;
RCVSECT XRA A
 STA ERRCT
;
RCVRPT MVI B,10
 CALL RECV
 JC RCVSERR
 CPI SOH
 JZ RCVSOH
 ORA A
 JZ RCVRPT
 CPI EOT
 STC
 RZ
;
RCVSERR MVI B,1
 CALL RECV
 JNC RCVSERR
 MVI A,NAK
 CALL SEND
 LDA ERRCT
 INR A
 STA ERRCT
 CPI ERRLIM
 JC RCVRPT
;
RCVSABT CALL CLOSFIL
 CALL ERXIT
 DB '++UNABLE TO RECEIVE BLOCK'
 DB CR,LF,'++ABORTING++$'
;
RCVSOH MVI B,1
 CALL RECV
 JC RCVSERR
 MOV D,A
 MVI B,1
 CALL RECV
 JC RCVSERR
 CMA
 CMP D
 JZ RCVDATA
 JMP RCVSERR
;
RCVDATA MOV A,D
 STA RCVSNO
 MVI C,0
 LXI H,BASE+80H
;
RCVCHR MVI B,1
 CALL RECV
 JC RCVSERR
 MOV M,A
 INR L
 JNZ RCVCHR
 MOV D,C
 MVI B,1
 CALL RECV
 JC RCVSERR
 CMP D
 JNZ RCVSERR
 LDA RCVSNO
 MOV B,A
 LDA SECTNO
 CMP B
 JZ RECVACK
 INR A
 CMP B
 JNZ ABORT
 RET
;
RECVACK CALL SENDACK
 JMP RCVSECT
;
SENDACK MVI A,ACK
;
SEND PUSH PSW
 ADD C
 MOV C,A
;
SENDW CALL SSTAT
;
 ANI MODSNDB
 CPI MODSNDR
 JNZ SENDW
 POP PSW
 CALL SOUT 
 RET
;
ABORT LXI SP,STACK
;
ABORTL MVI B,1
 CALL RECV
 JNC ABORTL
 MVI A,CAN
 CALL SEND
;
ABORTW MVI B,1
 CALL RECV
 JNC ABORTW
 MVI A,' '
 CALL SEND
 CALL ERXIT
 DB 'MBOOT PROGRAM CANCELLED$'
;
INCRSNO LDA SECTNO
 INR A
 STA SECTNO
 RET
;
ERASFIL LXI D,FCB
 MVI C,17
 CALL BDOS
 INR A
 RZ
 CALL ILPRT
 DB '++FILE EXISTS, TYPE Y TO ERASE: ',0
 CALL KEYIN
 PUSH PSW
 CALL TYPE
 CALL CRLF
 POP PSW
 ANI 5FH
 CPI 'Y'
 JNZ MXIT
 LXI D,FCB
 MVI C,19
 JMP BDOS
;
MAKEFIL LXI D,FCB
 MVI C,22
 CALL BDOS
 INR A
 RNZ
 CALL ERXIT
 DB '++ERROR - CAN''T MAKE FILE',CR,LF
 DB '++DIRECTORY MUST BE FULL$'
;
CLOSFIL LXI D,FCB
 MVI C,16
 CALL BDOS
 INR A
 RNZ
 CALL ERXIT
 DB '++CAN''T CLOSE FILE$'
;
WRSECT LHLD SECPTR
 XCHG
 LXI H,BASE+80H
 CALL MOVE128
 XCHG
 SHLD SECPTR
 LDA SECINBF
 INR A
 STA SECINBF
 CPI 16
 RNZ
;
WRBLOCK LDA SECINBF
 ORA A
 RZ
 MOV C,A
 LXI D,DBUF
;
DKWRLP PUSH H
 PUSH D
 PUSH B
 MVI C,26
 CALL BDOS
 LXI D,FCB
 MVI C,21
 CALL BDOS
 POP B
 POP D
 POP H
 ORA A
 JNZ WRERR
 LXI H,80H
 DAD D
 XCHG
 DCR C
 JNZ DKWRLP
 XRA A
 STA SECINBF
 LXI H,DBUF
 SHLD SECPTR
;
RSDMA LXI D,BASE+80H
 MVI C,26
 JMP BDOS
;
WRERR CALL RSDMA
 CALL ILPRT
 DB '++ERROR WRITING FILE',CR,LF,0
 JMP ABORT
;
RECV PUSH D
;
 MOV A,B
 ADD A
 MOV B,A
;
MSEC LXI D,50000
;
MWTI CALL SSTAT
;
 ANI MODRCVB
 CPI MODRCVR
 JZ MCHAR
 DCR E
 JNZ MWTI
 DCR D
 JNZ MWTI
 DCR B
 JNZ MSEC
 POP D
 STC
 RET
;
MCHAR CALL SIN
 POP D
 PUSH PSW
 ADD C
 MOV C,A
 POP PSW
 ORA A
 RET
;
INITADR LHLD BASE+1
 LXI D,3
 DAD D
 SHLD VSTAT+1
 DAD D
 SHLD VKEYIN+1
 DAD D
 SHLD VTYPE+1
 RET
;
INITMOD EQU $
;
 RET  ;<--THIS RET MUST BE HERE
;
CRLF MVI A,CR
 CALL TYPE
 MVI A,LF
;
TYPE PUSH PSW
 PUSH B
 PUSH D
 PUSH H
 MOV C,A
VTYPE CALL $-$
 POP H
 POP D
 POP B
 POP PSW
 RET
;
STAT PUSH B
 PUSH D
 PUSH H
VSTAT CALL $-$
 POP H
 POP D
 POP B
 ORA A
 RET
;
KEYIN PUSH B
 PUSH D
 PUSH H
VKEYIN CALL $-$
 POP H
 POP D
 POP B
 ANI 7FH
 RET
;
ILPRT XTHL
;
ILPLP MOV A,M
 ORA A
 JZ ILPRET
 CALL TYPE
 INX H
 JMP ILPLP
;
ILPRET XTHL
 RET
;
ERXIT POP D
 MVI C,9
 CALL BDOS
;
MXIT CALL ILPRT
 DB CR,LF,'DON''T FORGET TO DISCONNECT MODEM'
 DB CR,LF,0
;
EXIT LHLD STACK
 SPHL
 RET
;
MOVE128 MVI B,128
;
MOVE MOV A,M
 STAX D
 INX H
 INX D
 DCR B
 JNZ MOVE
 RET
;
RCVSNO DB 0
SECTNO DB 0
ERRCT DB 0
EOFLG DB 0
SECPTR DW DBUF
SECINBF DB 0
 DS 60
STACK DS 2
DBUF EQU $
;
OFSET EQU 4000H-$
;
SIN EQU $+OFSET
 DI
 OUT 0
 MOV B,A
 LDA 2A01H
 OUT 1
 EI
 RET
;
SOUT EQU $+OFSET
 DI
 OUT 0
 MOV B,A
 STA 2A01H
 OUT 1
 MOV A,B
 EI
 RET
;
SSTAT EQU $+OFSET
 DI
 OUT 0
 LDA 2A00H
 OUT 1
 EI
 RET
;
 END

DONE
